package com.yizhi.exam.application.vo;

import java.math.BigDecimal;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 试题列表
 * 
 * @author bob
 *
 */
@ApiModel(value = "ExamQuestionVO", description = "试题列表")
@Data
public class ExamQuestionVO {

	@ApiModelProperty(value = "考试题目Id")
	private Long id;

	@ApiModelProperty(value = "考试主键ID")
	private Long examId;

	@ApiModelProperty(value = "题目主键ID")
	private Long subjectId;

	@ApiModelProperty(value = "题干，题目内容")
	private String stem;

	@ApiModelProperty(value = "分数")
	private BigDecimal score;

	@ApiModelProperty(value = "试题题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "排序")
	private Integer sort;

	@ApiModelProperty(value = "0删除 1有效，默认1")
	private Integer state;

	@ApiModelProperty(value = "试题")
	private List<QuestionLibrarySubjectVO> questionLibrarySubjectVOS;

	@ApiModelProperty(value = "用户_ID")
	private Long accountId;

	@ApiModelProperty(value = "用户_用户名")
	private String accountName;

	@ApiModelProperty(value = "企业_ID")
	private Long companyId;

	@ApiModelProperty(value = "部门_ID")
	private Long orgId;

	@ApiModelProperty(value = "站点_ID")
	private Long siteId;

	@ApiModelProperty(value = "题库ID")
	private Long libraryId;

}
