/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: QuestionLibrarySubjectVO
 * Author:   phone
 * Date:     2018/3/14 15:23
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.vo;

import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 〈一句话功能简述〉<br>
 * 〈〉
 *
 * @author phone
 * @create 2018/3/14
 * @since 1.0.0
 */
@ApiModel(value = "QuestionLibrarySubjectVO", description = "试题")
@Data
public class QuestionLibrarySubjectVO {

	@ApiModelProperty(value = "主键")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long id;

	@ApiModelProperty(value = "题库_ID主键，外键")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long libraryId;

	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "标签，如：金融，保险等（允许为空）可设置标签，最多设置5个，只支持文本，最多输入10个汉字。")
	private String questionLabel;

	@ApiModelProperty(value = "题干，题目内容")
	private String stem;

	@ApiModelProperty(value = "题干附件路径，支持上传附件（图片、音频、视频），存放路径")
	private String stemAppendixUrl;

	@ApiModelProperty(value = "题目解析，只支持文本")
	private String analysis;

	@ApiModelProperty(value = "评分说明，允许为空（文本），对题型是问答题有效")
	private String scoreRule;

	@ApiModelProperty(value = "选项列表")
	private List<QuestionSubjectOptionVO> questionSubjectOptionVOList;

	@ApiModelProperty(value = "考试试题所用分数")
	private BigDecimal score;

}