package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *考试报表入库类
 * </p>
 *
 * @author dingxiaowei123
 * @since 2018-08-01
 */
@ApiModel(value = "StatisticsExamMetadata", description = "考试每天信息统计")
@Data

public class StatisticsExamMetadata  {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "自增")
    
    private Long id;

    @ApiModelProperty(value = "考试ID")
    
    private Long examId;

    
    private String examNo;

    
    private String examName;

    @ApiModelProperty(value = "考试开始时间")
    
    private Date examStartTime;

    @ApiModelProperty(value = "考试结束时间")
    
    private Date examEndTime;

    @ApiModelProperty(value = "创建考试的企业ID")
    
    private Long examCompanyId;

    @ApiModelProperty(value = "创建考试的站点ID")
    
    private Long examSiteId;

    @ApiModelProperty(value = "创建考试的组织ID")
    
    private Long examOrgId;

    @ApiModelProperty(value = "考试创建时间")
    
    private Date examCreateTime;

    @ApiModelProperty(value = "用户ID")
    
    private Long accountId;
    
    @ApiModelProperty(value = "工号")
    
    private String workNum;

    @ApiModelProperty(value = "用户名")
    
    private String accountName;

    @ApiModelProperty(value = "姓名")
    
    private String accountFullname;

    @ApiModelProperty(value = "用户状态")
    
    private Integer accountState;

    @ApiModelProperty(value = "学员企业ID")
    
    private Long accountCompanyId;

    @ApiModelProperty(value = "学员站点ID")
    
    private Long accountSiteId;

    @ApiModelProperty(value = "学员组织ID")
    
    private Long accountOrgId;

    @ApiModelProperty(value = "所在部门")
    
    private String orgName;

    @ApiModelProperty(value = "部门所有父节点名称")
    
    private String orgParentNames;

    @ApiModelProperty(value = "应参加状态，1应参加 0不应参加（用于统计：应参加人数，MAX取值）")
    
    private Integer canState;

    @ApiModelProperty(value = "实际参加状态，1参加 0未参加（用于统计：实参加人数，MAX取值）")
    
    private Integer joinState;

    @ApiModelProperty(value = "考试次数，（当天多次考试的合计数量，SUM取值）")
    
    private Integer examCount;

    @ApiModelProperty(value = "最早交卷时间，（当天多次考试取最早交卷）")
    
    private Date firstFinishTime;

    @ApiModelProperty(value = "最迟交卷时间")
    
    private Date lastFinishTime;

    @ApiModelProperty(value = "考试分数（当天多次考试取最高的）")
    private BigDecimal score;

    @ApiModelProperty(value = "考试结果，（当天多次考试只要通过一次视全部通过，1通过 0未通过。用于统计：通过人数，MAX取值）")
    
    private Integer examState;

    @ApiModelProperty(value = "学员答卷创建时间（多次考试取最早的一次）")
    
    private Date accountAnswerCreateTime;

    @ApiModelProperty(value = "获取的积分")
    
    private Integer point;

    @ApiModelProperty("考试总时长")
    private Long sumDuration;


}
