package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 试题类型排序（类型为：题型排序，有效）
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrExamQuestionSort", description = "试题类型排序（类型为：题型排序，有效）")
@Data

public class TrExamQuestionSort  {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "题型排序ID，主键")
	private Long id;

	@ApiModelProperty(value = "考试主键_ID，外键")
	
	private Long examId;

	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "按排序显示")
	private Integer sort;

	@ApiModelProperty(value = "创建时间")
	
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;

}