package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 系统出题规则
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrExamSystemQuestion", description = "系统出题规则")
@Data

public class TrExamSystemQuestion {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "系统出题规则ID，主键")
	private Long id;

	@ApiModelProperty(value = "考试主键_ID，外键")
	
	private Long examId;

	@ApiModelProperty(value = "题库ID主键，外键")
	
	private Long libraryId;

	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "抽题数量")
	private Integer num;

	@ApiModelProperty(value = "总分数")
	private BigDecimal score;

	@ApiModelProperty(value = "状态，0删除 1有效，默认1")
	private Integer state;

	@ApiModelProperty(value = "创建时间")
	
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;

}