package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 题目
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrQuestionLibrarySubject", description = "题目")
@Data

public class TrQuestionLibrarySubject  {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "题库_ID主键，外键")
	
	private Long libraryId;

	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "标签，如：金融，保险等（允许为空）可设置标签，最多设置5个，只支持文本，最多输入10个汉字。")
	
	private String questionLabel;
	
	@ApiModelProperty(value = "状态，0删除 1未使用 1已使用，默认1")
	private Integer state;

	@ApiModelProperty(value = "题干，题目内容")
	private String stem;

	@ApiModelProperty(value = "题干附件路径，支持上传附件（图片、音频、视频），存放路径")
	
	private String stemAppendixUrl;

	@ApiModelProperty(value = "题目解析，只支持文本")
	private String analysis;

	@ApiModelProperty(value = "评分说明，允许为空（文本），对题型是问答题有效")
	
	private String scoreRule;

	@ApiModelProperty(value = "原题库ID")
	
	private Long oldLibraryId;

	@ApiModelProperty(value = "创建时间")
	
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;

	@ApiModelProperty(value = "企业_ID")
	
	private Long companyId;

	@ApiModelProperty(value = "部门_ID")
	
	private Long orgId;

	@ApiModelProperty(value = "站点_ID")
	
	private Long siteId;

}