package com.yizhi.application.cache;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableAutoConfiguration
public class RedisCacheManagerExConfig {

	@Autowired
	private RedisConnectionFactory redisConnectionFactory;
	@Autowired
	private RedisTemplate redisTemplate;

	@Bean
	public RedisCacheManagerEx cacheManager(RedisTemplate<?, ?> redisTemplate) {
		RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter(redisConnectionFactory);
		RedisCacheManagerEx cacheManager = new RedisCacheManagerEx(redisCacheWriter);
		return cacheManager;
	}
	
}
