package com.yizhi.application.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.domain.TrExamPoint;
import com.yizhi.application.service.*;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.exam.ExamIdVO;
import com.yizhi.exam.application.vo.exam.ExamView;
import com.yizhi.exam.application.vo.exam.QuestionSortVO;
import com.yizhi.exam.application.vo.exam.VisibleRangeExport;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试 前端控制器
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@RestController
@RequestMapping("/manage/exam")
public class ExamController {

    private static final Logger LOG = LoggerFactory.getLogger(ExamController.class);

    @Autowired
    private IExamService iExamService;

    @Autowired
    private ITrExamAuthorizeService iTrExamAuthorizeService;

    @Autowired
    private ITrExamAnswerService iTrExamAnswerService;

    @Autowired
    ITrExamQuestionService trExamQuestionService;

    @Autowired
    ITrExamSystemQuestionService iTrExamSystemQuestionService;

    @Autowired
    ITrQuestionLibrarySubjectService iTrQuestionLibrarySubjectService;

    @Autowired
    ITrExamScoreEvaluateService iTrExamScoreEvaluateService;

    @Autowired
    ITrExamPointService iTrExamPointService;

    @Autowired
    ITrExamRemindService iTrExamRemindService;

    /**
     * 显示考试信息列表
     *
     */
    @GetMapping("/list")
    public Map<String, Object> getExamList(@RequestParam(value = "currentTime", required = false) String currentTime,
                                           @RequestBody ContextAndPageSizeVO contextAndPageSizeVO) {
        List<ExamDetailsVO> listvo; // 细节对象数组
        Map<String, Integer> page;
        Integer sumNum = 0;
        Map<String, Object> map = null;
        try {
            List<Exam> list = iExamService.examList(currentTime, contextAndPageSizeVO.getName(), contextAndPageSizeVO.getState(),
                    contextAndPageSizeVO.getPageSize(), contextAndPageSizeVO.getPageNo(), contextAndPageSizeVO.getCompanyId(), contextAndPageSizeVO.getSiteId(), contextAndPageSizeVO.getOrgIds()).getRecords(); // 实体总记录数目
            if (null != list && list.size() > 0) {
                listvo = new ArrayList<ExamDetailsVO>();
                ExamDetailsVO examDetailsVo = null;
                for (int i = 0; i < list.size(); i++) {
                    examDetailsVo = new ExamDetailsVO();
                    examDetailsVo.setId(list.get(i).getId());
                    examDetailsVo.setExamNo(list.get(i).getExamNo());
                    examDetailsVo.setName(list.get(i).getName());
                    examDetailsVo.setStartTime(list.get(i).getStartTime());
                    examDetailsVo.setEndTime(list.get(i).getEndTime());
                    examDetailsVo.setUpdateTime(list.get(i).getUpdateTime());
                    examDetailsVo.setUpTime(list.get(i).getUpTime());
                    examDetailsVo.setDownTime(list.get(i).getDownTime());
                    examDetailsVo.setVisibleRange(list.get(i).getVisibleRange());
                    examDetailsVo.setKeywords(list.get(i).getKeywords());
                    examDetailsVo.setImage(list.get(i).getImage());
                    listvo.add(examDetailsVo);
                }
                sumNum = iExamService.sumNum(currentTime, contextAndPageSizeVO.getName(), contextAndPageSizeVO.getState(), contextAndPageSizeVO.getCompanyId(), contextAndPageSizeVO.getSiteId(), contextAndPageSizeVO.getOrgIds());

                page = new HashMap<String, Integer>();
                page.put("pageNo", contextAndPageSizeVO.getPageNo());
                page.put("pageSize", contextAndPageSizeVO.getPageSize());
                page.put("pageTotal", sumNum);
                map = new HashMap<String, Object>();
                map.put("listvo", listvo);
                map.put("page", page);
                return map;
            }
        } catch (Exception e) {
            LOG.error("服务出错。", e);
            return map;
        }
        return map;
    }

    @GetMapping("/experiencePoolList")
    Page<Map<String, Object>> getPoolExamList(@RequestParam(value = "name", required = false) String name,
                                              @RequestParam(value = "ids", required = false) List<Long> ids,
                                              @RequestParam(value = "pageNo", required = false) Integer pageNo,
                                              @RequestParam(value = "pageSize", required = false) Integer pageSize
    ) {
        return iExamService.getPoolExamList(name, ids, pageNo, pageSize);
    }


    @GetMapping("/count/list")
    public Map<String, Object> countList(
            @RequestParam(name = "name", required = false) String name,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @RequestParam(name = "companyId", required = false) Long companyId) {
        Map<String, Object> map = null;
        //只阅卷有问答题的考试，分页查询
        PageHelper.startPage(pageNo, pageSize);
        List<Exam> list = iExamService.selectExamList(name, companyId); // 实体类数据
        int pageTotal = PageHelper.freeTotal();

        List<ExamDetailsMarkingVO> listVo = null;
        if (!CollectionUtils.isEmpty(list)) {
            listVo = new ArrayList<ExamDetailsMarkingVO>(); // 小的vo类

            //拷贝对象
            ExamDetailsMarkingVO edmv = null;
            for (Exam exam : list) {
                edmv = new ExamDetailsMarkingVO();
                BeanUtils.copyProperties(exam, edmv);
                //初始化人数为0
                edmv.setCommitExamNum(0);
                edmv.setShouldExamNum(0);

                //获取应考人数
                if (exam.getVisibleRange() == 1) { // 平台用户可见
                    // 得到站点人员id，调用外部接口
                    edmv.setShouldExamNum(0);
                } else if (exam.getVisibleRange() == 2) { // 指定用户可见
                    edmv.setShouldExamNum(iTrExamAuthorizeService.getShouldExamNum(exam.getId())); // 考试编号id给
                }
                // 已经提交人员
                edmv.setCommitExamNum(iTrExamAnswerService.getCommitNum(edmv.getId()));
                listVo.add(edmv);
            }

            Map<String, Integer> page = new HashMap<String, Integer>();
            page.put("pageNo", pageNo);
            page.put("pageSize", pageSize);
            page.put("pageTotal", pageTotal);
            map = new HashMap<String, Object>();
            map.put("list", listVo);
            map.put("page", page);
            return map;
        } else {
            return map;
        }
    }

    @PostMapping("/deletes")
    public Boolean deleteExam(
            @RequestBody Long[] idArr) {
        boolean b = false;
        if (idArr.length > 0) {
            b = iExamService.deleteExam(idArr);
            return b;
        }
        return b;
    }

    @PostMapping("/put/up")
    public Boolean examPutUp(
            @RequestBody ExamIdVO examIdVO) {
        boolean b = false;
        if (examIdVO.getExamId() != null) {
            b = iExamService.examPutUp(examIdVO.getExamId());
            return b;
        }
        return b;
    }

    @PostMapping("/put/down")
    public Boolean examPutDown(
            @RequestBody ExamIdVO examIdVO) {
        boolean b = false;
        if (examIdVO.getExamId() != null) {
            b = iExamService.examPutDown(examIdVO.getExamId());
            return b;
        }
        return b;
    }

    @PostMapping("/export/answer")
    public List<QuestionExamVO> exportAnswer(Long examId) {
        List<QuestionExamVO> list = null;
        if (examId != null) {
            list = iExamService.exportAnswer(examId);
            return list;
        }
        return list;
    }

    @PostMapping("/count/account")
    public Map<String, Object> getExamAnswers(
            @RequestParam(name = "examId", required = true) Long examId,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @RequestParam(name = "accountIdList", required = false) List<Long> accountIdList,
            @RequestParam(name = "orgIdList", required = false) List<Long> orgIdList,
            @RequestParam(name = "state", required = false) Integer state,
            @RequestParam(name = "tstart", required = false) String tstart,
            @RequestParam(name = "tend", required = false) String tend
    ) {
        Map<String, Object> map = null;
        try {
            List<ExamAnswerVO> ExamAnswerVOS = iTrExamAnswerService.selectExamAnswerByExamId(accountIdList, orgIdList, state, tstart, tend, examId, pageNo, pageSize);
            System.out.println(ExamAnswerVOS.size());
            ExamAnswerVO examAnswerVO = null;
            Long total = (long) ExamAnswerVOS.size();
            for (int i = 0; i < total; i++) {
                examAnswerVO = ExamAnswerVOS.get(i);
                //此次调用用户这边接口，根据
                //examAnswerVO.getAccountId()获得id，找到用户名，姓名
                //examAnswerVO.getOrgId()获得组织id，找到用户组织名称
                examAnswerVO.setRealName(null);
                examAnswerVO.setName(null);
                examAnswerVO.setOrgName(null);
            }
            Map<String, Integer> page = new HashMap<String, Integer>();
            page.put("pageSize", pageSize);
            page.put("pageNo", pageNo);
            page.put("pageTotal", iTrExamAnswerService.selectTotal(accountIdList, orgIdList, state, tstart, tend, examId));
            map = new HashMap<String, Object>();
            map.put("list", ExamAnswerVOS);
            map.put("page", page);
            return map;
        } catch (Exception e) {
            LOG.error("", e);
            e.printStackTrace();
            return map;
        }
    }

    /**
     * 导入考试试题
     *
     */
    @PostMapping(value = "/question/export")
    public Boolean insertByFile(@RequestParam String fileDir, @RequestParam String fileName, @RequestParam Long id) {
        Boolean b = false;
        try {
            b = iExamService.importExamFile(fileDir, fileName, id);
            return b;
        } catch (Exception e) {
            LOG.error("", e);
            return b;
        }

    }

    @GetMapping(value = "/view/info")
    public com.yizhi.exam.application.vo.domain.Exam examViewInfo(Long examId) {
        //1.调用 examId 获得exam实体
        com.yizhi.exam.application.vo.domain.Exam exam = iExamService.getExam(examId);
        return exam;
    }

    /**
     * 添加试题排序
     */
    @PostMapping(value = "/insert/question/sort")
    public boolean insertQuestionSort(@RequestBody QuestionSortVO questionSortVO) {
        if (questionSortVO == null) {
            return false;
        }
        if (questionSortVO.getStemSort() == null) {
            questionSortVO.setStemSort(1);
        }
        if (questionSortVO.getOptionSort() == null) {
            questionSortVO.setOptionSort(1);
        }
        if (questionSortVO.getTypeSort() == null) {
            questionSortVO.setTypeSort(1);
        }
        boolean result = iExamService.updateQuestionSort(questionSortVO);
        return result;
    }

    @GetMapping("/view")
    public ExamViewVO selectExam(@RequestParam("examId") Long examId) {
        ExamView examView = iExamService.selectExam(examId);
        ExamViewVO examViewVo = new ExamViewVO();
        BeanUtils.copyProperties(examView, examViewVo);

        if (examView.getRemind() != null && examView.getRemind() == 1) {
            TrExamRemindVO trExamRemindVO = iTrExamRemindService.listTrExamRemind(examId);
            if (trExamRemindVO != null) {
                List<TrExamRemindTimeVO> trExamRemindTimeVoList = trExamRemindVO.getTrExamRemindTimeVoList();
                if (trExamRemindTimeVoList != null) {
                    for (TrExamRemindTimeVO item : trExamRemindTimeVoList) {
                        if (item.getType() == 3) {
                            item.setTriggerTime(null);
                        } else {
                            item.setCustomDate("");
                        }
                    }
                    examViewVo.setMessageVO(trExamRemindVO);
                }
            }
        }

        return examViewVo;
    }

    @GetMapping("/info")
    public com.yizhi.exam.application.vo.domain.Exam selectExamById(Long examId) {
        return iExamService.getExamByExamId(examId);
    }

    @GetMapping("/search")
    public Page<Exam> selectExamLikeName(@RequestParam(name = "keyWord", required = false) String keyWord,
                                         @RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize,
                                         @RequestParam(name = "accountId", required = true) Long accountId,
                                         @RequestParam(name = "companyId", required = true) Long companyId,
                                         @RequestParam(name = "siteId", required = true) Long siteId, @RequestParam(name = "orgId", required = true) Long orgId) {
        Page<Exam> pageExam = iExamService.selectExamLikeName(keyWord, pageNo, pageSize, accountId, companyId, siteId, orgId);
        return pageExam;
    }

    @GetMapping("/point")
    public List<TrExamPoint> selectExamPointInfo(
            @RequestParam(name = "examId", required = true) Long examId,
            @RequestParam(name = "companyId", required = true) Long companyId,
            @RequestParam(name = "siteId", required = true) Long siteId, @RequestParam(name = "orgId", required = true) Long orgId) {
        return iExamService.selectExamPointInfo(examId, companyId, siteId, orgId);
    }

    /**
     * 根据考试名称获取考试列表
     */
    @GetMapping("/listByName")
    public List<Exam> selectExamListByName(@RequestBody ContextAndPageSizeVO contextAndPageSizeVO) {
        LOG.info("***************************************************************查询考试阅卷列表*****************************************");
        return iExamService.selectExamListByName(contextAndPageSizeVO);
    }

    /**
     * 根据考试统计考试列表
     */
    @GetMapping("/selectExamListBySta")
    public ExamDetailsMarkingVO selectExamListBySta(@RequestBody ContextAndPageSizeVO contextAndPageSizeVO) {
        LOG.info("***************************************************************查询考试统计阅卷列表*****************************************");
        return iExamService.selectExamListBySta(contextAndPageSizeVO);
    }

    /**
     * 根据考试名称获取总数
     */
    @GetMapping("/listByName/count")
    public int selectExamListByNameCount(@RequestBody ContextAndPageSizeVO contextAndPageSizeVO) {
        return iExamService.selectExamListByNameCount(contextAndPageSizeVO);
    }

    @GetMapping("/name/exist")
    public boolean nameIsExist(@RequestParam("name") String name) {
        return iExamService.nameIsExist(name);
    }

    @GetMapping("/context/list")
    public List<Exam> selectExamByContext(@RequestParam("companyId") Long companyId, @RequestParam("orgId") Long orgId, @RequestParam("siteId") Long siteId, @RequestParam("name") String name) {
        return iExamService.selectExamByContext(companyId, orgId, siteId, name);
    }


    /**
     * 按考试统计考试信息列表查询
     */
    @GetMapping("/exam/export")
    public List<Exam> selectExamListByNameExport(String name, Long companyId) {
        try {
            return iExamService.selectExamListByNameExport(name, companyId);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 检查考试的题目分数以及合格分是否设置
     *
     * @param examId
     * @return
     */
    @GetMapping(value = "/score/check", produces = "text/html;charset=UTF-8")
    public String checkScore(@RequestParam("examId") Long examId) {
        return iExamService.checkScore(examId);
    }


    @ApiOperation(value = "可见范围导出", notes = "可见范围导出")
    @GetMapping("/export/visiblRange")
    public VisibleRangeExport vsibleRangeExport(@ApiParam(value = "考试的Id", name = "考试的Id", required = true) @RequestParam(name = "examId", required = true) Long examId) {
        return iExamService.vsibleRangeExport(examId);
    }


    @GetMapping(value = "/by/new/server")
    public List<Map<String, Object>> getServerByCompanyIdAndIds(@RequestParam("companyId") Long companyId, @RequestParam(value = "ids", required = false) List<Long> ids) {
        return iExamService.getServerByCompanyIdAndIds(companyId, ids);
    }

    @GetMapping("/getFinishedIds")
    public List<Long> getFinishedAccountIds(@RequestParam("examId") Long examId, @RequestParam("companyId") Long companyId, @RequestParam("siteId") Long siteId) {
        return iTrExamAnswerService.getFinishedAccountIds(examId, companyId, siteId);
    }

    @GetMapping("/visibleRange")
    public List<TrExamAuthorizeVO> VisibleRange(@RequestParam("examId") Long examId){
    	return iTrExamAuthorizeService.listTrExamAuthorize(examId);
    }

    @GetMapping("/expireList")
    public List<Exam> getExpireList(){
        return iExamService.getExpireList();
    }

    /**
     * 查找多门考试,该考生每门考试的最高分
     *
     * @return
     */
    @PostMapping("/getMaxScores")
    public Map<Long, Map<String, Object>> getMaxScores(@RequestBody List<Long> examIds){
        return iExamService.getMaxScores(examIds);
    }
}

