
package com.yizhi.application.controller.api;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.Exam;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.mapper.TrExamAnswerMapper;
import com.yizhi.application.service.IExamService;
import com.yizhi.application.service.ITrExamAnswerService;
import com.yizhi.application.service.ITrExamScoreEvaluateService;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.exam.ExamDetailsVO;
import com.yizhi.exam.application.vo.exam.*;
import com.yizhi.exam.application.vo.report.PcAnswerQuestionDetailVO;
import com.yizhi.point.application.feign.PointApiFeignClients;
import com.yizhi.point.application.feign.PointListenerClients;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;

@RestController
@RequestMapping("/api/exam")
public class ExamApiController {

    private static final Logger LOG = LoggerFactory.getLogger(ExamApiController.class);

    @Autowired
    ITrExamAnswerService itrExamAnswerService;

    @Autowired
    IExamService trExamService;

    @Autowired
    private IExamService examService;

    @Autowired
    private ITrExamAnswerService trExamAnswerService;

    @Autowired
    private TrExamAnswerMapper trExamAnswerMapper;

    @Autowired
    private IExamService iExamService;

    @Autowired
    private ITrExamScoreEvaluateService iTrExamScoreEvaluateService;

    @Autowired
    private PointListenerClients pointListenerClients;
    @Autowired
    private PointApiFeignClients pointApiFeignClients;

    @PostMapping("/result")
    public ExamAnswerApiListVO getExamResultList(@RequestBody ExamAnswerApiListVO examAnswerApiListVo) {
        ExamAnswerApiListVO answerApiListVO = new ExamAnswerApiListVO();
        try {
            answerApiListVO.setName(trExamService.getExamByExamId(examAnswerApiListVo.getExamId()).getName());      //考试名字
            Integer jige = trExamService.getExamByExamId(examAnswerApiListVo.getExamId()).getQualifiedScore();
            answerApiListVO.setQualifiedScore(jige);                     //及格分数

            List<ExamAnswerApiVO> listExamAnswerApiVO = new ArrayList<ExamAnswerApiVO>();

            List<TrExamAnswer> list = new ArrayList<TrExamAnswer>();
            list = itrExamAnswerService.getExamAnswerListByExamIdAndAccountId(examAnswerApiListVo.getExamId(), examAnswerApiListVo.getAccountId());   //答卷信息
            ExamAnswerApiVO examAnswerApiVO = null;
            for (int i = 0; i < list.size(); i++) {
                examAnswerApiVO = new ExamAnswerApiVO();
                examAnswerApiVO.setId(list.get(i).getId());   //答卷主键id
                examAnswerApiVO.setScore(list.get(i).getScore());//分数
                examAnswerApiVO.setResult(list.get(i).getScore().intValue() >= jige.intValue() ? "及格" : "不及格");
                examAnswerApiVO.setSubmitTime(list.get(i).getSubmitTime());
                listExamAnswerApiVO.add(examAnswerApiVO);
            }
            answerApiListVO.setList(listExamAnswerApiVO);
            return answerApiListVO;
        } catch (Exception e) {
            // Auto-generated catch block
            LOG.error("ExamApiController : getExamResultList 异常：",e);
            return answerApiListVO;
        }


    }

    @PostMapping("/details")
    public ExamDetailsVO examDetail(@RequestBody ExamAnswerApiListVO examAnswerApiListVo) {
        ExamDetailsVO examDetailsVO = trExamService.examDetail(examAnswerApiListVo.getExamId(), examAnswerApiListVo.getAccountId());
        if (examDetailsVO != null) {
            examDetailsVO.setTrainingProjectId(examAnswerApiListVo.getTrainingProjectId());
        }
        return examDetailsVO;
    }

    @PostMapping("/result/question/analysis")
    public Response<ExamDetailsVO> examAnalysis(
            @RequestParam(name = "examId") Long examId) {
        return Response.ok();
    }

    /**
     * 我的考试（统计没结束的考试和没提交的考试数量）
     *
     * @param accountId
     * @return
     */
    @GetMapping("/count")
    public Integer selectCountByAccountId(@RequestParam("accountId") Long accountId) {
        Integer count = null;
        try {
            RequestContext requestContext = ContextHolder.get();
            List<Long> ids = requestContext.getRelationIds();
            MyExamParameterVO myExamParameterVO = new MyExamParameterVO();
            myExamParameterVO.setAccountId(accountId);
            if (null != ids) {
                myExamParameterVO.setIds(ids);
            } else {
                ids = new ArrayList<Long>();
                ids.add(requestContext.getAccountId());
                myExamParameterVO.setIds(ids);
            }
            myExamParameterVO.setSiteId(requestContext.getSiteId());
            myExamParameterVO.setState(1);
            List<Long> examIds = examService.getMyVisableExam(myExamParameterVO.getIds(), myExamParameterVO.getSiteId());
            if (null != examIds) {
                myExamParameterVO.setIds(examIds);
            }
            count = examService.selectTotal(myExamParameterVO);
        } catch (Exception e) {
            LOG.error("统计我的考试错误",e);
        }

        return count == null ? 0 : count;
    }

    /**
     * 学员考试答卷查看
     *
     * @param pageNo
     * @param pageSize
     * @param type      1交卷后显示，2考试结束后显示
     * @param accountId
     * @param answerId
     * @return
     */
    @GetMapping("/show/my/answer")
    public StudentExamAnswerVo showMyExamAnswer(@RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize,
                                                @RequestParam("type") Integer type, @RequestParam("accountId") Long accountId, @RequestParam("answerId") Long answerId) {
        StudentExamAnswerVo studentExamAnswerVo = null;

        // 答卷详情，分页查询
        try {
            studentExamAnswerVo = new StudentExamAnswerVo();
            studentExamAnswerVo.setPageNo(pageNo);
            studentExamAnswerVo.setPageSize(pageSize);

            Page<AnswerQuestionDetailVO> pageList = trExamAnswerService.answerQuestionDetail(answerId, pageNo,
                    pageSize);
            List<AnswerQuestionDetailVO> list = pageList.getRecords();
            Long examId = null;

            if (CollectionUtils.isNotEmpty(list)) {
                examId = list.get(0).getExamId();
            }
            //查找必答题分值
            Map<Long, Map<String, BigDecimal>> questionFullScoreMap = new HashMap<>(16);
            questionFullScoreMap = trExamAnswerService.getQuestionFullScoreMap(answerId, examId);

            //查找系统出题分值
            Map<Integer, Map<String, BigDecimal>> systemQuestionFullScoreMap = new HashMap<>(4);
            systemQuestionFullScoreMap = trExamAnswerService.getSystemQuestionFullScoreMap(examId);
            // 查找问答题
            AnswerQuestionListVO resMain = null;
            for (AnswerQuestionDetailVO item : list) {
                List<String> rightAnswers = new ArrayList<>();
                if (item.getType() != 4) {
                    Integer isTrue = 0;
                    for (int i = 0; i < item.getOptions().size(); i++) {
                        AnswerQuestionListVO answerQuestionListVO = item.getOptions().get(i);
                        if (answerQuestionListVO.getStudentAnswer().equals("1")) {
                            Integer index = i + 1;
                            rightAnswers.add(index.toString());
                        }
                    }
                    item.setRightAnswers(rightAnswers);
                    BigDecimal fullScore = null;


                    //题干分值
                    if (null != questionFullScoreMap && questionFullScoreMap.size() > 0) {
                        if (null != questionFullScoreMap.get(item.getAnswerQuestionId())) {
                            fullScore = questionFullScoreMap.get(item.getAnswerQuestionId()).get("score");
                        }
                    }
                    if (null == fullScore) {
                        if (null != systemQuestionFullScoreMap && systemQuestionFullScoreMap.size() > 0) {
                            if (null != systemQuestionFullScoreMap.get(item.getType())) {
                                fullScore = systemQuestionFullScoreMap.get(item.getType()).get("score");
                            }else {
                                fullScore = BigDecimal.valueOf(0);
                            }
                        }
                    }
                    if (null != fullScore) {
                        item.setFullScore(fullScore);
                    }

                    if (type == 0) {
                        isTrue = 2;
                    } else {

                        for (AnswerQuestionListVO answerQuestionListVO : item.getOptions()) {
                            //作答了判断是否正确
                            if (answerQuestionListVO.getAnswer() == 1) {
                                if (answerQuestionListVO.getStudentAnswer().equals("1")) {
                                    isTrue = 1;
                                } else {
                                    isTrue = 0;
                                    break;
                                }
                            } else {
                                //未作答的判断是否有正确答案
                                if (answerQuestionListVO.getStudentAnswer().equals("1")) {
                                    isTrue = 0;
                                    break;
                                }
                            }
                        }
                    }
                    item.setIsTrue(isTrue);
                    continue;
                }
                studentExamAnswerVo.setIsres(1);
                resMain = trExamAnswerService.answerMainQuestionDetailByAnswerQuestionId(item.getAnswerQuestionId());
                if (resMain == null) {
                    continue;
                }

//                Integer fullScore = trExamAnswerService.getFullScore(item.getExamId(), item.getAnswerQuestionId());
                BigDecimal resMainFullScore = null;

                //主观题题干分值
                if (null != questionFullScoreMap) {
                    if (null != questionFullScoreMap.get(item.getAnswerQuestionId())) {
                        resMainFullScore = questionFullScoreMap.get(item.getAnswerQuestionId()).get("score");
                    }
                }
                if (null == resMainFullScore) {
                    if (null != systemQuestionFullScoreMap) {
                        resMainFullScore = systemQuestionFullScoreMap.get(item.getType()).get("score");
                    }
                }
                if (null != resMainFullScore) {
                    item.setFullScore(resMainFullScore);
                }

                if (type == 0) {
                    item.setIsTrue(2);
                } else {
//                    Integer score = (int) Float.parseFloat(item.getScore() == null ? "0" : item.getScore());
                    rightAnswers.add(resMain.getStudentAnswer() == null ? "" : resMain.getStudentAnswer());
                    //正确答案
                    item.setRightAnswers(rightAnswers);
                    BigDecimal score = new BigDecimal(item.getScore());
                    if (null != resMainFullScore && score.compareTo(resMainFullScore) >= 0) {
                        item.setIsTrue(1);
                    } else {
                        item.setIsTrue(0);
                    }
                }

                List<AnswerQuestionListVO> options = new ArrayList<AnswerQuestionListVO>();
                options.add(resMain);
                item.setOptions(options);

            }
            studentExamAnswerVo.setQuestions(pageList.getRecords());
            Exam exam = null;
            if (null != examId) {
                exam = trExamService.selectById(examId);
                if (null == exam) {
                    return studentExamAnswerVo;
                }
            } else {
                return studentExamAnswerVo;
            }

            studentExamAnswerVo.setScoreSuccess(exam.getQualifiedScore());
            Map<String, Integer> attributeMap = checkExamShowAttribute(answerId, exam, new Date());
            studentExamAnswerVo.setIsAnalysis(attributeMap.get("isAnalysis")); //显示解析，0不显示 1显示
            studentExamAnswerVo.setIsAnswer(attributeMap.get("isAnswer")); //显示答案，0不显示 1显示
            studentExamAnswerVo.setIsScore(attributeMap.get("isScore")); //显示分数，0不显示 1显示
			/*//审阅中的不显示成绩
			if(attributeMap.get("isScore") == 0){
				for (AnswerQuestionDetailVO item : list) {
					if(!"审阅中".equals(item.getScore())){
						item.setScore("");
					}
				}
			}*/

            //获取答卷时长和考试成绩分数
            TrExamAnswer trExamAnswer = trExamAnswerService.selectById(answerId);
            if (trExamAnswer != null) {
                studentExamAnswerVo.setDuration(trExamAnswer.getDuration());
                if (trExamAnswer.getState() == 2) {
                    studentExamAnswerVo.setIsres(0);
                    studentExamAnswerVo.setScore(trExamAnswer.getScore());
                } else {
                    studentExamAnswerVo.setIsres(1);
                }
            } else {
                studentExamAnswerVo.setDuration(0);
                studentExamAnswerVo.setScore(new BigDecimal(0));
            }

            Integer isAnswerPaper = attributeMap.get("isAnswerPaper");
            if (isAnswerPaper == 1) {
                studentExamAnswerVo.setIsAnswerPaper(1);
            } else {
                if (exam.getIsAnswerPaper() == 0) {
                    studentExamAnswerVo.setIsAnswerPaper(3);
                } else if (exam.getIsAnswerPaper() == 2) {
                    studentExamAnswerVo.setIsAnswerPaper(2);
                }
            }


            studentExamAnswerVo.setPageTotal(pageList.getTotal());

            ExamDetailsVO examDetailsVO = trExamService.examDetail(examId, accountId);
            studentExamAnswerVo.setExamDetailsVO(examDetailsVO);

            return studentExamAnswerVo;
        } catch (Exception e) {
            LOG.error("ExamApiController:showMyExamAnswer 发生异常,信息如下：",e);
            studentExamAnswerVo = new StudentExamAnswerVo();
            studentExamAnswerVo.setIsAnalysis(0);
            studentExamAnswerVo.setIsAnswer(0);
            studentExamAnswerVo.setQuestions(new ArrayList<AnswerQuestionDetailVO>());
        }

        return studentExamAnswerVo;
    }

    /**
     * 学员考试答卷查看答题卡
     *
     * @param pageNo
     * @param pageSize
     * @param answerId
     * @return
     */
    @GetMapping("/show/my/pcAnswerCard")
    public PcCardVO showMyPcExamAnswerCards(@RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize,
                                            @RequestParam("answerId") Long answerId) {
        Page<AnswerQuestionDetailVO> page = trExamAnswerService.answerQuestionDetail(answerId, 1, Integer.MAX_VALUE);
        List<AnswerQuestionDetailVO> list = null;
        List<CardVO> cardVOS = new ArrayList<>();
        List<AnswerQuestionListVO> resOptions = null;
        PcCardVO pcCardVO = new PcCardVO();
        CardVO cardVO = null;
        Integer errorNum = 0;
        Integer rightNum = 0;

        if (null != page) {
            list = page.getRecords();
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (AnswerQuestionDetailVO item : list) {
                cardVO = new CardVO();
                cardVO.setFlag(item.getMark());
                item.setSort(list.indexOf(item) + 1);
                if (item.getType() != 4) {
                    Integer isTrue = 0;
                    resOptions = item.getOptions();
                    if (CollectionUtils.isNotEmpty(resOptions)) {
                        for (AnswerQuestionListVO resOption : resOptions) {
//                            if ((resOption.getAnswer().toString().equals("0") && !resOption.getStudentAnswer().equals("1")) ||
//
//                                    (resOption.getAnswer().toString().equals("1") && resOption.getStudentAnswer().equals("1"))) {
//                                isTrue = 1;
//                            } else {
//                                isTrue = 0;
//                                break;
//                            }
                            //作答了判断是否正确
                            if (resOption.getAnswer() == 1) {
                                if (resOption.getStudentAnswer().equals("1")) {
                                    isTrue = 1;
                                } else {
                                    isTrue = 0;
                                    break;
                                }
                            } else {
                                //未作答的判断是否有正确答案
                                if (resOption.getStudentAnswer().equals("1")) {
                                    isTrue = 0;
                                    break;
                                }
                            }

                        }
                        for (AnswerQuestionListVO resOption : resOptions) {
                            if (resOption.getAnswer() == 1) {
                                cardVO.setAnswerFlag(1);
                                break;
                            }
                        }
                    }
                    if (isTrue == 1) {
                        rightNum++;
                    } else {
                        errorNum++;
                    }
                    cardVO.setIndex(Long.valueOf(item.getSort()));
                    cardVO.setRightFlag(isTrue);
                    cardVOS.add(cardVO);
                    continue;
                }
                Integer fullScore = trExamAnswerService.getFullScore(item.getExamId(), item.getAnswerQuestionId());
                String s = item.getScore();
                if (null != s) {
                    if (s.lastIndexOf(".") != -1) {
                        s = s.substring(0, s.lastIndexOf("."));
                    }
                }
                if (s.equals(fullScore.toString())) {
                    rightNum++;
                    cardVO.setRightFlag(1);
                } else {
                    errorNum++;
                }
                AnswerQuestionListVO resMain = trExamAnswerService.answerMainQuestionDetailByAnswerQuestionId(item.getAnswerQuestionId());
                if (null != resMain && StringUtils.isNotBlank(resMain.getContent())) {
                    cardVO.setAnswerFlag(1);
                }
                cardVO.setIndex(Long.valueOf(item.getSort()));
                cardVOS.add(cardVO);
            }
        }
        Integer m = cardVOS.size();
        if (m <= pageSize) {
            pcCardVO.setCardVOS(cardVOS);
        } else {
            if (pageNo * pageSize <= m) {
                pcCardVO.setCardVOS(cardVOS.subList((pageNo - 1) * pageSize, pageNo * pageSize));
            } else {
                pcCardVO.setCardVOS(cardVOS.subList((pageNo - 1) * pageSize, m));
            }
        }
        pcCardVO.setRightNum(rightNum);
        pcCardVO.setErrorNum(errorNum);
        pcCardVO.setTotal(m);
        return pcCardVO;
    }

    @GetMapping("/show/my/pcAnswer")
    public PcStudentExamAnswerVo showMyPcExamAnswer(@RequestParam("type") Integer type, @RequestParam("accountId") Long accountId, @RequestParam("answerId") Long answerId) {
        PcStudentExamAnswerVo studentExamAnswerVo = null;

        // 答卷详情
        try {
            studentExamAnswerVo = new PcStudentExamAnswerVo();

            Page<AnswerQuestionDetailVO> pageList = trExamAnswerService.answerQuestionDetail(answerId, 1,
                    Integer.MAX_VALUE);


            List<AnswerQuestionDetailVO> list = pageList.getRecords();
            List<PcAnswerQuestionDetailVO> qustionsList = new ArrayList<>();

            Long examId = null;

            if (CollectionUtils.isNotEmpty(list)) {
                examId = list.get(0).getExamId();
            }
            //查找必答题分值
            Map<Long, Map<String, BigDecimal>> questionFullScoreMap = new HashMap<>(16);
            questionFullScoreMap = trExamAnswerService.getQuestionFullScoreMap(answerId, examId);

            //查找系统出题分值
            Map<Integer, Map<String, BigDecimal>> systemQuestionFullScoreMap = new HashMap<>(4);
            systemQuestionFullScoreMap = trExamAnswerService.getSystemQuestionFullScoreMap(examId);


            // 查找问答题
            AnswerQuestionListVO resMain = null;
            for (AnswerQuestionDetailVO item : list) {
                PcAnswerQuestionDetailVO item1 = new PcAnswerQuestionDetailVO();
                item1.setAnalysis(item.getAnalysis());
                item1.setExamId(examId);
                item1.setType(item.getType());
                item1.setStem(item.getStem());
                item1.setStemAppendixUrl(item.getStemAppendixUrl());
                item1.setAnswerQuestionId(item.getAnswerQuestionId());
                item1.setExamineScore(item.getScore());
                item1.setSort(list.indexOf(item));
                item1.setFlag(item.getMark());
                if (item.getType() != 4) {
                    Integer isTrue = 0;
                    if (CollectionUtils.isNotEmpty(item.getOptions())) {
                        item1.setQuestionOptions(item.getOptions());
                        List<String> rightAnswers = new ArrayList<>();
                        for (int i = 0; i < item.getOptions().size(); i++) {
                            AnswerQuestionListVO answerQuestionListVO = item.getOptions().get(i);
                            if (answerQuestionListVO.getStudentAnswer().equals("1")) {
                                Integer index = i + 1;
                                rightAnswers.add(index.toString());
                            }
                        }
                        item1.setRightAnswers(rightAnswers);
                        BigDecimal fullScore = null;

                        //题干分值
                        if (null != questionFullScoreMap && questionFullScoreMap.size() > 0) {
                            if (null != questionFullScoreMap.get(item.getAnswerQuestionId())) {
                                fullScore = questionFullScoreMap.get(item.getAnswerQuestionId()).get("score");
                            }
                        }
                        if (null == fullScore) {
                            if (null != systemQuestionFullScoreMap && systemQuestionFullScoreMap.size() > 0) {
                                if (null != systemQuestionFullScoreMap.get(item.getType())) {
                                    fullScore = systemQuestionFullScoreMap.get(item.getType()).get("score");
                                }

                            }
                        }
                        if (null != fullScore) {
                            item1.setScore(fullScore);
                        }

                        if (type == 0) {
                            isTrue = 2;
                        } else {

                            for (AnswerQuestionListVO answerQuestionListVO : item.getOptions()) {
                                //作答了判断是否正确
                                if (answerQuestionListVO.getAnswer() == 1) {
                                    if (answerQuestionListVO.getStudentAnswer().equals("1")) {
                                        isTrue = 1;
                                    } else {
                                        isTrue = 0;
                                        break;
                                    }
                                } else {
                                    //未作答的判断是否有正确答案
                                    if (answerQuestionListVO.getStudentAnswer().equals("1")) {
                                        isTrue = 0;
                                        break;
                                    }
                                }
                            }
                        }

                        item1.setIsTrue(isTrue);
                        qustionsList.add(item1);
                        continue;
                    }
                }
                List<String> rightAnswers = new ArrayList<>();
                studentExamAnswerVo.setIsres(1);
                resMain = trExamAnswerService.answerMainQuestionDetailByAnswerQuestionId(item.getAnswerQuestionId());
                if (resMain == null) {
                    continue;
                }
                List<AnswerQuestionListVO> options = new ArrayList<AnswerQuestionListVO>();
                options.add(resMain);
                item1.setQuestionOptions(options);
                if (type == 0) {
                    item1.setAnalysis(null);
                } else {
                    rightAnswers.add(resMain.getStudentAnswer() == null ? "" : resMain.getStudentAnswer());
                    //正确答案
                    item1.setRightAnswers(rightAnswers);
                }

                //学员答题内容
                item1.setSub(resMain.getContent());
//                Integer fullScore = trExamAnswerService.getFullScore(item.getExamId(), item.getAnswerQuestionId());
                BigDecimal resMainFullScore = null;

                //主观题题干分值
                if (null != questionFullScoreMap) {
                    if (null != questionFullScoreMap.get(item.getAnswerQuestionId())) {
                        resMainFullScore = questionFullScoreMap.get(item.getAnswerQuestionId()).get("score");
                    }
                }
                if (null == resMainFullScore) {
                    if (null != systemQuestionFullScoreMap) {
                        resMainFullScore = systemQuestionFullScoreMap.get(item.getType()).get("score");
                    }
                }
                if (null != resMainFullScore) {
                    item1.setScore(resMainFullScore);
                }

                if (type == 0) {
                    item1.setIsTrue(2);
                } else {

//                    Integer score = (int) Float.parseFloat(item.getScore() == null ? "0" : item.getScore());
                    BigDecimal score = new BigDecimal(item.getScore());
                    if (null != resMainFullScore && score.compareTo(resMainFullScore) >= 0) {
                        item1.setIsTrue(1);
                    } else {
                        item1.setIsTrue(0);
                    }
                }
                qustionsList.add(item1);
            }
            studentExamAnswerVo.setQuestions(qustionsList);


            Exam exam = trExamService.selectById(examId);
            studentExamAnswerVo.setScoreSuccess(exam.getQualifiedScore());
            Map<String, Integer> attributeMap = checkExamShowAttribute(answerId, exam, new Date());
            if (type == 0) {
                studentExamAnswerVo.setIsAnalysis(0);
            } else {
                studentExamAnswerVo.setIsAnalysis(attributeMap.get("isAnalysis")); //显示解析，0不显示 1显示
            }
            //显示答案，0不显示 1显示,未阅卷的不显示
            if (type == 0) {
                studentExamAnswerVo.setIsAnswer(0);
            } else {
                studentExamAnswerVo.setIsAnswer(attributeMap.get("isAnswer"));
            }
            Integer isScore = attributeMap.get("isScore");
            Integer isAnswerPaper = attributeMap.get("isAnswerPaper");
            Integer isPaperid = attributeMap.get("isPaperid");
            if (type == 0) {
                studentExamAnswerVo.setIsScore(2);
            } else {
                if (isScore == 1) {
                    studentExamAnswerVo.setIsScore(1);
                } else {
                    if (exam.getIsScore() == 0) {
                        studentExamAnswerVo.setIsScore(4);
                    } else if (exam.getIsScore() == 2) {
                        studentExamAnswerVo.setIsScore(3);
                    }
                }
            }
            if (isAnswerPaper == 1) {
                studentExamAnswerVo.setIsAnswerPaper(1);
            } else {
                if (exam.getIsAnswerPaper() == 0) {
                    studentExamAnswerVo.setIsAnswerPaper(3);
                } else if (exam.getIsAnswerPaper() == 2) {
                    studentExamAnswerVo.setIsAnswerPaper(2);
                }
            }


            //获取答卷时长和考试成绩分数
            TrExamAnswer trExamAnswer = trExamAnswerService.selectById(answerId);
            if (trExamAnswer != null) {
                studentExamAnswerVo.setDuration(trExamAnswer.getDuration());
                if (trExamAnswer.getState() == 2) {
                    studentExamAnswerVo.setIsres(0);
                    studentExamAnswerVo.setScore(trExamAnswer.getScore());
                } else {
                    studentExamAnswerVo.setIsres(1);
                }
            } else {
                studentExamAnswerVo.setDuration(0);
                studentExamAnswerVo.setScore(new BigDecimal(0));
            }

            //显示评价
            if (type != 0) {
                if (isPaperid == 1) {
                    String remark = "";
                    List<TrExamScoreEvaluateVO> markList = iTrExamScoreEvaluateService.listTrExamScoreEvaluate(examId);
                    Integer score = trExamAnswer.getScore().toBigInteger().intValue();
                    for (TrExamScoreEvaluateVO item : markList) {
                        if (score >= item.getMinScore() && score <= item.getMaxScore()) {
                            remark = item.getDescription();
                            break;
                        }
                    }
                    studentExamAnswerVo.setEvaluate(remark);
                }
            }

            studentExamAnswerVo.setType("answerPaper");
            studentExamAnswerVo.setPageTotal(pageList.getTotal());

            ExamDetailsVO examDetailsVO = trExamService.examDetail(examId, accountId);
            studentExamAnswerVo.setExamDetailsVO(examDetailsVO);

            return studentExamAnswerVo;
        } catch (Exception e) {
            LOG.error("ExamApiController:showMyPcExamAnswer 发生异常,信息如下：",e);
            studentExamAnswerVo = new PcStudentExamAnswerVo();
            studentExamAnswerVo.setIsAnalysis(0);
            studentExamAnswerVo.setIsAnswer(0);
            studentExamAnswerVo.setQuestions(new ArrayList<PcAnswerQuestionDetailVO>());
        }

        return studentExamAnswerVo;
    }

    //删除指定字符
    public String deleteChar(String s, char a) {
        String resultString = "";
        for (int i = 0; i < s.length(); i++) {
            if (s.charAt(i) != a) {
                resultString += s.charAt(i);
            }
        }
        return resultString;
    }

    /**
     * 学员考试结果页查看（考试结束后）
     *
     */
    @GetMapping("/show/my/answer/result")
    public ExamResultVO showMyExamResult(@RequestParam("accountId") Long accountId, @RequestParam("examId") Long examId) {
        ExamResultVO erVo = new ExamResultVO();
        Exam exam = examService.selectById(examId);

        if (null == exam) {
            return null;
        }
        erVo.setExamId(examId);
        erVo.setExamName(exam.getName());
        erVo.setScoreSuccess(exam.getQualifiedScore());
        erVo.setAnswerNum(exam.getAnswerNum());
        erVo.setStartTime(exam.getStartTime());
        erVo.setEndTime(exam.getEndTime());

        boolean examEnd = false; //判断考试是否结束
        Date curDate = new Date();
        Long end = exam.getEndTime().getTime() - curDate.getTime();
        if (end <= 0) {
            examEnd = true;
        }

        // 判断是否显示查看答案
        Integer isAnswerPaper = exam.getIsAnswerPaper();
        if (null == isAnswerPaper || isAnswerPaper == 0) {//不显示
            erVo.setIsLookAnswer(0);
        } else if (isAnswerPaper == 1) {//交卷后显示
            erVo.setIsLookAnswer(1);
        } else if (isAnswerPaper == 2) {//考试结束后显示
            if (examEnd) {
                erVo.setIsLookAnswer(1);
            } else {
                erVo.setIsLookAnswer(2);
            }
        }
        // 判断是否显示成绩
        Integer isScore = exam.getIsScore();
        if (null == isScore || isScore == 0) {
            erVo.setIsScore(0);
        } else if (isScore == 1) {//交卷后显示
            erVo.setIsScore(1);
        } else if (isScore == 2) {//考试结束后显示
            if (examEnd) {
                erVo.setIsScore(1);
            } else {
                erVo.setIsScore(2);
            }
        }

        //判断考试是否设置了合格分,没有设置就100分
        Integer qualifiedScore = exam.getQualifiedScore();
        if (qualifiedScore == null) {
            qualifiedScore = 100;
        }
        // 考试历史
        List<ExamHistoryVO> hisList = trExamAnswerService.selectExamHisList(accountId, exam.getId());
        for (ExamHistoryVO item : hisList) {
            item.setQualifiedScore(new BigDecimal(qualifiedScore));
            if (item.getState() == 1) {
                item.setState(0);
            } else if (item.getState() == 2) {
                if (item.getScore().compareTo(item.getQualifiedScore()) >= 0) {
                    item.setState(2);
                } else {
                    item.setState(1);
                }
            }
        }
        erVo.setHisList(hisList);
        Integer examNum = 0;
        if (hisList != null) {
            examNum = hisList.size();
        }
        erVo.setExamNum(examNum);

        if (exam.getAnswerNum() == 0) {
            erVo.setIsGoOn(1);
        } else if (exam.getAnswerNum() > 0) {
            if (examNum.compareTo(exam.getAnswerNum()) >= 0) {
                erVo.setIsGoOn(0);
            } else {
                erVo.setIsGoOn(1);
            }
        }

        // 获取所有考试数据
        List<Long> allList = trExamAnswerMapper.getAnswerIdByAccountId(accountId, examId);
        if (allList == null) {
            erVo.setExamNumAll(0);
        } else {
            erVo.setExamNumAll(allList.size());
        }


        //获取已阅卷最高分
        BigDecimal maxScore = null;
        TrExamAnswer maxExamAnswer = trExamAnswerService.selectMaxScoreByAccountIdAndExamId(accountId, examId);
        if (maxExamAnswer != null) {
            maxScore = maxExamAnswer.getScore();
            erVo.setAnswerId(maxExamAnswer.getId());
        } else {
            if (hisList != null && hisList.size() > 0) {
                erVo.setAnswerId(hisList.get(0).getId());
            }
        }
        //判断是否有主观题
        if (maxScore == null) {
            maxScore = new BigDecimal(0);
            erVo.setIsres(1);
        } else {
            erVo.setIsres(0);
        }
        maxScore = maxScore.setScale(1, BigDecimal.ROUND_HALF_UP);
        erVo.setScore(maxScore);

        // 判断是否显示分数评价
        Integer isPaperid = exam.getIsPaperid();
        if (null == isPaperid || isPaperid == 0) {
            erVo.setRemark("");
        } else if (isPaperid == 1) {//交卷后显示
            String remark = "";
            List<TrExamScoreEvaluateVO> markList = iTrExamScoreEvaluateService.listTrExamScoreEvaluate(examId);
            Integer score = maxScore.toBigInteger().intValue();
            for (TrExamScoreEvaluateVO item : markList) {
                if (score >= item.getMinScore() && score <= item.getMaxScore()) {
                    remark = item.getDescription();
                    break;
                }
            }
            erVo.setRemark(remark);
        } else if (isPaperid == 2) {//考试结束后显示
            if (examEnd) {
                String remark = "";
                List<TrExamScoreEvaluateVO> markList = iTrExamScoreEvaluateService.listTrExamScoreEvaluate(examId);
                Integer score = maxScore.toBigInteger().intValue();
                for (TrExamScoreEvaluateVO item : markList) {
                    if (score >= item.getMinScore() && score <= item.getMaxScore()) {
                        remark = item.getDescription();
                        break;
                    }
                }
                erVo.setRemark(remark);
            } else {
                erVo.setRemark("");
            }
        }

        return erVo;
    }

    /**
     * 扫描二维码参加考试
     *
     * @param examAnswerApiListVo
     * @return
     */
    @PostMapping("/code/scan")
    ExamDetailsVO scanCodeExam(@RequestBody MyExamParameterVO myExamParameterVO) {
        ExamDetailsVO examDetailsVO = null;
        List<MyExamVO> myExamVOS = iExamService.MyExam(myExamParameterVO);
        if (myExamVOS == null || myExamVOS.size() == 0) {
            examDetailsVO = new ExamDetailsVO();
            examDetailsVO.setScanCode(0);
            examDetailsVO.setScanMsg("不在考试范围内");
            return examDetailsVO;
        }

        boolean isOk = false;
        Long examId = myExamParameterVO.getExamId();
        for (MyExamVO item : myExamVOS) {
            if (examId == item.getId()) {
                isOk = true;
                break;
            }
        }
        if (!isOk) {
            examDetailsVO = new ExamDetailsVO();
            examDetailsVO.setScanCode(0);
            examDetailsVO.setScanMsg("不在考试范围内");
            return examDetailsVO;
        }

        examDetailsVO = trExamService.examDetail(myExamParameterVO.getExamId(), myExamParameterVO.getAccountId());
        if (examDetailsVO == null) {
            examDetailsVO = new ExamDetailsVO();
            examDetailsVO.setScanCode(0);
            examDetailsVO.setScanMsg("不在考试范围内");
            return examDetailsVO;
        }
        examDetailsVO.setScanCode(1);
        examDetailsVO.setScanMsg("扫码考试成功");
        //pointListenerClients.addPoint("CreditCourseDone1", myExamParameterVO.getExamId());
        //pointApiFeignClients.addPoint(myExamParameterVO.getAccountId(), "point_exam", "" + myExamParameterVO.getExamId());
        return examDetailsVO;
    }

    /**
     * 检查考试结束要显示的属性
     * isAnswerPaper 	显示答卷，0不显示 1显示
     * isScore 			显示成绩，0不显示 1显示
     * isAnswer 		显示答案，0不显示 1显示
     * isAnalysis		显示解析，0不显示 1
     * isPaperid 		显示通用分评价，0不显示 1
     *
     * @param answerId
     * @param exam
     * @param currentDate
     * @return
     */
    private Map<String, Integer> checkExamShowAttribute(Long answerId, Exam exam, Date currentDate) {
        Map<String, Integer> attributeMap = new HashMap<String, Integer>();

        //默认不显示
        attributeMap.put("isAnswerPaper", 0);
        attributeMap.put("isScore", 0);
        attributeMap.put("isAnswer", 0);
        attributeMap.put("isAnalysis", 0);
        attributeMap.put("isPaperid", 0);
        attributeMap.put("isAnswer", 0);

        if (exam == null) {
            return attributeMap;
        }

        //判断考试是否结束
        boolean examEnd = false;
        Date curDate = new Date();
        Long end = exam.getEndTime().getTime() - curDate.getTime();
        if (end <= 0) {
            examEnd = true;
        }

        //显示答卷
        Integer state = exam.getIsAnswerPaper();
        if (state == null || state == 0) {
            attributeMap.put("isAnswerPaper", 0);
        } else if (state == 1) {
            //交卷后显示
            attributeMap.put("isAnswerPaper", 1);
        } else if (state == 2) {
            //考试结束后显示
            if (examEnd) {
                attributeMap.put("isAnswerPaper", 1);
            } else {
                attributeMap.put("isAnswerPaper", 0);
            }
        }

        //判断主观题是否批阅
        boolean isOver = false;//未批阅
        TrExamAnswer maxExamAnswer = trExamAnswerService.selectById(answerId);
        if (maxExamAnswer != null) {
            //判断是否已阅卷
            if (maxExamAnswer.getState() == 2) {
                isOver = true;//已批阅
            } else {
                isOver = false;
            }
        }


        //显示成绩，并批阅了
        state = exam.getIsScore();
        if (state == null || state == 0) {
            attributeMap.put("isScore", 0);
        } else if (state == 1 && isOver) {
            // 交卷后显示
            attributeMap.put("isScore", 1);
        } else if (state == 2 && isOver) {
            // 考试结束后显示
            if (examEnd) {
                attributeMap.put("isScore", 1);
            } else {
                attributeMap.put("isScore", 2);
            }
        }

        //显示答案
        state = exam.getIsAnswer();
        if (state == null || state == 0) {
            attributeMap.put("isAnswer", 0);
        } else if (state == 1) {
            // 交卷后显示
            attributeMap.put("isAnswer", 1);
        } else if (state == 2) {
            // 考试结束后显示
            if (examEnd) {
                attributeMap.put("isAnswer", 1);
            } else {
                attributeMap.put("isAnswer", 0);
            }
        }

        //是否显示解析
        state = exam.getIsAnalysis();
        if (state == null || state == 0) {
            attributeMap.put("isAnalysis", 0);
        } else if (state == 1) {
            //交卷后显示
            attributeMap.put("isAnalysis", 1);
        } else if (state == 2) {
            //考试结束后显示
            if (examEnd) {
                attributeMap.put("isAnalysis", 1);
            } else {
                attributeMap.put("isAnalysis", 0);
            }
        }

        //显示通用分评价
        state = exam.getIsPaperid();
        if (state == null || state == 0) {
            attributeMap.put("isPaperid", 0);
        } else if (state == 1) {
            //交卷后显示
            attributeMap.put("isPaperid", 1);
        } else if (state == 2) {
            //考试结束后显示
            if (examEnd) {
                attributeMap.put("isPaperid", 1);
            } else {
                attributeMap.put("isPaperid", 0);
            }
        }

        return attributeMap;
    }

    @PostMapping("/getPageToCalendar")
    public Page<ExamCalendarVO> getPageToCalendar(@ApiParam("paramVo") @RequestBody CalendarTaskParamVo paramVo) {
        Page<com.yizhi.exam.application.vo.domain.Exam> page = new Page(paramVo.getPageNo(), paramVo.getPageSize());

        return examService.getPageToCalendar(paramVo.getDate(), page);
    }
}

