package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *考试报表入库类
 * </p>
 *
 * @author dingxiaowei123
 * @since 2018-08-01
 */

@Data
@TableName("statistics_exam_metadata")
public class StatisticsExamMetadata extends Model<StatisticsExamMetadata> {

    private static final long serialVersionUID = 1L;


    
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    
    @TableField("exam_id")
    private Long examId;

    @TableField("exam_no")
    private String examNo;

    @TableField("exam_name")
    private String examName;

    
    @TableField("exam_start_time")
    private Date examStartTime;

    
    @TableField("exam_end_time")
    private Date examEndTime;

    
    @TableField("exam_company_id")
    private Long examCompanyId;

    
    @TableField("exam_site_id")
    private Long examSiteId;

    
    @TableField("exam_org_id")
    private Long examOrgId;

    
    @TableField("exam_create_time")
    private Date examCreateTime;

    
    @TableField("account_id")
    private Long accountId;
    
    
    @TableField("work_num")
    private String workNum;

    
    @TableField("account_name")
    private String accountName;

    
    @TableField("account_fullname")
    private String accountFullname;

    
    @TableField("account_state")
    private Integer accountState;

    
    @TableField("account_company_id")
    private Long accountCompanyId;

    
    @TableField("account_site_id")
    private Long accountSiteId;

    
    @TableField("account_org_id")
    private Long accountOrgId;

    
    @TableField("org_name")
    private String orgName;

    
    @TableField("org_parent_names")
    private String orgParentNames;

    
    @TableField("can_state")
    private Integer canState;

    
    @TableField("join_state")
    private Integer joinState;

    
    @TableField("exam_count")
    private Integer examCount;

    
    @TableField("first_finish_time")
    private Date firstFinishTime;

    
    @TableField("last_finish_time")
    private Date lastFinishTime;

    
    private BigDecimal score;

    
    @TableField("exam_state")
    private Integer examState;

    
    @TableField("account_answer_create_time")
    private Date accountAnswerCreateTime;

    
    @TableField("point")
    private Integer point;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
