package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 客观题答案选项（单选题，多选题，判断题）
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("tr_exam_answer_question_res")
public class TrExamAnswerQuestionRes extends Model<TrExamAnswerQuestionRes> {

	private static final long serialVersionUID = 1L;

	
	private Long id;

	
	@TableField("answer_id")
	private Long answerId;

	
	@TableField("answer_question_id")
	private Long answerQuestionId;

	
	@TableField("option_id")
	private Long optionId;

	
	private Integer answer;

	
	@TableField("right_answer")
	private Integer rightAnswer;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;
	
	
	@TableField(value = "sort", fill = FieldFill.INSERT)
	private Integer sort;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
