package com.yizhi.application.export;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.yizhi.application.service.IExamReportService;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.exam.application.vo.ExamQuestionSubjectVo;
import com.yizhi.exam.application.vo.domain.TrExamAnswer;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.OrganizationClient;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.system.application.vo.*;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;



/**
 * 考试答卷导出实现
 *
 * @author mei
 */
@Component
public class ExamAnswerExport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOG = LoggerFactory.getLogger(ExamAnswerExport.class);

    @Autowired
    LogEventPublisher publisher;
/*
    @Autowired
    RabbitTemplate rabbitTemplate;*/

    @Autowired
    IExamReportService iExamReportService;

    @Autowired
    AccountClient accountClient;

    @Autowired
    OrganizationClient organizationClient;

    @Autowired
    ReportClient reportClient;

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private int cellPos = 6;
    private int rowPos = 2;

    @Override
    protected String execute(Map<String, Object> param) {

        LOG.info("考试答卷导出  异步任务开始执行");

        String upLoadUrl = null;

        /**
         * Excel文件对象
         */
        HSSFWorkbook workbook = null;

        /**
         * 表单对象
         */
        HSSFSheet sheet = null;


        Date date = null;
        Long taskId = null;
        String serialNo = null;
        Long siteId = null;
        Long companyId = null;
        Long examId = null;
        String examName = null;
        String startTime = null;
        String endTime = null;
        String taskName = null;
        Date submitTime = new Date();
        ObjectMapper mapper = new ObjectMapper();
        Map<String, Object> map = new HashMap<>();

        boolean isAdmin = (boolean) param.get("isAdmin");


//        Long siteId = (Long) param.get("siteId");
//        Long companyId = (Long) param.get("companyId");
        Long ACCOUNTID = mapper.convertValue(param.get("accountId"), Long.class);

        List<Long> orgIds = null;
        Object orgIdsObj = param.get("orgIds"); 
        try {
            
            taskId = mapper.convertValue(param.get("taskId"), Long.class);
            
            serialNo = mapper.convertValue(param.get("serialNo"), String.class);
            siteId = mapper.convertValue(param.get("siteId"), Long.class);
            companyId = mapper.convertValue(param.get("companyId"), Long.class);
            examId = mapper.convertValue(param.get("examId"), Long.class);
            examName = mapper.convertValue(param.get("examName"), String.class);
            startTime = mapper.convertValue(param.get("startTime"), String.class);
            endTime = mapper.convertValue(param.get("endTime"), String.class);
            taskName = mapper.convertValue(param.get("taskName"), String.class);
            
            //orgIds = mapper.convertValue(orgIdsObj, List.class);
            if(orgIdsObj!=null) {
                String s = orgIdsObj.toString();
                if(StringUtils.isNotBlank(s)) {
                    orgIds = Lists.newArrayList(Long.valueOf(s));
                }
            }
        }catch (Exception e){
        	e.printStackTrace();
        	LOG.info("异步任务参数转换异常",e.getMessage());
            if(orgIdsObj != null){
                LOG.info("orgIds转换异常，值{}",orgIdsObj.toString());
                orgIds  = Arrays.stream(orgIdsObj.toString().split(",")).map(orgIdItem -> Long.parseLong(orgIdItem)).collect(Collectors.toList());
            }else {
				LOG.info("orgIds为空");
			}
        }

        map.put("siteId", siteId);
        map.put("companyId", companyId);
        map.put("accountId", ACCOUNTID);
        map.put("examId", examId);
        map.put("orgIds", orgIds);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, ACCOUNTID, submitTime, siteId, companyId);
        LOG.info("考试答卷导出异步任务 taskContext 参数 = {}", JSON.toJSONString(taskContext));
        working(taskContext);

        try {

            LOG.info("考试答卷导出异步任务 进入try代码块");
            /**
             * 表单名称
             */
            String sheetName = "exam";

            workbook = new HSSFWorkbook();
            if (!StringUtils.isBlank(sheetName)) {
                sheet = workbook.createSheet(sheetName);
            }
            HSSFRow subjectRow = null;
            HSSFCell cell = null;
            BigDecimal score = null;

            HSSFRow r = sheet.createRow(0);
            CellRangeAddress cra = new CellRangeAddress(0, 0, 0, 100);
            sheet.addMergedRegion(cra);
            cell = r.createCell(0);
            cell.setCellValue(examName + "答卷下载");
            r = sheet.createRow(1);
            cra = new CellRangeAddress(1, 1, 0, 100);
            sheet.addMergedRegion(cra);
            cell = r.createCell(0);
            if (StringUtils.isNotBlank(startTime) && StringUtils.isNotBlank(endTime)) {
                cell.setCellValue("统计周期:" + startTime + "~" + endTime);
            } else {
                cell.setCellValue("统计周期:所有记录");
            }

            //写用户名、姓名	所在部门	考试提交时间	考试得分
            subjectRow = sheet.createRow(rowPos);
            cell = subjectRow.createCell(0);
            cell.setCellValue("用户名");
            cell = subjectRow.createCell(1);
            cell.setCellValue("姓名");
            cell = subjectRow.createCell(2);
            cell.setCellValue("所在部门");
            cell = subjectRow.createCell(3);
            cell.setCellValue("所在组织架构");
            cell = subjectRow.createCell(4);
            cell.setCellValue("考试得分");
            cell = subjectRow.createCell(5);
            cell.setCellValue("正确题目数(客观题)");
            cell = subjectRow.createCell(6);
            cell.setCellValue("错误题目数(客观题)");
//            cell = subjectRow.createCell(5);
//            cell.setCellValue("所属部门");

            /**
             * 分页查询答卷
             */

            //题目所在列
            Map<Long, Integer> subjectMap = new HashMap<Long, Integer>();

            // 题目分页
            Integer subPageSize = Integer.MAX_VALUE;
            Integer subTotal = 0;
            Integer subPageTotal = 1;

            List<TrExamAnswer> trExamAnswers = null;    //答卷集合
            List<ExamQuestionSubjectVo> examSubjectList = null; //题目集合
            ExamQuestionSubjectVo examsubjectVo = null;

            AccountVO accountVO = null;

            //分页查询答卷，通过答卷学生数分页
            String accountNameLike = mapper.convertValue(param.get("accountNameLike"), String.class);
            String orgNameLike = mapper.convertValue(param.get("orgNameLike"), String.class);
            List<ReportAccountRespVO> accounts = null;
            List<Long> accountIds = null;

            if (isAdmin) {
                if (StringUtils.isNotBlank(accountNameLike) || StringUtils.isNotBlank(orgNameLike)) {
                    ReportRangeAccountReqVO reportAccountReqVO = new ReportRangeAccountReqVO();
                    reportAccountReqVO.setSiteId(siteId);
                    if (StringUtils.isNotBlank(accountNameLike)) {
                        reportAccountReqVO.setAccountName(accountNameLike.trim());
                    }
                    if (StringUtils.isNotBlank(orgNameLike)) {
                        reportAccountReqVO.setOrgName(orgNameLike.trim());
                    }
                    accounts = reportClient.getRangeAccounts(reportAccountReqVO);
                    if (!CollectionUtils.isEmpty(accounts)) {
                        accountIds = accounts.stream().map(ReportAccountRespVO::getUserId).collect(Collectors.toList());
                        map.put("accountIds", accountIds);
                    } else {
                        success(taskContext, "未找到相关数据", "");
                    }
                }
            } else {
                HQAccountInManageParam hqAccountInManageParam = new HQAccountInManageParam();
                hqAccountInManageParam.setModuleType(AuthzConstant.moduleType.exam);
                hqAccountInManageParam.setSiteId(siteId);
                hqAccountInManageParam.setAccountId(ACCOUNTID);
                if (StringUtils.isNotBlank(accountNameLike)) {
                    hqAccountInManageParam.setAccountName(accountNameLike.trim());
                }
                if (StringUtils.isNotBlank(orgNameLike)) {
                    hqAccountInManageParam.setOrgName(orgNameLike.trim());
                }
                ReportAccountRespInManageVO reportAccountRespInManageVO = reportClient.getRangeAccountsInManage(hqAccountInManageParam);
                accounts = reportAccountRespInManageVO.getList();
                if (!CollectionUtils.isEmpty(accounts)) {
                    accountIds = accounts.stream().map(ReportAccountRespVO::getUserId).collect(Collectors.toList());
                    map.put("accountIds", accountIds);
                } else {
                    success(taskContext, "未找到相关数据", "");
                }
            }

            Integer answerPageSize = Integer.MAX_VALUE;
            Integer answerTotal = iExamReportService.getMaxScoreeExamAnswerCount(map);
            Integer answerPageTotal = 1;
            if (answerTotal > answerPageSize) {
                answerPageTotal = answerTotal / answerPageSize;
                if (answerTotal % answerPageSize > 0) {
                    answerPageTotal += 1;
                }
            }

            //查询答卷题目信息
            int insertRow = rowPos + 1; //当前行
            int curSubjectCellPos = cellPos + 1; //题目列
            Map<Long, String> orgNamesMap = new HashMap<>(16);
            HSSFRow row = null;
            for (int i = 1; i <= answerPageTotal; i++) {
                //分页查询考生答卷信息
                List<com.yizhi.application.domain.TrExamAnswer> maxScoreeExamAnswerInfo = iExamReportService.getMaxScoreeExamAnswerInfo(map, i, answerPageSize);
                //trExamAnswers = iExamReportService.getMaxScoreeExamAnswerInfo(map, i, answerPageSize);
                if (null == maxScoreeExamAnswerInfo || maxScoreeExamAnswerInfo.size() == 0) {
                    LOG.info("没查询到答卷信息：" + map.toString() + "pageNo:" + i + " pageSize" + answerPageSize);
                    continue;
                }
                trExamAnswers = exechangeExamAnswers(maxScoreeExamAnswerInfo);

                for (TrExamAnswer answer : trExamAnswers) {
                    Long answerId = answer.getId();
                    Long accountId = answer.getAccountId();
                    String accountName = "";
                    String name = "";
                    String orgName = "";
                    String orgNames = "";
                    String submitTimes = "";
                    int wrongCount = 0;
                    int questionCount = 0;
                    date = answer.getSubmitTime();
                    if (null != date) {
                        submitTimes = sdf.format(date);
                    }
                    score = answer.getScore();
                    try {
                        wrongCount = iExamReportService.getWrongCount(answerId);
                        questionCount = iExamReportService.getQuestionCount(answerId);
                        accountVO = accountClient.findById(accountId);
                        accountName = accountVO.getName();
                        name = accountVO.getFullName();
                        orgName = accountVO.getOrgName();

                        if (null != orgNamesMap.get(accountVO.getOrgId())) {
                            orgNames = orgNamesMap.get(accountVO.getOrgId());
                        } else {
                            List<String> orgNamesList = organizationClient.getChiefOrgNames(accountVO.getOrgId(), accountVO.getCompanyId());
                            if (!CollectionUtils.isEmpty(orgNamesList)) {
                                for (String s : orgNamesList) {
                                    if (StringUtils.isBlank(orgNames)) {
                                        orgNames = orgNames + s;
                                    } else {
                                        orgNames = orgNames + "/" + s;
                                    }
                                }
                                orgNamesMap.put(accountVO.getOrgId(), orgNames);
                            } else {
                                orgNames = "--";
                                orgNamesMap.put(accountVO.getOrgId(), "--");
                            }
                        }

                        //orgNames = organizationClient.getChiefOrgNames(accountVO.getOrgId(), accountVO.getCompanyId());
                    } catch (Exception e) {
                        LOG.error("获取用户信息报错：{}" ,e.getMessage(),e);
                        accountName = accountId.toString();
                        name = "--";
                        orgName = "--";
                    }
                    //写用户名、姓名	所在部门	考试提交时间	考试得分
                    row = sheet.createRow(insertRow++);
                    cell = row.createCell(0);
                    cell.setCellValue(accountName);
                    cell = row.createCell(1);
                    cell.setCellValue(name);
                    cell = row.createCell(2);
                    cell.setCellValue(orgName);
                    cell = row.createCell(3);
                    if (StringUtils.isNotBlank(orgNames)){
                        cell.setCellValue(orgNames);
                    }else {
                        cell.setCellValue("--");
                    }
                    cell = row.createCell(4);
                    cell.setCellValue(score.toString());
                    cell = row.createCell(5);
                    cell.setCellValue(questionCount - wrongCount);
                    cell = row.createCell(6);
                    cell.setCellValue(wrongCount);
//                    cell = row.createCell(5);
//                    cell.setCellValue(orgName);

//                    //查询答卷题目总数，进行分页
//                    subTotal = iExamReportService.selectExamAnswerSubjectByAccountIdCount(accountId, answerId);
//                    if (subTotal > subPageSize) {
//                        subPageTotal = subTotal / subPageSize;
//                        if (subTotal % subPageSize > 0) {
//                            subPageTotal += 1;
//                        }
//                    }
                    //查询题目
//                    for (int x = 0; x < subPageTotal; x++) {
                    //分页查询考生题目
                    examSubjectList = iExamReportService.getExamAnswerSubjectByAccountId(accountId, answerId, 0, subPageSize);
                    if (null == examSubjectList || examSubjectList.size() == 0) {
                        LOG.info("导出报表: examId = {} ,考生accountId = {} ,未查询到答卷记录,跳过!",examId,accountId);
                        continue;
                    }
                    //取出题目选项
                    for (int y = 0; y < examSubjectList.size(); y++) {
                        examsubjectVo = examSubjectList.get(y);
                        Long answerQuestionId = examsubjectVo.getId();
                        Long subjectId = examsubjectVo.getSubjectId();
                        String stem = examsubjectVo.getStem();
                        Integer curCellPos = subjectMap.get(subjectId);
                        if (null == curCellPos) {
                            curCellPos = curSubjectCellPos++;
                            subjectMap.put(subjectId, curCellPos);
                            //写题目信息
                            cell = subjectRow.createCell(curCellPos);
                            cell.setCellValue(stem);
                        }
                        //获取考生题目选项
                        List<com.yizhi.application.domain.TrExamAnswerQuestionRes> optsList
                                = iExamReportService.getExamAnswerSubjectOption(answerId, answerQuestionId, subjectId);


                        /*List<TrExamAnswerQuestionRes> optsList = null; //客观题作答选项集合
                        optsList = iExamReportService.getExamAnswerSubjectOption(answerId, answerQuestionId, subjectId);*/
                        if (null == optsList || optsList.size() == 0) {
                           /* TrExamAnswerQuestionResMa optMain = null;
                            optMain = iExamReportService.getExamAnswerSubjectOptionMain(answerId, answerQuestionId);*/

                            com.yizhi.application.domain.TrExamAnswerQuestionResMa optMain
                                    = iExamReportService.getExamAnswerSubjectOptionMain(answerId, answerQuestionId);

                            if (optMain != null) {
                                //写主观题作答内容
                                cell = row.createCell(curCellPos);
                                cell.setCellValue(optMain.getAnswer());
                            }
                        } else {
                            String value = "";
                            for (int z = 0; z < optsList.size(); z++) {
                                //TrExamAnswerQuestionRes opt = null;
                                //opt = optsList.get(z);
                                com.yizhi.application.domain.TrExamAnswerQuestionRes opt = optsList.get(z);
                                if (value.equals("")) {
                                    value = opt.getUpdateByName();
                                } else {
                                    value += "," + opt.getUpdateByName();
                                }
                            }
                            ///写客观题作答选项
                            cell = row.createCell(curCellPos);
                            cell.setCellValue(value);
                        }
                    }

                }
            }

            //写文件
            String urlPath = FileConstant.SAVE_PATH;
//            String urlPath = "/Users/dingxiaowei/aaa";
            File fileDir = new File(urlPath);
            if (!fileDir.exists()) {
                fileDir.mkdir();
            }
            String fileName = examName + "答卷下载" + df.format(submitTime) + ".xls";
            String path = urlPath + "/" + fileName;
            FileOutputStream os = null;
            File file = null;

            try {
                os = new FileOutputStream(path);
                workbook.write(os);
                upLoadUrl = OssUpload.upload(path, fileName);
                file = new File(path);
                success(taskContext, "成功", upLoadUrl);
            } catch (Exception e2) {
                fail(taskContext, "考试答卷导出任务写入过程出现错误");
                LOG.error("考试答卷导出任务写入过程出现错误",e2);
            } finally {
                if (os != null) {
                    os.close();
                }
                if (workbook != null) {
                    workbook.close();
                }
                if (file != null) {
                    file.delete();
                }
            }

        } catch (Exception e) {
            fail(taskContext, "考试答卷导出任务出现错误");
            LOG.error("考试答卷导出任务出现错误",e);
        }

        return upLoadUrl;
    }

    private List<TrExamAnswer> exechangeExamAnswers(List<com.yizhi.application.domain.TrExamAnswer> maxScoreeExamAnswerInfo) {

        List<TrExamAnswer> list = new ArrayList<>();
        maxScoreeExamAnswerInfo.forEach(maxScoreeExamAnswerInfoVo -> {
            TrExamAnswer answer = new TrExamAnswer();
            BeanUtils.copyProperties(maxScoreeExamAnswerInfoVo,answer);
            list.add(answer);
        });
        return list;
    }
}
