package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.domain.TrExamAnswerQuestionRes;
import com.yizhi.application.domain.TrExamAnswerQuestionResMa;
import com.yizhi.exam.application.vo.ExamCountByUserVO;
import com.yizhi.exam.application.vo.ExamQuestionSubjectVo;
import com.yizhi.exam.application.vo.report.*;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 考试报表统计
 *
 * @author mei
 */
public interface ExamReportMapper {

    /**
     * 合计最高分数答卷的考生数
     *
     * @param paramMap
     * @return
     */
    public Integer selectMaxScoreeExamAnswerCount(@Param("map") Map<String, Object> paramMap);

    /**
     * 合计最高分数答卷的考生信息
     *
     * @param paramMap
     * @param pageNo
     * @param pageSize
     * @return
     */
    public List<TrExamAnswer> selectMaxScoreeExamAnswerInfo(@Param("map") Map<String, Object> paramMap, Page<TrExamAnswer> page);

    /**
     * 查询考生考试题目数
     *
     * @param accountId
     * @param answerId
     * @return
     */
    public Integer selectExamAnswerSubjectByAccountIdCount(@Param("accountId") Long accountId, @Param("answerId") Long answerId);

    /**
     * 查询考生考试题目
     *
     * @param accountId
     * @param answerId
     * @return
     */
    public List<ExamQuestionSubjectVo> selectExamAnswerSubjectByAccountId(@Param("accountId") Long accountId, @Param("answerId") Long answerId,
                                                                          @Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

    /**
     * 获取客观题选项
     *
     * @param answerId
     * @param answerQuestionId
     * @param subjectId
     * @return
     */
    public List<TrExamAnswerQuestionRes> selectExamAnswerSubjectOption(@Param("answerId") Long answerId, @Param("answerQuestionId") Long answerQuestionId,
                                                                       @Param("subjectId") Long subjectId);

    /**
     * 获取主管题选项
     *
     * @param answerId
     * @param answerQuestionId
     * @return
     */
    public TrExamAnswerQuestionResMa selectExamAnswerSubjectOptionMain(@Param("answerId") Long answerId, @Param("answerQuestionId") Long answerQuestionId);

    /**
     * 按考试统计
     *
     * @param param
     * @param examIds
     * @return
     */
    public List<ReportExamVO> getExamGroup(@Param("param") ReportExamParam param, @Param("examIds") List<Long> examIds);
    //public List<ReportExamVO> getExamGroup(@Param("param") ReportExamParam param, Page<ReportExamVO> page);
    /*@Param("startTime") String startTime, @Param("endTime") String endTime, @Param("kwd") String kwd,	@Param("siteId") Long siteId, @Param("orgIds") List<Long> orgIds);*/

    /**
     * 按考试统计（按用户统计）
     */
    public List<ReportExamAccountsViewVo> getExamAndAccountGroup(@Param("param") ExamCountByUserVO param, Page<ReportExamAccountsViewVo> page);

    /**
     * 按用户统计
     */
    //public List<ReportExamAccountVO> getExamAccountGroup(@Param(("param")) ExamCountByUserVO param, Page<ReportExamAccountVO> page);
    public List<ReportExamAccountVO> getExamAccountGroup(@Param("param") ExamCountByUserVO param, @Param("accountIds") List<Long> accountIds);

    /**
     * 按用户统计——查看
     */
    public List<ReportExamAccountViewVo> getExamAccountGroupView(@Param("accountId") Long accountId,
                                                                 @Param("startTime") String startTime,
                                                                 @Param("endTime") String endTime,
                                                                 @Param("examNameLike") String examNameLike,
                                                                 Page<ReportExamAccountViewVo> page);

    Integer getExamAccountGroupViewCount(@Param("accountId") Long accountId,
                                         @Param("startTime") String startTime,
                                         @Param("endTime") String endTime);

    /**
     * 统计实考人数，多次考试的只计算一次
     *
     * @param ids
     * @return
     */
    @MapKey("exam_id")
    public Map<Long, Map<Long, Object>> getExamInCount(@Param("ids") List<Long> ids);

    /**
     * 统计考试平均分，多次考试的只取最高一次的分数
     *
     * @param ids
     * @return
     */
    @MapKey("exam_id")
    public Map<Long, Map<Long, Object>> getExamAvgScore(@Param("ids") List<Long> ids);

    /**
     * 统计考试通过人数，多次考试的只计算一次
     *
     * @param ids
     * @return
     */
    @MapKey("exam_id")
    public Map<Long, Map<Long, Object>> getExamPassCount(@Param("ids") List<Long> ids);

    /**
     * 获取考试分数段
     *
     * @param examId
     * @return
     */
    public List<Map<String, Object>> getExamScoreLevel(@Param("examId") Long examId);

    /**
     * 获取分数段人数
     *
     * @param examId
     * @param minScore
     * @param maxScore
     * @param startTime
     * @param endTime
     * @return
     */
    public Integer getExamScoreTotal(@Param("examId") Long examId,
                                     @Param("minScore") BigDecimal minScore,
                                     @Param("maxScore") BigDecimal maxScore,
                                     @Param("startTime") String startTime,
                                     @Param("endTime") String endTime);

    /**
     * 获取答题人数或正确答题人数
     *
     * @param answerIds 答卷集合
     * @param isRight   是否统计正确答题人数
     * @return
     */
    @MapKey("id")
    public Map<Long, Map<String, Object>> getExamAnswerSubjectCountInfo(@Param("answerIds") List<TrExamAnswer> answerIds, @Param("isRight") Integer isRight);

    /**
     * 获取考试合格分
     *
     * @param examId
     * @return
     */
    public Integer getQualifieldScore(@Param("examId") Long examId);

    /**
     * 从记录表获取学员信息
     *
     * @param accountId
     * @return
     */
    public List<ReportExamAccountsViewVo> getAccounts(@Param("examId") Long examId,
                                                      @Param("siteId") Long siteId,
                                                      @Param("accountNameLike") String accountNameLike,
                                                      @Param("orgNameLike") String orgNameLike);

    public List<ReportExamAccountsViewVo> getExamAndAccountGroupView(@Param("accountIds") List<Long> accountIds,
                                                                     @Param("examId") Long examId,
                                                                     @Param("startTime") String startTime,
                                                                     @Param("endTime") String endTime,
                                                                     @Param("page") Page<ReportExamAccountsViewVo> page);

    public Integer getWrongCount(Long answerId);

    public Integer getQuestionCount(Long answerId);

    List<ReportExamSubjectChartsVotr> getExamSubGroupView(@Param("examId") Long examId);

    List<Long> getResMaRightId(@Param("answerId") Long answerId, @Param("examId") Long examId);

    List<Long> getWrongIds(@Param("answerId") Long answerId);

    List<Long> getQuestionIds(@Param("answerId") Long answerId);

    ReportExamAccountsViewVo getAccount(@Param("accountId") Long accountId, @Param("examId") Long examId, @Param("siteId") Long siteId);
}
