package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.application.domain.TrExamAuthorize;
import com.yizhi.exam.application.vo.TrExamAuthorizeVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 考试人员范围 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface TrExamAuthorizeMapper extends BaseMapper<TrExamAuthorize> {

	/**
	 * 根据考试id得到应该考试人员id
	 * 
	 * @param examId
	 * @return
	 */
	List<Long> selectRelationidByExamid(@Param("examId") Long examId);

	@Select(" SELECT id,exam_id AS examId,TYPE,relation_id AS relationId,name FROM tr_exam_authorize a WHERE exam_id = #{examId} AND state = 1")
	List<TrExamAuthorizeVO> listTrExamAuthorize(@Param("examId") Long examId);

	List<Long> selectAuthorizeByRelationId(@Param("ids") List<Long> ids, @Param("siteId") Long siteId);

	List<Long> getUsefulIds(@Param("ids") List<Long> ids,
							@Param("relationIds") List<Long> relationIds,
							@Param("siteId") Long siteId);

}
