package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.constant.ExamConstant;
import com.yizhi.application.mapper.*;
import com.yizhi.application.orm.hierarchicalauthorization.HQueryUtil;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.*;
import com.yizhi.application.util.ExamEvenSendMessage;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.TaskParamsEnums;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.domain.TrExamAnswer;
import com.yizhi.exam.application.vo.domain.TrExamPoint;
import com.yizhi.exam.application.vo.domain.TrExamQuestionSort;
import com.yizhi.exam.application.vo.exam.ExamDetailsVO;
import com.yizhi.exam.application.vo.exam.*;
import com.yizhi.util.application.clazz.ClassUtil;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.enums.i18n.ButtonStatus;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Executor;

/**
 * <p>
 * 考试 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class ExamServiceImpl extends ServiceImpl<ExamMapper, com.yizhi.application.domain.Exam> implements IExamService {

    private static Logger logger = LoggerFactory.getLogger(ExamServiceImpl.class);
    private static final String[] properties = new String[]{"stem", "typeValue", "isAnswer", "analysis", "questionLabel", "name", "content1", "content2", "content3", "content4"};

    @Autowired
    private ExamMapper examMapper;

    @Autowired
    private TrExamSystemQuestionMapper trExamSystemQuestionMapper;

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private ITrExamQuestionService trExamQuestionService;
    @Autowired
    private ITrExamSystemQuestionService trExamSystemQuestionService;
    @Autowired
    private ITrExamQuestionSortService trExamQuestionSortService;
    @Autowired
    private ITrExamAuthorizeService trExamAuthorizeService;
    @Autowired
    private ITrExamScoreEvaluateService trExamScoreEvaluateService;
    @Autowired
    private ITrExamPointService trExamPointService;
    @Autowired
    private ITrExamRemindService trExamRemindService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ExamEvenSendMessage examEvenSendMessage;


    @Autowired
    private TrExamQuestionSortMapper trExamQuestionSortMapper;

    @Autowired
    ITrExamScoreEvaluateService iTrExamScoreEvaluateService;

    @Autowired
    ITrExamAnswerService iTrExamAnswerService;

    @Autowired
    ITrExamQuestionSortService iTrExamQuestionSortService;

    @Autowired
    TrQuestionLibrarySubjectMapper trQuestionLibrarySubjectMapper;
    @Autowired
    TrQuestionSubjectOptionMapper trQuestionSubjectOptionMapper;
    @Autowired
    TrExamQuestionMapper trExamQuestionMapper;

    @Autowired
    TrExamAuthorizeMapper trExamAuthorizeMapper;

    @Autowired
    TrExamOnlineReadOverMapper trExamOnlineReadOverMapper;


    @Autowired
    private TrExamAnswerMapper trExamAnswerMapper;

    @Autowired
    TrExamScoreEvaluateMapper trExamScoreEvaluateMapper;

    @Autowired
    TrExamRemindMapper trExamRemindMapper;

    @Autowired
    TrExamPointMapper trExamPointMapper;

    @Autowired
    IStudentExamPaperService iStudentExamPaperService;

    @Autowired
    Executor executor;

    private Long examId = null;

    /**
     * 考试策略 更新 发布
     */
    public Long releaseExamRelated(ExamStrategyVO vo) {
        return updateExamStrategy(vo, ExamConstant.TWO);
    }


    public List<ExamQuestionTypeVO> selectType(Long examId) {
        return examMapper.selectTypeById(examId);
    }

    @Override
    public List<MyExamVO> MyExam(MyExamParameterVO myExamParameterVO) {
        Integer strat = (myExamParameterVO.getPageNo() - 1) * myExamParameterVO.getPageSize();
        Integer end = myExamParameterVO.getPageSize();
        List<Long> examIds = getMyVisableExam(myExamParameterVO.getIds(), myExamParameterVO.getSiteId());
        if (!CollectionUtils.isEmpty(examIds)) {
            myExamParameterVO.setIds(examIds);
        }
        //获取所有考试信息
        //查询
        Long siteId = myExamParameterVO.getSiteId();
        Long accountId = myExamParameterVO.getAccountId();
        List<MyExamVO> list = examMapper.selectMyExamInfo(strat, end, examIds, myExamParameterVO.getState(), accountId, siteId);
        if (myExamParameterVO.getState() != null && myExamParameterVO.getState() == 1) {
            for (MyExamVO myExamVO : list) {
                List<ExamOnlineReadOverVo> examOnlineReadOverVos = trExamOnlineReadOverMapper.selectStateList(myExamVO.getId(), myExamParameterVO.getAccountId());
                if (examOnlineReadOverVos.size() > 0) {
                    for (ExamOnlineReadOverVo examOnlineReadOverVo : examOnlineReadOverVos) {
                        if (examOnlineReadOverVo.getState() == 1) {
                            myExamVO.setIsQualified(2 + "");
                        }
                    }
                }
            }
        }
        return list;
    }

    /**
     * 考试策略 更新 保存, 预览
     */
    public Long updateOrPreviewExamStrategy(ExamStrategyVO vo) {
        return updateExamStrategy(vo, ExamConstant.FIRST);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public Long updateExamStrategy(ExamStrategyVO vo, Integer state) {
        com.yizhi.application.domain.Exam e = this.selectById(vo.getId());
        Long siteId = 0l;
        Date time = new Date();
        if (e != null) {
            siteId = e.getSiteId();
            e.setVisibleRange(vo.getVisibleRange());
            e.setPageMode(vo.getPageMode());
            e.setIsAnswerPaper(vo.getIsAnswerPaper());
            e.setIsScore(vo.getIsScore());
            e.setIsAnswer(vo.getIsAnswer());
            e.setIsAnalysis(vo.getIsAnalysis());
            e.setIsPaperid(vo.getIsPaperid());
            e.setIsPoint(vo.getIsPoint());
            e.setRemind(vo.getRemind());
            e.setSiteId(vo.getSiteId());
            if (state == ExamConstant.TWO) {
                e.setState(ExamConstant.TWO);
                e.setUpTime(time);
            }
            e.setEnableTask(vo.getEnableTask());
            e.setUpdateById(vo.getAccountId());
            e.setUpdateByName(vo.getAccountName());
            e.setUpdateTime(time);
            Integer qualifiedScore = vo.getQualifiedScore();
            e.setQualifiedScore(qualifiedScore);
            this.updateById(e);
            if (qualifiedScore == null) {
                examMapper.updataQualifiedScore(vo.getId());
            }

        }
        // 考试人员范围 TrExamAuthorizeVo
        // 新增 考试人员范围
        try {
            if (vo.getTrExamAuthorizeVoList() != null && !vo.getTrExamAuthorizeVoList().isEmpty()) {
                trExamAuthorizeService.updateTrExamAuthorizeList(vo.getTrExamAuthorizeVoList(), vo.getId());
            }

            // 考试分数通用评价 TrExamScoreEvaluateVo
            if (vo.getTrExamScoreEvaluateVoList() != null && !vo.getTrExamScoreEvaluateVoList().isEmpty()) {
                trExamScoreEvaluateService.updateTrExamScoreEvaluateList(vo.getTrExamScoreEvaluateVoList(), vo.getId());
            }

            // 考试积分 TrExamPointVo
            if (vo.getTrExamPointVoList() != null && !vo.getTrExamPointVoList().isEmpty()) {
                trExamPointService.updateTrExamPointList(vo.getTrExamPointVoList(), vo.getAccountId(), vo.getAccountName(), vo.getId());
            }

            // 提醒设置 TrExamRemindVo
            if (vo.getTrExamRemindVO() != null &&
                    vo.getTrExamRemindVO().getTrExamRemindTimeVoList() != null &&
                    !vo.getTrExamRemindVO().getTrExamRemindTimeVoList().isEmpty()) {
//                trExamRemindService.updateTrExamRemind(vo.getTrExamRemindVO(), vo.getId(), vo.getAccountName(), vo.getAccountId());
            }

            try { //发消息告知提醒有变化

                if (vo.getMessageRemindVo() != null || e != null) {
                    e.setSiteId(siteId);
                    RequestContext context = ContextHolder.get();
                    taskExecutor.asynExecute(new AbstractTaskHandler() {
                        @Override
                        public void handle() {
                            Exam examVo = new Exam();
                            BeanUtils.copyProperties(e,examVo);
                            examEvenSendMessage.systemSendMessage(examVo, vo.getMessageRemindVo(),context );
                        }
                    });
                }
            } catch (Exception e1) {
                e1.printStackTrace();
            }

            if (state.equals(ExamConstant.TWO)) {
                //添加考试缓存
                createExamCache(e, time);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return vo.getId();
    }

    /**
     * 考试策略 列表
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public ExamStrategyVO listExamStrategy(Long examId) {
        ExamStrategyVO vo = new ExamStrategyVO();
        com.yizhi.application.domain.Exam e = this.selectById(examId);
        vo.setId(examId);
        vo.setVisibleRange(e.getVisibleRange());
        vo.setPageMode(e.getPageMode());
        vo.setIsAnswerPaper(e.getIsAnswerPaper());
        vo.setIsScore(e.getIsScore());
        vo.setIsAnswer(e.getIsAnswer());
        vo.setIsAnalysis(e.getIsAnalysis());
        vo.setIsPaperid(e.getIsPaperid());
        vo.setIsPoint(e.getIsPoint());
        vo.setRemind(e.getRemind());
        // 考试人员范围
        if (e.getVisibleRange() == ExamConstant.TWO) {
            List<TrExamAuthorizeVO> trExamAuthorizeVoList = trExamAuthorizeService.listTrExamAuthorize(examId);
            vo.setTrExamAuthorizeVoList(trExamAuthorizeVoList);
        }
        // 考试分数通用评价
        if (e.getIsPaperid() != ExamConstant.ZERO) {
            List<TrExamScoreEvaluateVO> trExamScoreEvaluateVoList = trExamScoreEvaluateService
                    .listTrExamScoreEvaluate(examId);
            vo.setTrExamScoreEvaluateVoList(trExamScoreEvaluateVoList);
        }
        // 考试积分
        if (e.getIsPoint() == ExamConstant.FIRST) {
            List<TrExamPointVO> trExamPointVoList = trExamPointService.listTrExamPoint(examId);
            vo.setTrExamPointVoList(trExamPointVoList);
        }
        // 提醒设置
        if (e.getRemind() == ExamConstant.FIRST) {
            TrExamRemindVO trExamRemindVo = trExamRemindService.listTrExamRemind(examId);
            vo.setTrExamRemindVO(trExamRemindVo);
        }
        return vo;
    }

    /**
     * 修改 添加试题
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public Long updateExamQuestion(AddQuestionVO vo) {
        Long examId = vo.getId();
        try {
            com.yizhi.application.domain.Exam selectById = this.selectById(examId);
            selectById.setSysMakeStrategy(vo.getSysMakeStrategy());
            selectById.setStemSort(vo.getStemSort());
            selectById.setOptionSort(vo.getOptionSort());
            this.updateById(selectById);
            // 更新试题列表
            trExamQuestionService.updateTrExamQuestionList(vo.getExamQuestionVoList(), examId, vo.getAccountName(), vo.getAccountId());

            // 更新 系统出题规则
            if (vo.getTrExamSystemQuestionVoList() != null) {
                trExamSystemQuestionService.updateTrExamSystemQuestionList(vo.getTrExamSystemQuestionVoList(), examId);
            }

            // 更新 题型排序
            trExamQuestionSortService.updateTrExamQuestionSortList(vo.getTrExamQuestionSortVoList(), examId);
        } catch (Exception e) {
            return 0L;
        }

        return 1L;
    }

    /**
     * 考试基本 信息 保存
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public Long insertOrUpdateBaseInfo(BaseInfoVO vo) {
        com.yizhi.application.domain.Exam e = new com.yizhi.application.domain.Exam();
        try {
            if (vo.getId() != null) { // 修改
                e = this.selectById(vo.getId());
                Integer a = e.getMakeStrategy();
                Integer b = vo.getMakeStrategy();
                Integer state = e.getState();
                setBaseInfo(vo, e);
                setInsertExamCloumn(e, vo.getAccountId(), vo.getAccountName(), false);
                e.setState(state);
                this.updateById(e);
                if (a != b) {
                    trExamQuestionService.deleteByExamId(vo.getId());
                    e.setLibraryId(0L);
                    e.setLibraryName("");
                    com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
                    BeanUtils.copyProperties(e,exam);
                    examMapper.updateById(exam);
                    Map<String, Object> clownMap = new HashMap<>();
                    clownMap.put("exam_id", vo.getId());
                    trExamSystemQuestionMapper.deleteByMap(clownMap);
                }
            } else { // 新增
                if (StringUtils.isBlank(vo.getOldExamNo())) { // 全新增的数据
                    e.setId(idGenerator.generate());
                    e.setExamNo(queryMaxExamNo());
                    setBaseInfo(vo, e);
                    setInsertExamCloumn(e, vo.getAccountId(), vo.getAccountName(), true);
                    e.setCompanyId(vo.getCompanyId());
                    e.setSiteId(vo.getSiteId());
                    e.setOrgId(vo.getOrgId());
                    this.insert(e);
                } /*else { // 新增 复制考试数据
					Exam old = this.selectById(vo.getOldExamId());
					BeanUtils.copyProperties(old, e);
					e.setId(idGenerator.generate());
					e.setExamNo(queryMaxExamNo());
					setBaseInfo(vo, e);
					setInsertExamCloumn(e, vo.getAccountId(), vo.getAccountName(), true);
					e.setCompanyId(vo.getCompanyId());
					e.setSiteId(vo.getSiteId());
					e.setOrgId(vo.getOrgId());
					this.insert(e);
				*//*	copyExamRelated(vo.getOldExamId(), e,vo.getAccountId(),vo.getAccountName());*//*
				}*/
            }
        } catch (Exception a) {
            a.printStackTrace();
            return null;
        }
        return e.getId();
    }

    /**
     * 新增 复制考试数据
     */
	/*@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean copyExamRelated(Long oldId, Exam e,Long accountId,String accountName) {
		// 复制考试题目
		trExamQuestionService.copyExamQuestion(oldId, e.getId(),accountName,accountId);

		// 复制系统出题规则
		*//*if (e.getMakeStrategy() == ExamConstant.TWO) {
			trExamSystemQuestionService.copyTrExamSystemQuestion(oldId, e.getId());
		}*//*

		// 复制 题型排序
		if (e.getStemSort() == ExamConstant.TWO) {
			trExamQuestionSortService.copyTrExamQuestionSort(oldId, e.getId());
		}

		// 复制 考试人员范围
		if (e.getVisibleRange() == ExamConstant.TWO) {
			trExamAuthorizeService.copyTrExamAuthorize(oldId, e.getId());
		}

		// 复制 考试分数通用评价
		if (e.getIsPaperid() == ExamConstant.FIRST || e.getIsPaperid() == ExamConstant.TWO) {
			trExamScoreEvaluateService.copyTrExamScoreEvaluate(oldId, e.getId());
		}

		// 复制 考试积分
		if (e.getIsPoint() == ExamConstant.FIRST) {
			trExamPointService.copyTrExamPoint(oldId, e.getId());
		}

		// 复制 提醒设置
		if (e.getRemind() == ExamConstant.FIRST) {
			trExamRemindService.copyTrExamRemind(oldId, e.getId());
		}
		return true;
	}*/
    public Page<Exam> examList(String currentTime, String name, Integer state, Integer pageSize, Integer pageNo, Long companyId, Long siteId, List<Long> orgIds) {
        // TODO Auto-generated method stub
        Page<com.yizhi.application.domain.Exam> page = new Page<>(pageNo, pageSize, "update_time", false);
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        if (companyId != null) {
            exam.setCompanyId(companyId); // 根据公司id查找
        }
        exam.setSiteId(siteId);
        exam.setState(state);
        EntityWrapper<com.yizhi.application.domain.Exam> wrapper = new EntityWrapper<com.yizhi.application.domain.Exam>(exam);
        String date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isNotBlank(currentTime)) {
            Long timeStamp = null;
            try {
                timeStamp = Long.valueOf(currentTime);
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            date = sdf.format(timeStamp);
            wrapper.and().gt("end_time", date).and().lt("start_time", date);
        }
        if (StringUtils.isNotEmpty(name) && !name.trim().equals("")) {
            wrapper.andNew().like("name", name).or().like("keywords", name);
        }
        HQueryUtil.startHQ(Exam.class);
        Page<com.yizhi.application.domain.Exam> examPage = this.selectPage(page, wrapper);
        List<com.yizhi.application.domain.Exam> records = examPage.getRecords();
        List<Exam> list = new ArrayList<>();
        if (null != records && records.size() > 0){
            records.forEach(examEntity -> {
                Exam examVo = new Exam();
                BeanUtils.copyProperties(examEntity,examVo);
                list.add(examVo);
            });
        }
        Page<Exam> pageVo = new Page<>();
        pageVo.setRecords(list);
        return pageVo;
    }

    public Integer sumNum(String currentTime, String name, Integer state, Long companyId, Long siteId, List<Long> orgIds) {
        // TODO Auto-generated method stub
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        if (companyId != null) {
            exam.setCompanyId(companyId); // 根据公司id查找
        }
        exam.setSiteId(siteId);
        exam.setState(state);
        EntityWrapper<com.yizhi.application.domain.Exam> wrapper = new EntityWrapper<com.yizhi.application.domain.Exam>(exam);
        if (StringUtils.isNotEmpty(name) && !name.trim().equals("")) {
            wrapper.andNew().like("name", name).or().like("keywords", name);
        }
//        if (!CollectionUtils.isEmpty(orgIds)) {
//            wrapper.in("org_id", orgIds);
//        }
        String date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        if (StringUtils.isNotBlank(currentTime)) {
            long temp = Long.valueOf(currentTime);
            date = simpleDateFormat.format(temp);
            wrapper.and().gt("start_time", date).and().lt("end_time", date);

        }
        HQueryUtil.startHQ(Exam.class);
        return this.selectCount(wrapper);
    }

    /**
     * 批阅试卷列表
     */
    public List<Exam> examMarkingList(ContextAndPageSizeVO contextAndPageSizeVO) {
        List<Exam> list = new ArrayList<>();
        HQueryUtil.startHQ(Exam.class);
        List<com.yizhi.application.domain.Exam> examsList = examMapper.idList(contextAndPageSizeVO);
        examsList.forEach(exam -> {
            Exam examVo = new Exam();
            BeanUtils.copyProperties(exam,examVo);
            list.add(examVo);
        });
       // List<Exam> idList = examMapper.idList(contextAndPageSizeVO); // 得到去重的
        // 没有问答题的试卷列表
        return list;
    }

    /**
     * 批阅试卷列表的总记录数目
     */
    public Integer getMarkingListNum(String name) {
        // TODO Auto-generated method stub
        Long siteId = 0L;
        if (null != ContextHolder.get()) {
            siteId = ContextHolder.get().getSiteId();
        }
        Integer markingListNum = examMapper.getMarkingListNum(name, siteId);
        return markingListNum;
    }

    public boolean deleteExam(Long[] examId) {
        List<Long> list = Arrays.asList(examId);
        if (CollectionUtils.isEmpty(list)){
            return false;
        }
        EntityWrapper<com.yizhi.application.domain.TrExamQuestion> wrapper = new EntityWrapper<>();
        wrapper.in("exam_id", examId);
        trExamQuestionMapper.delete(wrapper);
        EntityWrapper<com.yizhi.application.domain.TrExamSystemQuestion> entityWrapper = new EntityWrapper<>();
        entityWrapper.in("exam_id", examId);
        trExamSystemQuestionMapper.delete(entityWrapper);
        examMapper.deleteExams(list);
        return true;
    }

    public boolean examPutUp(Long examId) {
        Date date = new Date();
        if (examId != null) {
            int i = examMapper.updateState(2, examId, date, null);
            //添加考试缓存
            com.yizhi.application.domain.Exam exam = this.selectById(examId);
            createExamCache(exam, new Date());

            if (i > 0) {
                updateStatus(exam,ContextHolder.get());
            }
            return true;
        }
        return false;
    }

    public boolean examPutDown(Long examId) {
        if (examId != null) {
            Date date = new Date();
            int i = examMapper.updateState(3, examId, null, date);

            //下架清空考试缓存
            try {
                iStudentExamPaperService.clearExam(examId);
            } catch (Exception e) {
                logger.error("删除考试{}缓存失败", examId);
                e.printStackTrace();
            }
            if (i > 0) {
                com.yizhi.application.domain.Exam exam = this.selectById(examId);
                updateStatus(exam,ContextHolder.get());
            }
            return true;
        }
        return false;
    }

    /**
     * 发消息告知业务状态改变
     *
     * @param exam
     * @param context
     */
    public void updateStatus(com.yizhi.application.domain.Exam exam, RequestContext context) {
        try { //发消息告知业务状态有变化
            if (exam != null) {
                if (exam.getRemind() == 1) {
                    MessageRemindVo remindVo = new MessageRemindVo();
                    remindVo.setTaskStatusUpdate(true);
                    taskExecutor.asynExecute(new AbstractTaskHandler() {
                        @Override
                        public void handle() {
                            Exam examVO = new Exam();
                            BeanUtils.copyProperties(exam,examVO);
                            examEvenSendMessage.systemSendMessage(examVO, remindVo, context);
                        }
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public List exportAnswer(Long examId) {

        return null;
    }

    /**
     * 复制考试
     */
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public boolean copyExamAndView(Exam examVo) {
        BaseInfoVO vo = new BaseInfoVO();
        Long accountId = examVo.getCreateById();
        String accountName = examVo.getCreateByName();
        Date time = new Date();
        boolean insertExam = true;
        StringBuffer sb = new StringBuffer();
        String copyName = "[复制件]";
        //复制考试
        com.yizhi.application.domain.Exam exam = this.selectById(examVo.getId());
        if (null != exam) {
            exam.setId(idGenerator.generate());
            exam.setExamNo(queryMaxExamNo());
            exam.setOldExamNo(exam.getExamNo());
            String name = exam.getName();
            sb.append(name);
            sb.append(copyName);
            exam.setName(sb.toString());
            exam.setState(1);    //设置状态为未上架
            insertExam = this.insert(exam);
        }
        //复制该考试考试题目
        com.yizhi.application.domain.TrExamQuestion trExamQuestion = new com.yizhi.application.domain.TrExamQuestion();
        trExamQuestion.setExamId(examVo.getId());
        trExamQuestion.setState(1);
        EntityWrapper<com.yizhi.application.domain.TrExamQuestion> examQuestionWrapper = new EntityWrapper<>(trExamQuestion);
        List<com.yizhi.application.domain.TrExamQuestion> trExamQuestionsList = trExamQuestionMapper.selectList(examQuestionWrapper);
        /*List<TrExamQuestion> trExamQuestions = new ArrayList<>();
        trExamQuestionsList.forEach(trExamQuestion1 -> {
            TrExamQuestion question = new TrExamQuestion();
            BeanUtils.copyProperties(trExamQuestion,question);
            trExamQuestions.add(question);
        });*/
        //List<TrExamQuestion> trExamQuestions = trExamQuestionMapper.selectList(examQuestionWrapper);
        List<com.yizhi.application.domain.TrExamQuestion> trExamQuestions1 = new ArrayList<>();
        for (com.yizhi.application.domain.TrExamQuestion trExamQuestion1 : trExamQuestionsList) {
            trExamQuestion1.setExamId(exam.getId());
            trExamQuestion1.setId(idGenerator.generate());
            trExamQuestion1.setCreateById(accountId);
            trExamQuestion1.setCreateByName(accountName);
            trExamQuestion1.setCreateTime(time);
            trExamQuestion1.setUpdateById(accountId);
            trExamQuestion1.setUpdateByName(accountName);
            trExamQuestion1.setUpdateTime(time);
            trExamQuestions1.add(trExamQuestion1);
        }
        boolean insertExamQuestion = true;
        if (trExamQuestions1.size() > 0) {
            insertExamQuestion = trExamQuestionService.insertAll(trExamQuestions1);
        }
        //复制试题类型排序
        com.yizhi.application.domain.TrExamQuestionSort trExamQuestionSort = new com.yizhi.application.domain.TrExamQuestionSort();
        trExamQuestionSort.setExamId(examVo.getId());
        EntityWrapper<com.yizhi.application.domain.TrExamQuestionSort> examQuestionSortWrapper = new EntityWrapper<>(trExamQuestionSort);
        List<com.yizhi.application.domain.TrExamQuestionSort> trExamQuestionSorts = trExamQuestionSortMapper.selectList(examQuestionSortWrapper);

        //List<TrExamQuestionSort> trExamQuestionSorts = trExamQuestionSortMapper.selectList(examQuestionSortWrapper);
        List<com.yizhi.application.domain.TrExamQuestionSort> trExamQuestionSorts1 = new ArrayList<>();
        for (com.yizhi.application.domain.TrExamQuestionSort trExamQuestionSort1 : trExamQuestionSorts) {
            trExamQuestionSort1.setExamId(exam.getId());
            trExamQuestionSort1.setId(idGenerator.generate());
            trExamQuestionSort1.setCreateById(accountId);
            trExamQuestionSort1.setCreateByName(accountName);
            trExamQuestionSort1.setCreateTime(time);
            trExamQuestionSort1.setUpdateById(accountId);
            trExamQuestionSort1.setUpdateByName(accountName);
            trExamQuestionSort1.setUpdateTime(time);
            trExamQuestionSorts1.add(trExamQuestionSort1);
        }
        boolean examQuestionSortResult = true;
        if (trExamQuestionSorts1.size() > 0) {
            examQuestionSortResult = trExamQuestionSortService.insertAll(trExamQuestionSorts1);
        }
        //复制系统出题规则
        com.yizhi.application.domain.TrExamSystemQuestion trExamSystemQuestion = new com.yizhi.application.domain.TrExamSystemQuestion();
        trExamSystemQuestion.setExamId(examVo.getId());
        trExamSystemQuestion.setState(1);
        EntityWrapper<com.yizhi.application.domain.TrExamSystemQuestion> trExamSystemQuestionEntityWrapper
                = new EntityWrapper<com.yizhi.application.domain.TrExamSystemQuestion>(trExamSystemQuestion);
        List<com.yizhi.application.domain.TrExamSystemQuestion> trExamSystemQuestions = trExamSystemQuestionMapper.selectList(trExamSystemQuestionEntityWrapper);
        List<com.yizhi.application.domain.TrExamSystemQuestion> trExamSystemQuestions1 = new ArrayList<>();
        for (com.yizhi.application.domain.TrExamSystemQuestion trExamSystemQuestion1 : trExamSystemQuestions) {
            trExamSystemQuestion1.setExamId(exam.getId());
            trExamSystemQuestion1.setId(idGenerator.generate());
            trExamSystemQuestion1.setCreateById(accountId);
            trExamSystemQuestion1.setCreateByName(accountName);
            trExamSystemQuestion1.setCreateTime(time);
            trExamSystemQuestion1.setUpdateById(accountId);
            trExamSystemQuestion1.setUpdateByName(accountName);
            trExamSystemQuestion1.setUpdateTime(time);
            trExamSystemQuestions1.add(trExamSystemQuestion1);
        }
        boolean examSystemQuestionResult = true;
        if (trExamSystemQuestions1.size() > 0) {
            examSystemQuestionResult = trExamSystemQuestionService.insertBatchs(trExamSystemQuestions1);
        }
        //复制分数通用评价
		/*TrExamScoreEvaluate trExamScoreEvaluate = new TrExamScoreEvaluate();
		trExamScoreEvaluate.setExamId(examVo.getId());
		trExamScoreEvaluate.setState(1);
		EntityWrapper<TrExamScoreEvaluate> trExamScoreEvaluateEntityWrapper = new EntityWrapper<TrExamScoreEvaluate>(trExamScoreEvaluate);
		List<TrExamScoreEvaluate> trExamScoreEvaluates = trExamScoreEvaluateMapper.selectList(trExamScoreEvaluateEntityWrapper);*/
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("exam_id", examVo.getId());
        map.put("state", 1);
        List<com.yizhi.application.domain.TrExamScoreEvaluate> trExamScoreEvaluates = trExamScoreEvaluateMapper.selectByMap(map);
        List<com.yizhi.application.domain.TrExamScoreEvaluate> trExamScoreEvaluates1 = new ArrayList<>();
        for (com.yizhi.application.domain.TrExamScoreEvaluate trExamScoreEvaluate1 : trExamScoreEvaluates) {
            trExamScoreEvaluate1.setExamId(exam.getId());
            trExamScoreEvaluate1.setId(idGenerator.generate());
            trExamScoreEvaluate1.setCreateById(accountId);
            trExamScoreEvaluate1.setCreateByName(accountName);
            trExamScoreEvaluate1.setCreateTime(time);
            trExamScoreEvaluate1.setUpdateById(accountId);
            trExamScoreEvaluate1.setUpdateByName(accountName);
            trExamScoreEvaluate1.setUpdateTime(time);
            trExamScoreEvaluates1.add(trExamScoreEvaluate1);
        }
        boolean examScoreEvaluateResult = true;
        if (trExamScoreEvaluates1.size() > 0) {
            examScoreEvaluateResult = trExamScoreEvaluateService.insertAll(trExamScoreEvaluates1);
        }
        //复制考试人员范围
        com.yizhi.application.domain.TrExamAuthorize trExamAuthorize = new com.yizhi.application.domain.TrExamAuthorize();
        trExamAuthorize.setExamId(examVo.getId());
        trExamAuthorize.setState(1);
        EntityWrapper<com.yizhi.application.domain.TrExamAuthorize> trExamAuthorizeEntityWrapper = new EntityWrapper<com.yizhi.application.domain.TrExamAuthorize>(trExamAuthorize);
        List<com.yizhi.application.domain.TrExamAuthorize> trExamAuthorizes = trExamAuthorizeMapper.selectList(trExamAuthorizeEntityWrapper);
        List<com.yizhi.application.domain.TrExamAuthorize> trExamAuthorizes1 = new ArrayList<>();
        for (com.yizhi.application.domain.TrExamAuthorize trExamAuthorize1 : trExamAuthorizes) {
            trExamAuthorize1.setExamId(exam.getId());
            trExamAuthorize1.setId(idGenerator.generate());
            trExamAuthorize1.setCreateById(accountId);
            trExamAuthorize1.setCreateByName(accountName);
            trExamAuthorize1.setCreateTime(time);
            trExamAuthorize1.setUpdateById(accountId);
            trExamAuthorize1.setUpdateByName(accountName);
            trExamAuthorize1.setUpdateTime(time);
            trExamAuthorizes1.add(trExamAuthorize1);
        }
        boolean examAuthorizeResult = true;
        if (trExamAuthorizes1.size() > 0) {
            examAuthorizeResult = trExamAuthorizeService.insertAll(trExamAuthorizes1);
        }
        //复制提醒设置
//		TrExamRemind trExamRemind = trExamRemindMapper.selectById()
        //复制考试积分
        TrExamPoint trExamPoint = new TrExamPoint();
        trExamPoint.setExamId(examVo.getId());
        trExamPoint.setState(1);
        com.yizhi.application.domain.TrExamPoint domainExamPoint = new com.yizhi.application.domain.TrExamPoint();
        BeanUtils.copyProperties(trExamPoint,domainExamPoint);
        EntityWrapper<com.yizhi.application.domain.TrExamPoint> trExamPointEntityWrapper = new EntityWrapper<>(domainExamPoint);
        List<com.yizhi.application.domain.TrExamPoint> trExamPoints = trExamPointMapper.selectList(trExamPointEntityWrapper);
        List<com.yizhi.application.domain.TrExamPoint> trExamPoints1 = new ArrayList<>();
        for (com.yizhi.application.domain.TrExamPoint trExamPoint1 : trExamPoints) {
            trExamPoint1.setExamId(exam.getId());
            trExamPoint1.setId(idGenerator.generate());
            trExamPoint1.setCreateById(accountId);
            trExamPoint1.setCreateByName(accountName);
            trExamPoint1.setCreateByName(accountName);
            trExamPoint1.setCreateTime(time);
            trExamPoint1.setUpdateById(accountId);
            trExamPoint1.setUpdateByName(accountName);
            trExamPoint1.setUpdateTime(time);
            trExamPoints1.add(trExamPoint1);
        }
        boolean examPointResult = true;
        if (trExamPoints1.size() > 0) {
            examPointResult = trExamPointService.insertAll(trExamPoints1);
        }
        if (insertExam && insertExamQuestion && examQuestionSortResult && examSystemQuestionResult && examScoreEvaluateResult && examAuthorizeResult) {
            return true;
        } else {
            return false;
        }
    }

    public Exam getExam(Long examId) {
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        exam.setId(examId);
        EntityWrapper<com.yizhi.application.domain.Exam> wrapper = new EntityWrapper<com.yizhi.application.domain.Exam>(exam);
        com.yizhi.application.domain.Exam examEntity = this.selectOne(wrapper);
        Exam examVo = new Exam();
        BeanUtils.copyProperties(examEntity,examVo);
        return  examVo;
    }

    /**
     * 获取最大考试编码， 然后+1
     *
     * @return
     */
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public String queryMaxExamNo() {
        String examNo = examMapper.queryMaxExamNo();
        if (StringUtils.isBlank(examNo) || !examNo.startsWith("KS") || (examNo.length() < 8)) {
            return ExamConstant.EXAM_NO;
        }
        int length = examNo.length();
        String start = examNo.substring(0, 2);
        String end = String.valueOf(Long.valueOf(examNo.substring(3)) + 1);
        int zeroLength = length - start.length() - end.length();
        StringBuffer sb = new StringBuffer();
        sb.append(start);
        for (int i = 0; i < zeroLength; i++) {
            sb.append(0);
        }
        sb.append(end);
        return sb.toString();
    }

    public void setBaseInfo(BaseInfoVO vo, com.yizhi.application.domain.Exam e) {
        e.setName(vo.getName());
        e.setStartTime(DateUtil.parse(vo.getStartTime()));
        e.setEndTime(DateUtil.parse(vo.getEndTime()));
        e.setDuration(vo.getDuration());
        e.setAnswerNum(vo.getAnswerNum());
        e.setExamNum(vo.getExamNum());
        e.setQualifiedScore(vo.getQualifiedScore());
        e.setDescription(vo.getDescription());
        e.setMakeStrategy(vo.getMakeStrategy());
        e.setOldExamNo(vo.getOldExamNo());
        e.setState(ExamConstant.FIRST);
        e.setTrainingProjectId(vo.getTrainingProjectId());
        e.setImage(vo.getImage());
        e.setKeywords(vo.getKeywords());
    }

    /**
     * boo 是否修改 新增 true 修改 false
     *
     * @param exam
     */
    private void setInsertExamCloumn(com.yizhi.application.domain.Exam exam, Long accountId, String accountName, boolean boo) {
        Date date = new Date();
        if (boo) {
            exam.setCreateById(accountId);
            exam.setCreateByName(accountName);
            exam.setCreateTime(date);
            exam.setUpdateById(accountId);
            exam.setUpdateByName(accountName);
            exam.setUpdateTime(date);
        } else {
            exam.setUpdateById(accountId);
            exam.setUpdateByName(accountName);
            exam.setUpdateTime(date);
        }
    }

    /**
     * 根据主键查询
     */
    public Exam getExamByExamId(Long examId) {
        // TODO Auto-generated method stub
        System.out.println(examId);
        com.yizhi.application.domain.Exam examEntity = this.selectById(examId);
        Exam examVo = new Exam();
        BeanUtils.copyProperties(examEntity,examVo);
        return examVo;
    }


    @Override
    public Boolean importExamFile(String fileDir, String fileName, Long id) {
		/*ExcelImporter excelImporter = (ExcelImporter) ExcelImporter.build(fileDir, "C:\\file\\dir", fileName, properties, this);
   		this.setExamId(id);
		excelImporter.handle();*/
        return true;
    }

    @Override
    public ExamDetailsVO examDetail(Long examId, Long accountId) {
        SumQuestionVO sumQuestionVO;
        SumQuestionVO sumQuestionVO1;
        ExamDetailsVO examDetailsVO = new ExamDetailsVO();

        try {
            com.yizhi.application.domain.Exam exam = examMapper.selectById(examId);
            BeanUtils.copyProperties(exam, examDetailsVO);
            if (examDetailsVO.getScore() == null) {
                examDetailsVO.setScore(new BigDecimal(0));
            }
            if (examDetailsVO.getQualifiedScore() == null) {
                examDetailsVO.setQualifiedScore(0);
            }
            if (examDetailsVO.getAnswerNum() == null) {
                examDetailsVO.setAnswerNum(0);
            }
            if (examDetailsVO.getDuration() == null) {
                examDetailsVO.setDuration(0);
            }
            if (examDetailsVO.getPageMode() == null) {
                examDetailsVO.setPageMode(1);
            }

            //根据出题策略，调用不同方法获取考试的总分和答题数量
            if (exam.getMakeStrategy() == 1) {
                sumQuestionVO = trExamQuestionMapper.selectCountAndScore(examId);
                examDetailsVO.setSumQuestion(sumQuestionVO.getNum());
                examDetailsVO.setScore(sumQuestionVO.getScore());
            } else if (exam.getMakeStrategy() == 2) {
                sumQuestionVO = trExamQuestionMapper.selectCountAndScore(examId);
                com.yizhi.application.domain.TrExamSystemQuestion trExamSystemQuestion = new com.yizhi.application.domain.TrExamSystemQuestion();
                trExamSystemQuestion.setExamId(examId);
                trExamSystemQuestion.setState(1);
                EntityWrapper<com.yizhi.application.domain.TrExamSystemQuestion> entityWrapper = new EntityWrapper<>(trExamSystemQuestion);
                List<com.yizhi.application.domain.TrExamSystemQuestion> systemQuestions = trExamSystemQuestionMapper.selectList(entityWrapper);
                if (!CollectionUtils.isEmpty(systemQuestions)) {
                    Integer sumNum = 0;
                    BigDecimal sumScore = BigDecimal.valueOf(0);
                    for (com.yizhi.application.domain.TrExamSystemQuestion trExamSystemQuestion1 : systemQuestions) {
                        if (trExamSystemQuestion1.getNum() != null) {
                            sumNum += trExamSystemQuestion1.getNum();
                        }
                        if (trExamSystemQuestion1.getScore() != null) {
                            sumScore = sumScore.add(trExamSystemQuestion1.getScore().
                                    multiply(BigDecimal.valueOf(trExamSystemQuestion1.getNum())));
                        }
                    }
                    examDetailsVO.setSumQuestion(sumQuestionVO.getNum() + sumNum);
                    BigDecimal add = null;
                    if (sumQuestionVO.getScore() == null) {
                        sumQuestionVO.setScore(BigDecimal.valueOf(0));
                    }
                    add = sumQuestionVO.getScore().add(sumScore);
                    add = add.setScale(1, BigDecimal.ROUND_HALF_UP);
                    examDetailsVO.setScore(add);
                } else {
                    examDetailsVO.setSumQuestion(sumQuestionVO.getNum());
                    sumQuestionVO.setScore(sumQuestionVO.getScore().setScale(1, BigDecimal.ROUND_HALF_UP));
                    examDetailsVO.setScore(sumQuestionVO.getScore());
                }
            }
            //获取已参加的考试次数
            //List<Long> allAnswerIds = trExamAnswerMapper.getAllAnswerDetailListInfo(accountId,examId);

            //获取已参加的考试次数(提交和已完成的)
            List<Long> answerIds = trExamAnswerMapper.getAnswerDetailListInfo(accountId, examId);
            Integer examNum = 0;
            Integer isEndExam = 1;
            if (answerIds != null) {
                examNum = answerIds.size();
                Integer answerNum = exam.getAnswerNum();
                if (answerNum == null) {
                    answerNum = 0;
                }
                if (answerNum != 0) {
                    if (examNum >= answerNum) {
                        isEndExam = 0;
                    }
                }
            }
            examDetailsVO.setIsEndExam(isEndExam);
            examDetailsVO.setExamNum(examNum);

            //如果没有考试次数了,删除所有未提交的考卷信息
            if (isEndExam == 0) {
                com.yizhi.application.domain.TrExamAnswer trExamAnswer1 = new com.yizhi.application.domain.TrExamAnswer();
                trExamAnswer1.setExamId(examId);
                trExamAnswer1.setAccountId(accountId);
                trExamAnswer1.setState(0);
                // 考试提交没有考试次数了,删除此次考卷信息并清空考试缓存信息
                try {
                    iStudentExamPaperService.clearStudentExam(accountId, examId);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                EntityWrapper<com.yizhi.application.domain.TrExamAnswer> wrapper = new EntityWrapper<>(trExamAnswer1);
                iTrExamAnswerService.delete(wrapper);
            }
            //查找最后一次答卷（未交卷的）
            com.yizhi.application.domain.TrExamAnswer trExamAnswer = iTrExamAnswerService.selectLastAnswer(examId, accountId);
            if (null != trExamAnswer && null != trExamAnswer.getId()) {
                examDetailsVO.setAnswerId(trExamAnswer.getId());
            }
            if (null == trExamAnswer) {
                examDetailsVO.setIsExam(0);
                examDetailsVO.setAnswerId(0L);
            } else if (trExamAnswer.getState() == 0) {
                examDetailsVO.setIsExam(1);
                examDetailsVO.setAnswerId(trExamAnswer.getId());
            } else if (trExamAnswer.getState() == 1 || trExamAnswer.getState() == 2) {
                examDetailsVO.setIsExam(0);
                examDetailsVO.setAnswerId(0L);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return examDetailsVO;
        }

        return examDetailsVO;
    }

	/*@Override
	public Boolean exec(TaskContext ctx, List object) {
		@SuppressWarnings("unchecked")
		List<Map<String, String>> list = (List<Map<String, String>>) object;
		List<ExamImportVO> listExam = JsonUtil.json2List( JsonUtil.object2Json(list), ExamImportVO.class);
		try {
			insertDb(listExam);
		} catch (Exception e) {
			logger.error("导入考试试题解析exel保存数据失败", e);
			return false;
		}
		return true;
	}*/

    public void insertDb(List<ExamImportVO> listExam) throws Exception {
        com.yizhi.application.domain.TrExamQuestion trExamQuestion = null;
        com.yizhi.application.domain.TrQuestionLibrarySubject trQuestionLibrarySubject = null;
        for (ExamImportVO que : listExam) {
            trExamQuestion = new com.yizhi.application.domain.TrExamQuestion();
            trQuestionLibrarySubject = new com.yizhi.application.domain.TrQuestionLibrarySubject();
            if ("单选题".equals(que.getTypeValue())) {
                que.setType(1);
            }
            if ("多选题".equals(que.getTypeValue())) {
                que.setType(2);
            }
            if ("判断题".equals(que.getTypeValue())) {
                que.setType(3);
            }
            if ("问答题".equals(que.getTypeValue())) {
                que.setType(4);
            }

            trQuestionLibrarySubject.setStem(que.getStem());
            if (StringUtils.isEmpty(trQuestionLibrarySubject.getStem())) {
                //throw  new BizException(ReturnCode.STEM_FAIL);
            }
            trQuestionLibrarySubject = trQuestionLibrarySubjectMapper.selectOne(trQuestionLibrarySubject);
            if (trQuestionLibrarySubject != null) {
                trQuestionLibrarySubject.setCreateByName("develop");
                trQuestionLibrarySubject.setUpdateById(0L);
                trQuestionLibrarySubject.setUpdateByName("develop");
                trQuestionLibrarySubjectMapper.updateById(trQuestionLibrarySubject);
                continue;
            }
            trQuestionLibrarySubject = new com.yizhi.application.domain.TrQuestionLibrarySubject();
            BeanUtils.copyProperties(que, trQuestionLibrarySubject);
            trQuestionLibrarySubject.setId(idGenerator.generate());
            trQuestionLibrarySubject.setLibraryId(null);
            trQuestionLibrarySubject.setOrgId(0L);
            trQuestionLibrarySubject.setSiteId(0L);
            trQuestionLibrarySubject.setScoreRule(que.getIsAnswer());
            trQuestionLibrarySubject.setCompanyId(0L);
            trQuestionLibrarySubject.setCreateById(0L);
            trQuestionLibrarySubject.setCreateByName("develop");
            trQuestionLibrarySubject.setUpdateById(0L);
            trQuestionLibrarySubject.setUpdateByName("develop");
            trQuestionLibrarySubjectMapper.insert(trQuestionLibrarySubject);


            //回写添加考试题目表
            trExamQuestion.setId(idGenerator.generate());
            trExamQuestion.setExamId(this.examId);
            trExamQuestion.setSubjectId(trQuestionLibrarySubject.getId());
            trExamQuestion.setCreateById(0L);
            trExamQuestion.setCreateByName("develop");
            trExamQuestion.setUpdateById(0L);
            trExamQuestion.setUpdateByName("develop");
            trExamQuestionMapper.updateById(trExamQuestion);

            if (StringUtils.isNotEmpty(que.getContent1())) {
                com.yizhi.application.domain.TrQuestionSubjectOption trQuestionSubjectOption1 = new com.yizhi.application.domain.TrQuestionSubjectOption();
                trQuestionSubjectOption1.setSubjectId(trQuestionLibrarySubject.getId());
                if (que.getIsAnswer().contains("A") || "A".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption1.setIsAnswer(1);

                }
                if ("对".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption1.setIsAnswer(1);

                }
                trQuestionSubjectOption1.setId(idGenerator.generate());
                trQuestionSubjectOption1.setContent(que.getContent1());
                trQuestionSubjectOption1.setCreateById(0L);
                trQuestionSubjectOption1.setCreateByName("develop");
                trQuestionSubjectOption1.setUpdateById(0L);
                trQuestionSubjectOption1.setUpdateByName("develop");
                trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption1);
            }
            if (StringUtils.isNotEmpty(que.getContent2())) {
                com.yizhi.application.domain.TrQuestionSubjectOption trQuestionSubjectOption2 = new com.yizhi.application.domain.TrQuestionSubjectOption();
                if (que.getIsAnswer().contains("B") || "B".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption2.setIsAnswer(1);

                }
                if ("错".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption2.setIsAnswer(1);

                }
                trQuestionSubjectOption2.setSubjectId(trQuestionLibrarySubject.getId());
                trQuestionSubjectOption2.setId(idGenerator.generate());
                trQuestionSubjectOption2.setContent(que.getContent2());
                trQuestionSubjectOption2.setCreateById(0L);
                trQuestionSubjectOption2.setCreateByName("develop");
                trQuestionSubjectOption2.setUpdateById(0L);
                trQuestionSubjectOption2.setUpdateByName("develop");
                trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption2);
            }
            if (StringUtils.isNotEmpty(que.getContent3())) {
                com.yizhi.application.domain.TrQuestionSubjectOption trQuestionSubjectOption3 = new com.yizhi.application.domain.TrQuestionSubjectOption();
                if (que.getIsAnswer().contains("C") || "C".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption3.setIsAnswer(1);

                }
                trQuestionSubjectOption3.setSubjectId(trQuestionLibrarySubject.getId());
                trQuestionSubjectOption3.setId(idGenerator.generate());
                trQuestionSubjectOption3.setContent(que.getContent3());
                trQuestionSubjectOption3.setCreateById(0L);
                trQuestionSubjectOption3.setCreateByName("develop");
                trQuestionSubjectOption3.setUpdateById(0L);
                trQuestionSubjectOption3.setUpdateByName("develop");
                trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption3);
            }
            if (StringUtils.isNotEmpty(que.getContent4())) {
                com.yizhi.application.domain.TrQuestionSubjectOption trQuestionSubjectOption4 = new com.yizhi.application.domain.TrQuestionSubjectOption();
                if (que.getIsAnswer().contains("D") || "D".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption4.setIsAnswer(1);

                }
                trQuestionSubjectOption4.setSubjectId(trQuestionLibrarySubject.getId());
                trQuestionSubjectOption4.setId(idGenerator.generate());
                trQuestionSubjectOption4.setContent(que.getContent4());
                trQuestionSubjectOption4.setCreateById(0L);
                trQuestionSubjectOption4.setCreateByName("develop");
                trQuestionSubjectOption4.setUpdateById(0L);
                trQuestionSubjectOption4.setUpdateByName("develop");
                trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption4);
            }
        }

    }

    @Override
    public Integer selectTotal(MyExamParameterVO myExamParameterVO) {
        return examMapper.selectTotalInfo(myExamParameterVO.getIds(), myExamParameterVO.getState(), myExamParameterVO.getAccountId(), myExamParameterVO.getSiteId());
    }

    @Override
    public List<MyExamVO> selectMyExamnation(Integer pageNo, Integer pageSize, Long accountId) {
        Integer start = (pageNo - 1) * pageSize;
        Integer end = pageNo * pageSize;
        return examMapper.selectMyExamnation(start, end, accountId);
    }

    @Override
    public Integer selectAll(Long accountId) {
        return examMapper.selectAll(accountId);
    }


    public Long getExamId() {
        return examId;
    }

    public void setExamId(Long examId) {
        this.examId = examId;
    }

    @Override
    public List<Exam> selectExamList(String name, Long companyId) {
        List<com.yizhi.application.domain.Exam> idList = examMapper.selectExamList(companyId, name);
        List<Exam> examList = new ArrayList<>();
        if (null != idList && idList.size() > 0){
            idList.forEach(exam -> {
                Exam examVo = new Exam();
                BeanUtils.copyProperties(exam,examVo);
                examList.add(examVo);
            });
        }
        return examList;
    }

    @Override
    public Integer selectCountByAccountId(Long accountId) {
        return examMapper.selectCountByAccountId(accountId);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public boolean updateQuestionSort(QuestionSortVO questionSortVO) {
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        Date time = new Date();
        exam.setId(questionSortVO.getExamId());
        exam.setStemSort(questionSortVO.getStemSort());
        exam.setOptionSort(questionSortVO.getOptionSort());
        exam.setTypeSort(questionSortVO.getTypeSort());
        exam.setUpdateById(questionSortVO.getAccountId());
        exam.setUpdateByName(questionSortVO.getAccountName());
        exam.setUpdateTime(time);
        if (questionSortVO.getType() == 1) {
            exam.setSysMakeStrategy(questionSortVO.getSysMakeStrategy());
        }
        boolean result = this.updateById(exam);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("exam_id", questionSortVO.getExamId());
        trExamQuestionSortMapper.deleteByMap(map);
        if (result == true && questionSortVO.getTypeSort() == 2) {
            List<com.yizhi.application.domain.TrExamQuestionSort> list = new ArrayList<>();
            List<TrExamQuestionSort> questionSortList = questionSortVO.getTrExamQuestionSorts();
            questionSortList.forEach(trExamQuestionSort -> {
                com.yizhi.application.domain.TrExamQuestionSort questionSort = new com.yizhi.application.domain.TrExamQuestionSort();
                BeanUtils.copyProperties(trExamQuestionSort,questionSort);
                list.add(questionSort);
            });
            for (com.yizhi.application.domain.TrExamQuestionSort trExamQuestionSort : list) {
                trExamQuestionSort.setId(idGenerator.generate());
                trExamQuestionSort.setCreateById(questionSortVO.getAccountId());
                trExamQuestionSort.setCreateByName(questionSortVO.getAccountName());
                trExamQuestionSort.setUpdateById(questionSortVO.getAccountId());
                trExamQuestionSort.setUpdateByName(questionSortVO.getAccountName());
                trExamQuestionSort.setUpdateTime(time);
                trExamQuestionSort.setCreateTime(time);
                int count = trExamQuestionSortMapper.insert(trExamQuestionSort);
                if (count < 1) {
                    result = false;
                }
            }
        }
        return result;
    }

    @Override
    public ExamView selectExam(Long id) {
        ExamView examView = new ExamView();
        com.yizhi.application.domain.Exam exam = this.selectById(id);
        if (null != exam) {
            BeanUtils.copyProperties(exam, examView);
            if (null != examView.getTypeSort()) {
                if (examView.getTypeSort() == 2) {
                    List<TrExamQuestionSortVO> trExamQuestionSortVOs = iTrExamQuestionSortService.listTrExamQuestionSort(id);
                    examView.setTrExamQuestionSortVOS(trExamQuestionSortVOs);
                }
            }
            List<TrExamScoreEvaluateVO> trExamScoreEvaluateVOS = iTrExamScoreEvaluateService.listTrExamScoreEvaluate(id);
            examView.setTrExamScoreEvaluateVOS(trExamScoreEvaluateVOS);
            List<TrExamPointVO> trExamPointVOS = trExamPointService.listTrExamPoint(id);
            examView.setTrExamPointVOS(trExamPointVOS);
        }
        return examView;
    }

    @Override
    public Page<Exam> selectExamLikeName(String keyWord, Integer pageNo, Integer pageSize, Long accountId, Long companyId, Long siteId,
                                         Long orgId) {
        Page<com.yizhi.application.domain.Exam> page = new Page<>(pageNo, pageSize);
        List<com.yizhi.application.domain.Exam> listExam = examMapper.selectExamLikeName(page, keyWord, accountId, companyId, siteId, orgId);
        page.setRecords(listExam);
        Page<Exam> pageVo = new Page<>();
        List<Exam> list = new ArrayList<>();
        BeanUtils.copyProperties(page,pageVo);
        if (null != listExam && listExam.size() > 0){
            listExam.forEach(exam -> {
                Exam examVo = new Exam();
                BeanUtils.copyProperties(exam,examVo);
                list.add(examVo);
            });
        }
        pageVo.setRecords(list);

        return pageVo;
    }

    @Override
    public List<TrExamPoint> selectExamPointInfo(Long examId, Long companyId, Long siteId, Long orgId) {
        List<com.yizhi.application.domain.TrExamPoint> trExamPoints = examMapper.selectExamPointInfo(examId, companyId, siteId, null);
        List<TrExamPoint> list = new ArrayList<>();
        if (null != trExamPoints && trExamPoints.size() > 0){
            trExamPoints.forEach(trExamPoint -> {

                TrExamPoint trExamPointVO = new TrExamPoint();
                BeanUtils.copyProperties(trExamPoint,trExamPointVO);
                list.add(trExamPointVO);
            });
        }
        return list;
    }

    @Override
    public List<Exam> selectExamListByName(ContextAndPageSizeVO contextAndPageSizeVO) {
        Integer start = (contextAndPageSizeVO.getPageNo() - 1) * contextAndPageSizeVO.getPageSize();
        contextAndPageSizeVO.setPageNo(start);
        //PageHelper.startPage((pageNo==null || pageNo<1)?1:pageNo, pageSize);
//		Page<Exam> page = new Page<Exam>((contextAndPageSizeVO.getPageNo()==null || contextAndPageSizeVO.getPageNo()<1)?1:contextAndPageSizeVO.getPageNo(), contextAndPageSizeVO.getPageSize());
        HQueryUtil.startHQ(Exam.class);
        List<com.yizhi.application.domain.Exam> examList = examMapper.selectExamListByName(contextAndPageSizeVO);

        List<Exam> list = new ArrayList<>();
        if (null != examList && examList.size() > 0){
            examList.forEach(texam -> {

                Exam examVO = new Exam();
                BeanUtils.copyProperties(texam,examVO);
                list.add(examVO);
            });
        }
        return list;
    }

    @Override
    public ExamDetailsMarkingVO selectExamListBySta(ContextAndPageSizeVO contextAndPageSizeVO) {
        ExamDetailsMarkingVO examDetailsMarkingVO  = new ExamDetailsMarkingVO();
        examDetailsMarkingVO.setCommitExamNum(examMapper.selectCommitTotalCnt(contextAndPageSizeVO));
        examDetailsMarkingVO.setQualifidNum(examMapper.selectCommitPassCnt(contextAndPageSizeVO));
        examDetailsMarkingVO.setQualifiedNumFrist(examMapper.selectCommitOncePassCnt(contextAndPageSizeVO));
        return examDetailsMarkingVO;
    }

    @Override
    public int selectExamListByNameCount(ContextAndPageSizeVO contextAndPageSizeVO) {
        HQueryUtil.startHQ(Exam.class);
        return examMapper.selectExamListByNameCount(contextAndPageSizeVO);
    }

    @Override
    public boolean nameIsExist(String name) {
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        exam.setName(name);
        EntityWrapper<com.yizhi.application.domain.Exam> wrapper = new EntityWrapper<com.yizhi.application.domain.Exam>(exam);
        com.yizhi.application.domain.Exam obj = this.selectOne(wrapper);
        if (obj == null) {
            return false;
        } else {
            return true;
        }
    }

    @Override
    public List<Exam> selectExamByContext(Long companyId, Long orgId, Long siteId, String name) {
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        exam.setCompanyId(companyId);
        exam.setSiteId(siteId);
        exam.setState(2);
        if (!StringUtils.isBlank(name)) {
            exam.setName(name);
        }

        EntityWrapper<com.yizhi.application.domain.Exam> wrapper = new EntityWrapper<com.yizhi.application.domain.Exam>(exam);
        List<Exam> list = new ArrayList<>();
        List<com.yizhi.application.domain.Exam> exams = this.selectList(wrapper);
        if (null != exams && exams.size() > 0){
            exams.forEach(examEntity -> {

                Exam examVo = new Exam();
                BeanUtils.copyProperties(examEntity,examVo);
                list.add(examVo);
            });
        }
        return list;
    }

    @Override
    public List<Exam> selectExamListByNameExport(String name, Long companyId) {
        List<com.yizhi.application.domain.Exam> exams = examMapper.selectExamListByNameExport(name, companyId);
        List<Exam> list = new ArrayList<>();
        if (null != exams && exams.size() > 0){
            exams.forEach(examEntity -> {

                Exam examVo = new Exam();
                BeanUtils.copyProperties(examEntity,examVo);
                list.add(examVo);
            });
        }
        return list;
    }


    @Override
    public Page<StatisticalByUserVO> examByUser(ExamCountByUserVO vo) {
        Page<StatisticalByUserVO> page = new Page<StatisticalByUserVO>(vo.getPageNo(), vo.getPageSize());
        HQueryUtil.startHQ(TrExamAnswer.class);
        List<StatisticalByUserVO> list = examMapper.examByUser(page, vo);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<Exam> selectExamByName(ExamCountExportParamVO vo) {
        List<com.yizhi.application.domain.Exam> exams = examMapper.selectExamByName(vo);
        List<Exam> list = new ArrayList<>();
        if (null != exams && exams.size() > 0){
            exams.forEach(examEntity -> {

                Exam examVo = new Exam();
                BeanUtils.copyProperties(examEntity,examVo);
                list.add(examVo);
            });
        }
        return list;
    }


    @Override
    public List<StatisticalByUserVO> examAnswerByExamId(ExamCountByUserVO ecvo) {
        return examMapper.examByUser(ecvo);
    }


    @Override
    public Integer selectMyExamNoSubmit(Long accountId) {
        return examMapper.selectMyExamNoSubmit(accountId);
    }


    @Override
    public Exam getExamByProjectId(Long projectId) {
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        exam.setTrainingProjectId(projectId);
        EntityWrapper<com.yizhi.application.domain.Exam> wrapper = new EntityWrapper<com.yizhi.application.domain.Exam>(exam);
        com.yizhi.application.domain.Exam exam1 = this.selectOne(wrapper);
        Exam examVO = new Exam();
        BeanUtils.copyProperties(exam1,examVO);
        return examVO;
    }


    @Override
    public List<Long> getMyVisableExam(List<Long> ids, Long siteId) {
        logger.info("IDS：" + ids);
        //查询制定学员 可见考试ID
        List<Long> examIds = trExamAuthorizeMapper.selectAuthorizeByRelationId(ids, siteId);
		/*if(examIds != null){
			logger.info("可见考试examIdsID：" + examIds.toString());
		}*/

        //查询全平台可见考试ID
        List<Long> examIds1 = examMapper.selectExamIdByVisable(siteId);
        if (examIds1 != null) {
            //logger.info("查询全平台可见考试ID：" + examIds1.toString());
            if (examIds == null) {
                examIds = examIds1;
            } else {
                examIds.addAll(examIds1);
            }
        }

        if (examIds == null || examIds.isEmpty()) {
            examIds = null;
            logger.info("没有搜索到考试");
        } else {
            logger.info("搜索到考试{}个" + examIds.size());
        }

        return examIds;
    }


    @Override
    public Page<MyExamVO> searchMyExamInfo(int pageNo, int pageSize, List<Long> ids,
                                           Long accountId, Long siteId, String keyWord) {
        Page<MyExamVO> page = new Page<MyExamVO>(pageNo, pageSize);
        List<Long> examIds = getMyVisableExam(ids, siteId);
        List<MyExamVO> myExams = examMapper.searchMyExamInfo(page, examIds, accountId, keyWord);
        page.setRecords(myExams);

        return page;
    }

    @Override
    public String checkScore(Long examId) {
        //1.查询考试的合格分
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        exam.setId(examId);
        EntityWrapper<com.yizhi.application.domain.Exam> wrapper = new EntityWrapper<com.yizhi.application.domain.Exam>(exam);
        exam = this.selectOne(wrapper);

        com.yizhi.application.domain.TrExamQuestion examQuestion = new com.yizhi.application.domain.TrExamQuestion();
        examQuestion.setExamId(examId);
        examQuestion.setState(1);
        EntityWrapper<com.yizhi.application.domain.TrExamQuestion> entityWrapper = new EntityWrapper<com.yizhi.application.domain.TrExamQuestion>(examQuestion);
        List<com.yizhi.application.domain.TrExamQuestion> list = trExamQuestionMapper.selectList(entityWrapper);
        Integer makeStrategy = exam.getMakeStrategy();
        if (makeStrategy == 1 || makeStrategy == 2 && list.size() > 0) {
            if (makeStrategy == 1 && list.size() == 0) {
                return "请添加考试题目";
            }

            //2.根据考试id查询出题目
            for (com.yizhi.application.domain.TrExamQuestion question : list) {
                if (question.getScore() == null || question.getScore().compareTo(BigDecimal.ZERO) == 0) {
                    return "本场考试存在没有设置分数的题目";
                }
            }
        }

        Integer score = exam.getQualifiedScore();
        if (score == null) {
            return "本场考试没有设置合格分";
        }

        //3.查询考试名称，考试时间，答卷时常，答卷次数，出题策略
        String examName = exam.getName();
        if (examName == null || examName.trim().equals("")) {
            return "请输入正确的考试名称";
        }
        Integer duration = exam.getDuration();
        if (duration == null) {
            return "请输入答卷时长";
        }
        Integer answerNum = exam.getAnswerNum();
        if (answerNum == null) {
            return "请输入答卷次数";
        }
        if (makeStrategy == null) {
            return "请输入出题策略";
        }
        Integer steam = exam.getStemSort();
        if (steam == null) {
            return "请设置题干排序";
        }
        Integer optionSort = exam.getOptionSort();
        if (optionSort == null) {
            return "请设置选项排序";
        }
        Integer range = exam.getVisibleRange();
        if (range == null) {
            return "请设置考试范围";
        }
        if (range == 2) {
            com.yizhi.application.domain.TrExamAuthorize trExamAuthorize = new com.yizhi.application.domain.TrExamAuthorize();
            trExamAuthorize.setExamId(examId);
            EntityWrapper<com.yizhi.application.domain.TrExamAuthorize> wrapper2 = new EntityWrapper<com.yizhi.application.domain.TrExamAuthorize>(trExamAuthorize);
            List<com.yizhi.application.domain.TrExamAuthorize> trExamAuthorizes = trExamAuthorizeMapper.selectList(wrapper2);
            if (trExamAuthorizes.size() == 0) {
                return "请设置关联人员";
            }
        }
        Integer pageMode = exam.getPageMode();
        if (pageMode == null) {
            return "请设置呈现样式";
        }
        Integer isPoint = exam.getIsPoint();
        if (isPoint == null) {
            return "请设置是否有积分";
        }
        if (isPoint == 1) {
            com.yizhi.application.domain.TrExamPoint trExamPoint = new com.yizhi.application.domain.TrExamPoint();
            trExamPoint.setExamId(examId);
            EntityWrapper<com.yizhi.application.domain.TrExamPoint> wrapper2 = new EntityWrapper<com.yizhi.application.domain.TrExamPoint>(trExamPoint);
            List<com.yizhi.application.domain.TrExamPoint> trExamPoints = trExamPointMapper.selectList(wrapper2);
            if (trExamPoints.size() == 0) {
                return "请设置积分范围";
            }
        }
        Integer remind = exam.getRemind();
//        if (remind == null) {
//            return "请设置是否有提醒";
//        }
//        if (remind == 1) {
//            TrExamRemind trExamRemind = new TrExamRemind();
//            trExamRemind.setExamId(examId);
//            EntityWrapper<TrExamRemind> wrapper2 = new EntityWrapper<TrExamRemind>(trExamRemind);
//            List<TrExamRemind> trExamReminds = trExamRemindMapper.selectList(wrapper2);
//            if (trExamReminds.size() == 0) {
//                return "请设置提醒";
//            }
//        }

        //4.
        return "ok";
    }

    /**
     * 添加考试到缓存中
     *
     * @param e
     * @param time
     */
    private void createExamCache(com.yizhi.application.domain.Exam e, Date time) {
        try {
            executor.execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        Date curDate = time;
                        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        curDate = formatDate.parse(formatDate.format(curDate));
                        Date endDate = e.getEndTime();
                        if (endDate == null) {
                            endDate = curDate;
                        }
                        endDate = formatDate.parse(formatDate.format(endDate));
                        //考试剩余时间
                        long examCachRestTime = (endDate.getTime() - curDate.getTime()) / 1000;
                        //考试时间已结束
                        if (examCachRestTime < 0) {
                            logger.info("考试{}的时间失效缓存失败", e.getId());
                        }
                        //查询考试信息
                        ExamPaperVO examPaperVO = iStudentExamPaperService.makeExamQuestion(e.getId(), e.getCompanyId(),
                                e.getOrgId(), e.getSiteId(), examCachRestTime);
                        //如果缓存考试没题目,则清除缓存
                        if (CollectionUtils.isEmpty(examPaperVO.getQuestions())) {
                            iStudentExamPaperService.clearExam(e.getId());
                        }
                        if (examPaperVO != null) {
                            logger.info("添加考试{}缓存成功", e.getId());
                        } else {
                            logger.info("添加考试{}缓存失败", e.getId());
                        }
                    } catch (Exception e2) {
                        logger.error("添加考试{}缓存失败", e.getId());
                        e2.printStackTrace();
                    }
                }
            });
        } catch (Exception e1) {
            logger.error("启动考试{}缓存线程失败", e.getId());
            e1.printStackTrace();
        }
    }


    @Override
    public VisibleRangeExport vsibleRangeExport(Long examId) {
        // TODO Auto-generated method stub
        VisibleRangeExport visibleRangeExport = new VisibleRangeExport();
        List<Long> accountIds = new ArrayList<Long>();
        List<Long> orgIds = new ArrayList<Long>();

        com.yizhi.application.domain.Exam exam = examMapper.selectById(examId);
        if (exam != null) {
            visibleRangeExport.setBizId(exam.getId());
            visibleRangeExport.setBizName(exam.getName());
        }
        List<TrExamAuthorizeVO> listStudent = trExamAuthorizeService.listTrExamAuthorize(examId);
        if (listStudent != null && listStudent.size() > 0) {
            TrExamAuthorizeVO trExamAuthorizeVO = null;
            for (int i = 0; i < listStudent.size(); i++) {
                trExamAuthorizeVO = listStudent.get(i);
                if (trExamAuthorizeVO != null && trExamAuthorizeVO.getType() != null) {
                    if (trExamAuthorizeVO.getType() == 2) {
                        accountIds.add(trExamAuthorizeVO.getRelationId());
                    }
                    if (trExamAuthorizeVO.getType() == 1) {
                        orgIds.add(trExamAuthorizeVO.getRelationId());
                    }
                }
                visibleRangeExport.setAccountIds(accountIds);
                visibleRangeExport.setOrgIds(orgIds);
            }
        }
        return visibleRangeExport;
    }

    @Override
    public Page<Map<String, Object>> getPoolExamList(String name, List<Long> ids, Integer pageNo, Integer pageSize) {
        Page<Map<String, Object>> page = new Page<>(pageNo, pageSize);
        RequestContext res = ContextHolder.get();
        List<Long> orgIds = null;
        if (!res.isAdmin() && !CollectionUtils.isEmpty(res.getOrgIds())) {
            orgIds = res.getOrgIds();
        }
        Long companyId = res.getCompanyId();
        Long siteId = res.getSiteId();
        String name1 = null;
        if (StringUtils.isNotEmpty(name)) {
            name1 = name.trim();
        }
        HQueryUtil.startHQ(Exam.class);
        List<Map<String, Object>> list = examMapper.getPoolExamList(name1, ids, companyId, siteId, orgIds, page);
        if (!CollectionUtils.isEmpty(list)) {
            page.setRecords(list);
        }
        return page;
    }


    @Override
    public List<Map<String, Object>> getServerByCompanyIdAndIds(Long companyId, List<Long> ids) {
        // TODO Auto-generated method stub
        List<Map<String, Object>> listMap = null;
        //查询
        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        exam.setCompanyId(companyId);
        EntityWrapper<com.yizhi.application.domain.Exam> wrapper = new EntityWrapper<com.yizhi.application.domain.Exam>(exam);
        if (!CollectionUtils.isEmpty(ids)) {
            wrapper.in("id", ids);
        }
        List<com.yizhi.application.domain.Exam> listExam = this.selectList(wrapper);
        //循环组装到输出对象
        Map<String, Object> map = null;
        if (!CollectionUtils.isEmpty(listExam)) {
            listMap = new ArrayList<Map<String, Object>>();
            for (com.yizhi.application.domain.Exam c : listExam) {
                map = new HashMap<String, Object>();
                map.put("catalog", 1);
                map.put("id", c.getId());
                map.put("name", c.getName());
                map.put("logo_url", "");
                listMap.add(map);
            }
        }
        return listMap;
    }

    @Override
    public MyExamPageVO MyPcExam(MyExamParameterVO myExamParameterVO) {

        RequestContext res = ContextHolder.get();
        Long siteId = res.getSiteId();
        Long accountId = res.getAccountId();
        Integer state = myExamParameterVO.getState();
        List<Long> ids = res.getRelationIds();
        ids.add(accountId);

        MyExamPageVO myExamPageVO = new MyExamPageVO();

        //获取可见考试id列表
        List<Long> examIds = getMyVisableExam(ids, siteId);
        if (!CollectionUtils.isEmpty(ids)) {
            myExamParameterVO.setIds(examIds);
        }

        Integer pageNo = myExamParameterVO.getPageNo();
        Integer pageSize = myExamParameterVO.getPageSize();
        Page<MyExamVO> page = new Page<>(pageNo, pageSize);
        List<MyExamVO> list = examMapper.myPcExam(state, accountId, examIds, siteId, page);
        if (myExamParameterVO.getState() == 1) {
            if (!CollectionUtils.isEmpty(list)) {
                for (MyExamVO myExamVO : list) {
                    if (null == myExamVO.getState()) {
                        //未答卷,开始考试
                        myExamVO.setHandle(0);
                        myExamVO.setIsQualified("4");
                    } else if (myExamVO.getState() == 0) {
                        myExamVO.setExamNum(myExamVO.getExamNum() - 1);
                        //未交卷,继续考试
                        com.yizhi.application.domain.TrExamAnswer trExamAnswer = new com.yizhi.application.domain.TrExamAnswer();
                        trExamAnswer.setExamId(myExamVO.getId());
                        trExamAnswer.setAccountId(accountId);
                        trExamAnswer.setState(0);
                        EntityWrapper<com.yizhi.application.domain.TrExamAnswer> entityWrapper = new EntityWrapper<>(trExamAnswer);
                        List<com.yizhi.application.domain.TrExamAnswer> trExamAnswerList = trExamAnswerMapper.selectList(entityWrapper);
                        if (!CollectionUtils.isEmpty(trExamAnswerList)) {
                            myExamVO.setAnswerId(trExamAnswerList.get(0).getId());
                        }
                        if (myExamVO.getExamNum() > 0) {
                            trExamAnswer = new com.yizhi.application.domain.TrExamAnswer();
                            trExamAnswer.setAccountId(accountId);
                            trExamAnswer.setExamId(myExamVO.getId());
                            if (myExamVO.getMaxState() == 2) {
                                trExamAnswer.setState(2);
                                EntityWrapper<com.yizhi.application.domain.TrExamAnswer> entityWrapper1 = new EntityWrapper<>(trExamAnswer);
                                entityWrapper1.orderBy("score", false);
                                List<com.yizhi.application.domain.TrExamAnswer> trExamAnswerList1 = trExamAnswerMapper.selectList(entityWrapper1);
                                if (!CollectionUtils.isEmpty(trExamAnswerList1)) {
                                    if (trExamAnswerList1.get(0).getScore().compareTo(myExamVO.getQualifiedScore()) >= 0) {
                                        myExamVO.setIsQualified("1");
                                    } else {
                                        myExamVO.setIsQualified("0");
                                    }
                                    myExamVO.setHandle(2);
                                } else {
                                    myExamVO.setHandle(1);
                                    myExamVO.setIsQualified("4");
                                }
                            } else if (myExamVO.getMaxState() == 1) {
                                myExamVO.setIsQualified("2");
                                myExamVO.setHandle(2);
                            }
                        } else {
                            myExamVO.setHandle(1);
                            myExamVO.setIsQualified("4");
                        }
//                        if (null == myExamVO.getIsQualified()) {
//                            myExamVO.setIsQualified("4");
//                        }
                    } else if (myExamVO.getState() == 1) {
                        //已交卷,重新考试
                        if (myExamVO.getMaxNum() > 0) {
                            if (null != myExamVO.getExamNum() && myExamVO.getExamNum() >= myExamVO.getMaxNum()) {
                                myExamVO.setIsQualified("2");
                                myExamVO.setHandle(4);
                            } else {
                                myExamVO.setHandle(3);
                                myExamVO.setIsQualified("2");
                            }
                        } else {
                            myExamVO.setHandle(3);
                            myExamVO.setIsQualified("2");
                        }

                    } else if (myExamVO.getState() == 2) {
                        com.yizhi.application.domain.TrExamAnswer trExamAnswer = new com.yizhi.application.domain.TrExamAnswer();
                        trExamAnswer.setAccountId(accountId);
                        trExamAnswer.setExamId(myExamVO.getId());
                        trExamAnswer.setState(2);
                        EntityWrapper<com.yizhi.application.domain.TrExamAnswer> entityWrapper = new EntityWrapper<>(trExamAnswer);
                        entityWrapper.orderBy("score", false);
                        List<com.yizhi.application.domain.TrExamAnswer> trExamAnswerList = trExamAnswerMapper.selectList(entityWrapper);
                        if (!CollectionUtils.isEmpty(trExamAnswerList)) {
                            if (trExamAnswerList.get(0).getScore().compareTo(myExamVO.getQualifiedScore()) >= 0) {
                                myExamVO.setIsQualified("1");
                            } else {
                                myExamVO.setIsQualified("0");
                            }
                        } else {
                            myExamVO.setIsQualified("0");
                        }
                        myExamVO.setHandle(3);
                    }
                }
            }
        }
        myExamPageVO.setPageTotal(page.getTotal());

        Integer notStartCount = examMapper.myPcExamCount(0, accountId, examIds, siteId);
        Integer inProgressCount = examMapper.myPcExamCount(1, accountId, examIds, siteId);
        Integer completeCount = examMapper.myPcExamCount(2, accountId, examIds, siteId);
        myExamPageVO.setNotStartCount(notStartCount);
        myExamPageVO.setInProgressCount(inProgressCount);
        myExamPageVO.setCompletedCount(completeCount);
        if (!CollectionUtils.isEmpty(list)) {
            myExamPageVO.setExamVOS(list);
        }
        return myExamPageVO;
    }

    @Override
    public List<Long> getMyFinishedIds(Long accountId, Long siteId, List<Long> examIds) {
        return trExamAnswerMapper.getMyFinishedIds(accountId, siteId, examIds);
    }

    @Override
    public Map<String, Integer> getMinAndMaxPointSum(List<Long> examIds) {
        if (CollectionUtils.isEmpty(examIds)) {
            Map<String, Integer> map = new HashMap<>(2);
            map.put("minPoint", 0);
            map.put("maxPoint", 0);
            return map;
        }
        return examMapper.getMinAndMaxPointSum(examIds);
    }

    @Override
    public List<Exam> getExpireList() {
        RequestContext res = ContextHolder.get();
        List<com.yizhi.application.domain.Exam> exams = examMapper.getExpireList(res.getCompanyId(), res.getSiteId(), res.getAccountId());
        List<Exam> list = new ArrayList<>();
        if (null != exams && exams.size() > 0){
            exams.forEach(examEntity -> {

                Exam examVo = new Exam();
                BeanUtils.copyProperties(examEntity,examVo);
                list.add(examVo);
            });
        }
        return list;
    }

    @Override
    public Page<ExamCalendarVO> getPageToCalendar(Date date, Page<Exam> page) {
        RequestContext context = ContextHolder.get();
        Long siteId = context.getSiteId();
        Long accountId = context.getAccountId();
        //获取已通过的考试ids,包含了次数用完的examId
        List<Long> finishIds = new ArrayList<>();
        //获取未通过的考试ids
        Set<Long> unPassIds = new HashSet<>();
        //获取待批阅的考试ids
        Set<Long> auditIngIds = new HashSet<>();
        //获取继续答卷的考试ids
        Set<Long> answeringIds = new HashSet<>();
        //获取未答卷以及不能参加的考试ids
        Set<Long> unanswerIds = new HashSet<>();
//        List<Long> finalIds = new ArrayList<>();

        Page<ExamCalendarVO> voPage = new Page<>();
        BeanUtils.copyProperties(page, voPage);

        //根据当前时间参数获取数据
        List<Long> ids = examMapper.getIdsByDate(date, siteId);
        if (CollectionUtils.isEmpty(ids)) {
            return voPage;
        }
        unanswerIds.addAll(ids);
        //根据可见范围获取考试ids
        List<Long> examIds = trExamAuthorizeMapper.getUsefulIds(ids, context.getRelationIds(), siteId);
        //获取有答卷记录的考试
        List<com.yizhi.application.domain.TrExamAnswer> temExams = trExamAnswerMapper.getListByIds(ids, accountId, siteId);
        //储存《考试id,允许参加考试的次数》
        Map<Long, Integer> canJoinExamNumMap = new HashMap<>();
        //储存《考试id,已参加对应考试的次数》
        Map<Long, Integer> hasJoinExamNumMap = new HashMap<>();

        if (!CollectionUtils.isEmpty(temExams)) {
            for (com.yizhi.application.domain.TrExamAnswer a : temExams) {
                com.yizhi.application.domain.Exam exam = null;
                if (a.getState() == 2 || a.getState() == 1) {
                    exam = examMapper.selectById(a.getExamId());

                    if (hasJoinExamNumMap.containsKey(a.getExamId())) {
                        hasJoinExamNumMap.put(a.getExamId(), hasJoinExamNumMap.get(a.getExamId()) + 1);
                    } else {
                        hasJoinExamNumMap.put(a.getExamId(), 1);
                    }
                    if (exam != null) {
                        if (!canJoinExamNumMap.containsKey(a.getExamId())) {
                            canJoinExamNumMap.put(a.getExamId(), exam.getAnswerNum());
                        }
                    }
                }
                if (a.getState() == 2) {
                    if (exam != null) {
                        BigDecimal qualifiedScore = new BigDecimal(getNotNull(exam.getQualifiedScore()));
                        if ((qualifiedScore.compareTo(a.getScore()) <= 0)) {
                            finishIds.add(a.getExamId());
                        } else {
                            unPassIds.add(a.getExamId());
                        }
                    }
                } else if (a.getState() == 1) {
                    auditIngIds.add(a.getExamId());
                } else if (a.getState() == 0) {
                    answeringIds.add(a.getExamId());
                }
                unanswerIds.remove(a.getExamId());
            }

            for (Long id : ids) {
                Integer canJoinAssignmnetNum = canJoinExamNumMap.get(id);
                Integer hasJoinAssignmnetNum = hasJoinExamNumMap.get(id);
                if (canJoinAssignmnetNum != null && hasJoinAssignmnetNum != null && canJoinAssignmnetNum != 0) {
                    if (hasJoinAssignmnetNum >= canJoinAssignmnetNum) {
                        finishIds.add(id);
                    }
                }
            }

        }//获取最后需要的数据

        List<com.yizhi.application.domain.Exam> exams = examMapper.getPageToCalendar(finishIds, examIds, date, siteId, page);

        voPage.setRecords(buildExamVo(exams, auditIngIds, answeringIds, unanswerIds, unPassIds, canJoinExamNumMap, hasJoinExamNumMap));
        voPage.setTotal(examMapper.getPageToCalendarNum(finishIds, examIds, date, siteId));
        return voPage;
    }

    /**
     * 组建考试状态
     *
     * @return
     */
    public List<ExamCalendarVO> buildExamVo(List<com.yizhi.application.domain.Exam> exams, Set<Long> auditIngIds, Set<Long> answeringIds,
                                            Set<Long> unanswerIds, Set<Long> unPassIds,
                                            Map<Long, Integer> canJoinExamNumMap,
                                            Map<Long, Integer> hasJoinExamNumMap) {

        List<ExamCalendarVO> calendarVOS = new ArrayList<>();
        if (!CollectionUtils.isEmpty(exams)) {
//            exams.forEach(a -> {
//                finalIds.add(a.getId());
//            });
//            hasJoinExamNumMap = trExamAnswerMapper.getJoinExamNum(accountId, siteId, finalIds);

            for (com.yizhi.application.domain.Exam a : exams) {

                ExamCalendarVO vo = new ExamCalendarVO();
                BeanUtils.copyProperties(a, vo);
                vo.setExamNum(a.getAnswerNum());
                vo.setAnswerNum(hasJoinExamNumMap.get(a.getId()));
                if (answeringIds.contains(a.getId())) {
                    vo.setExamStatus(2);
                    vo.setTaskTag(ButtonStatus.NOT_ANSWER.getCode());//未答卷
                    vo.setTaskButtonStatus(Arrays.asList(ButtonStatus.PROCEED_TO_EXAM.getCode()));//继续答题
                } else if (unanswerIds.contains(a.getId())) {
                    vo.setExamStatus(1);
                    vo.setTaskTag(ButtonStatus.NOT_ANSWER.getCode());//未答卷
                    vo.setTaskButtonStatus(Arrays.asList(ButtonStatus.START_EXAM.getCode()));//开始考试
                }
                if (unPassIds.contains(a.getId())) {
                    vo.setExamStatus(4);
                    vo.setTaskTag(ButtonStatus.FAILED.getCode());//未通过
                    if (!answeringIds.contains(a.getId())) {
                        vo.setTaskButtonStatus(Arrays.asList(ButtonStatus.TAKE_EXAM_AGAIN.getCode(), ButtonStatus.VIEW_DETAILS.getCode()));//重新考试,查看详情
                    } else {
                        vo.setTaskButtonStatus(Arrays.asList(ButtonStatus.PROCEED_TO_EXAM.getCode(), ButtonStatus.VIEW_DETAILS.getCode()));//继续答题,查看详情
                    }
                } else if (auditIngIds.contains(a.getId())) {
                    vo.setExamStatus(3);
                    vo.setTaskTag(ButtonStatus.TO_BE_REVIEWED.getCode());//待批阅
                    if (!answeringIds.contains(a.getId())) {
                        vo.setTaskButtonStatus(Arrays.asList(ButtonStatus.TAKE_EXAM_AGAIN.getCode(), ButtonStatus.VIEW_DETAILS.getCode()));//重新考试,查看详情
                    } else {
                        vo.setTaskButtonStatus(Arrays.asList(ButtonStatus.PROCEED_TO_EXAM.getCode(), ButtonStatus.VIEW_DETAILS.getCode()));//继续答题,查看详情
                    }
                    Integer canJoinExamNum = canJoinExamNumMap.get(a.getId());
                    canJoinExamNum = getNotNull(canJoinExamNum);
                    Integer hasJoinExamNum = hasJoinExamNumMap.get(a.getId());
                    hasJoinExamNum = getNotNull(hasJoinExamNum);
                    if (canJoinExamNum != 0 && canJoinExamNum <= hasJoinExamNum) {
                        vo.setTaskButtonStatus(Arrays.asList(ButtonStatus.VIEW_DETAILS.getCode()));//查看详情
                    }
                } else {
                    vo.setExamStatus(-1);//走到了这一步，不是正常逻辑
                }
                calendarVOS.add(vo);
            }
        }
        return calendarVOS;
    }

    public Integer getNotNull(Integer a) {
        a = a == null ? 0 : a;
        return a;
    }


    @Override
    public Map<Long, Map<String, Object>> getMaxScores(List<Long> examIds) {
        RequestContext res = ContextHolder.get();
        return examMapper.getMaxScores(examIds, res.getAccountId());
    }

    @Override
    public Page<DroolsVo> getPageByDrools(String field, String value, Page<DroolsVo> page) {
        if (StringUtils.isBlank(field)) {
            logger.info("列名不能为空！");
            return page;
        }

        if (field.equalsIgnoreCase(TaskParamsEnums.NAME.getCode())) {
            return getPage(field, value, page);
        } else if (field.equalsIgnoreCase(TaskParamsEnums.KEYWORD.getCode())) {
            field = "keywords";
            return getPage(field, value, page);
        }

        return page;
    }

    public Page getPage(String field, String value, Page<DroolsVo> page) {
        RequestContext requestContext = ContextHolder.get();
        Long siteId = requestContext.getSiteId();
        Long companyId = requestContext.getCompanyId();

        com.yizhi.application.domain.Exam exam = new com.yizhi.application.domain.Exam();
        exam.setSiteId(siteId);
        exam.setCompanyId(companyId);
        exam.setState(2);
        EntityWrapper wrapper = new EntityWrapper(exam);
        wrapper.setSqlSelect("distinct(" + field + "),"+"id ")
                .isNotNull(field)
                .like(field, value)
                .addFilter(field + "!=''")
                .orderBy("create_time", false);

        String upperField = ClassUtil.getFieldName(field);
        List<DroolsVo> voList = null;
        List<com.yizhi.application.domain.Exam> list = this.baseMapper.selectPage(page, wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            voList = new ArrayList<>(list.size());

            List<Exam> examVoList = new ArrayList<>();
            list.forEach(examDomain -> {
                Exam examVo = new Exam();
                BeanUtils.copyProperties(examDomain,examVo);
                examVoList.add(examVo);
            });
            for (Exam a : examVoList) {
                DroolsVo vo = new DroolsVo();
                vo.setTaskId(a.getId());
                vo.setTaskFieldValue(ClassUtil.invokeMethod(a, upperField));
                vo.setTaskParamsType(field);
                voList.add(vo);
            }
            page.setRecords(voList);
        }
        return page;
    }
}
