package com.yizhi.application.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.application.constant.ExamConstant;
import com.yizhi.application.mapper.*;
import com.yizhi.application.domain.*;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.exam.ExamQuestionListVO;
import com.yizhi.exam.application.vo.exam.SortVO;
import com.yizhi.application.mapper.*;
import com.yizhi.application.service.ITrExamSystemQuestionService;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrExamQuestionService;
import org.springframework.util.CollectionUtils;

/**
 * <p>
 * 考试题目 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamQuestionServiceImpl extends ServiceImpl<TrExamQuestionMapper, TrExamQuestion>
        implements ITrExamQuestionService {

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    QuestionLibraryMapper questionLibraryMapper;

    @Autowired
    TrQuestionLibrarySubjectMapper trQuestionLibrarySubjectMapper;

    @Autowired
    TrQuestionSubjectOptionMapper trQuestionSubjectOptionMapper;

    @Autowired
    TrExamQuestionMapper trExamQuestionMapper;

    @Autowired
    TrExamSystemQuestionMapper trExamSystemQuestionMapper;

    @Autowired
    ExamMapper examMapper;

    @Autowired
    ITrExamSystemQuestionService trExamSystemQuestionService;

    @Override
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean updateTrExamQuestionList(List<ExamQuestionVO> examQuestionVoList, Long examId, String accountName, Long accountId) {
        Map<String, Object> map = new HashMap<String, Object>();
        Date date = new Date();
        map.put("exam_id", examId);
        this.deleteByMap(map);
        List<TrExamQuestion> list = new ArrayList<TrExamQuestion>();
        if (examQuestionVoList.size() > 0) {
            ExamQuestionVO vo = null;
            TrExamQuestion teq = null;
            for (int i = 0; i < examQuestionVoList.size(); i++) {
                vo = examQuestionVoList.get(i);
                teq = new TrExamQuestion();
                teq.setId(idGenerator.generate());
                teq.setExamId(vo.getExamId());
                teq.setSubjectId(vo.getSubjectId());
                teq.setScore(vo.getScore());
                teq.setSort(trExamQuestionMapper.selectCount() + 1);
                teq.setState(ExamConstant.FIRST);
                teq.setUpdateById(accountId);
                teq.setUpdateByName(accountName);
                teq.setCreateById(accountId);
                teq.setCreateByName(accountName);
                teq.setCreateTime(date);
                teq.setUpdateTime(date);
                list.add(teq);
            }
        }
        if (list.size() > 0) {
            this.insertBatch(list);
        }
        return true;
    }

    @Override
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean copyExamQuestion(Long oldId, Long examId, String accountName, Long accountId) {
        List<TrExamQuestion> list = new ArrayList<TrExamQuestion>();
        Date date = new Date();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("state", ExamConstant.FIRST);
        map.put("exam_id", oldId);
        List<TrExamQuestion> trExamQuestionList = this.selectByMap(map);
        TrExamQuestion teq = null;
        for (TrExamQuestion tq : trExamQuestionList) {
            teq = new TrExamQuestion();
            BeanUtils.copyProperties(tq, teq);
            teq.setId(idGenerator.generate());
            teq.setExamId(examId);
            teq.setUpdateById(accountId);
            teq.setUpdateByName(accountName);
            teq.setCreateById(accountId);
            teq.setCreateByName(accountName);
            teq.setCreateTime(date);
            teq.setUpdateTime(date);
            list.add(teq);
        }
        if (list.size() > 0) {
            this.insertBatch(list);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertExamQuestionService(ExamQuestionVO examQuestionVO) throws Exception {
        QuestionLibrary questionLibrary = null;
        TrQuestionLibrarySubject trQuestionLibrarySubject = null;
        TrQuestionSubjectOption trQuestionSubjectOption = null;
        TrExamQuestion trExamQuestion = null;
        int insertQuestionLibrarySubjectCount = 0;
        int insertQuestionSubjectOptionCount = 0;
        int insertExamQuestionCount = 0;
        Date createTime = new Date();

        List<QuestionLibrarySubjectVO> questionLibrarySubjectVOS = examQuestionVO.getQuestionLibrarySubjectVOS();

        try {
            if (null != questionLibrarySubjectVOS) {
                for (QuestionLibrarySubjectVO questionLibrarySubjectVO : questionLibrarySubjectVOS) {
                    if (questionLibrarySubjectVO != null) {

                        // 如果题目ID为空新增题目
                        if (null == questionLibrarySubjectVO.getId()) {
                            trQuestionLibrarySubject = new TrQuestionLibrarySubject();
                            BeanUtils.copyProperties(questionLibrarySubjectVO, trQuestionLibrarySubject);
                            trQuestionLibrarySubject.setId(idGenerator.generate());
                            trQuestionLibrarySubject.setCompanyId(examQuestionVO.getCompanyId());
                            trQuestionLibrarySubject.setSiteId(examQuestionVO.getSiteId());
                            trQuestionLibrarySubject.setOrgId(examQuestionVO.getOrgId());
                            trQuestionLibrarySubject.setCreateById(examQuestionVO.getAccountId());
                            trQuestionLibrarySubject.setCreateByName(examQuestionVO.getAccountName());
                            trQuestionLibrarySubject.setUpdateById(examQuestionVO.getAccountId());
                            trQuestionLibrarySubject.setUpdateByName(examQuestionVO.getAccountName());
                            trQuestionLibrarySubject.setUpdateTime(createTime);

                            insertQuestionLibrarySubjectCount = trQuestionLibrarySubjectMapper
                                    .insert(trQuestionLibrarySubject);
                            // 问答题不用对选项进行操作
                            if (insertQuestionLibrarySubjectCount > 0 && questionLibrarySubjectVO.getType() != 4) {
                                List<QuestionSubjectOptionVO> questionSubjectOptionVOS = questionLibrarySubjectVO
                                        .getQuestionSubjectOptionVOList();
                                if (null != questionLibrarySubjectVOS) {
                                    if (questionLibrarySubjectVO.getType() == 2) {
                                        Integer rightAnswerNum = 0;
                                        for (QuestionSubjectOptionVO questionSubjectOptionVO : questionSubjectOptionVOS) {
                                            if (questionSubjectOptionVO.getIsAnswer() == 1) {
                                                rightAnswerNum++;
                                            }
                                        }
                                        if (rightAnswerNum <= 1) {
                                            return false;
                                        }
                                    }

                                    int sort1 = 0;
                                    // 用于排序
                                    sort1++;
                                    for (QuestionSubjectOptionVO questionSubjectOptionVO : questionSubjectOptionVOS) {
                                        if (null != questionSubjectOptionVO) {
                                            trQuestionSubjectOption = new TrQuestionSubjectOption();
                                            BeanUtils.copyProperties(questionSubjectOptionVO, trQuestionSubjectOption);
                                            trQuestionSubjectOption.setSubjectId(trQuestionLibrarySubject.getId());
                                            trQuestionSubjectOption.setSort(sort1);
                                            trQuestionSubjectOption.setId(idGenerator.generate());
                                            trQuestionSubjectOption.setCreateTime(createTime);
                                            trQuestionSubjectOption.setCreateById(examQuestionVO.getAccountId());
                                            trQuestionSubjectOption.setCreateByName(examQuestionVO.getAccountName());
                                            trQuestionSubjectOption.setUpdateById(examQuestionVO.getAccountId());
                                            trQuestionSubjectOption.setUpdateByName(examQuestionVO.getAccountName());
                                            trQuestionSubjectOption.setUpdateTime(createTime);
                                            insertQuestionSubjectOptionCount = trQuestionSubjectOptionMapper
                                                    .insert(trQuestionSubjectOption);
                                        }
                                    }
                                }
                            }
                        }
                        // 新增考试试题
                        trExamQuestion = new TrExamQuestion();
                        trExamQuestion.setId(idGenerator.generate());
                        trExamQuestion.setExamId(examQuestionVO.getExamId());
                        trExamQuestion.setSubjectId(trQuestionLibrarySubject.getId());
                        trExamQuestion.setScore(questionLibrarySubjectVO.getScore());
                        trExamQuestion.setSort(examQuestionVO.getSort());
                        trExamQuestion.setCreateById(examQuestionVO.getAccountId());
                        trExamQuestion.setCreateByName(examQuestionVO.getAccountName());
                        trExamQuestion.setCreateTime(createTime);
                        trExamQuestion.setUpdateById(examQuestionVO.getAccountId());
                        trExamQuestion.setUpdateByName(examQuestionVO.getAccountName());
                        trExamQuestion.setUpdateTime(createTime);
                        trExamQuestion.setLibraryId(questionLibrarySubjectVO.getLibraryId());
                        insertExamQuestionCount = trExamQuestionMapper.insert(trExamQuestion);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("创建考试试题失败", e);
        }

        return true;
    }

    @Override
    public Page<TrExamQuestion> selectExamQuestionById(Long examId, Integer pageNo, Integer pageSize) {
        TrExamQuestion trExamQuestion = new TrExamQuestion();
        trExamQuestion.setExamId(examId);
        Page<TrExamQuestion> page = new Page<TrExamQuestion>(pageNo, pageSize);
        EntityWrapper<TrExamQuestion> wrapper = new EntityWrapper<TrExamQuestion>(trExamQuestion);
        Page p = this.selectPage(page, wrapper);
        return p;
    }

    @Override
    public QuestionPreview examPreview(Long examTitleId) {
        Exam exam = examMapper.selectById(examTitleId);
        BigDecimal sc = BigDecimal.valueOf(0);
        Integer num = 0;

        List<ShowExamQuestionVO> list = null;
        if (exam != null && exam.getMakeStrategy() == 1) {
            list = trExamQuestionMapper.examPreview(examTitleId);
            for (ShowExamQuestionVO showExamQuestionVO : list) {
                if (null != showExamQuestionVO.getScore()) {
                    sc = sc.add(showExamQuestionVO.getScore());
                }

                num += showExamQuestionVO.getNumSum();
            }
        } else if (exam != null && exam.getMakeStrategy() == 2) {
            list = trExamSystemQuestionMapper.selectExamSystemQuestionScoreAndNum(examTitleId);
            for (ShowExamQuestionVO showExamQuestionVO : list) {
                if (null != showExamQuestionVO.getScore()) {
                    sc = sc.add(showExamQuestionVO.getScore());
                }
                num += showExamQuestionVO.getNumSum();
            }
        }
        QuestionPreview questionPreview = new QuestionPreview();
        questionPreview.setSumScore(sc);
        questionPreview.setSumQuestion(num);
        questionPreview.setName(exam.getName());
        questionPreview.setShowExamQuestionVO(list);
        return questionPreview;
    }

    @Override
    public List<ExamQuestionLibraryVO> selectExamQuestionListById(Long examId, Integer pageNo, Integer pageSize) {
		/*Integer start = (pageNo - 1) * pageSize;
		Integer end = pageSize;
		if(pageNo == 1){
			end = end + 1;
		}else if(pageNo > 1){
			start = start - 1;
			end = end + 2;
		}*/
        Page<ExamQuestionLibraryVO> page = new Page<ExamQuestionLibraryVO>(pageNo, pageSize);

        List<ExamQuestionLibraryVO> examQuestionLibraryVOS = trExamQuestionMapper.selectExamQuestionListById(examId, new RowBounds(page.getOffset(), page.getLimit()));

		/*Page<TrExamQuestion> page = new Page<TrExamQuestion>(pageNo, pageSize);
		TrExamQuestion trExamQuestion = new TrExamQuestion();
		trExamQuestion.setExamId(examId);
		EntityWrapper<TrExamQuestion> wrapper = new EntityWrapper<TrExamQuestion>(trExamQuestion);
		Page p = this.selectPage(page, wrapper);
		List<TrExamQuestion> list = p.getRecords();*/
        return examQuestionLibraryVOS;
    }

    @Override
    public Integer sumNum(Long examId) {
        TrExamQuestion trExamQuestion = new TrExamQuestion();
        if (null != examId) {
            trExamQuestion.setExamId(examId);
        }
        trExamQuestion.setState(1);
        EntityWrapper<TrExamQuestion> wrapper = new EntityWrapper<TrExamQuestion>(trExamQuestion);
        return this.selectCount(wrapper);
    }

    @Override
    public boolean updateScoreById(ExamQuestionVO examQuestionVO) {
        if (examQuestionVO == null || examQuestionVO.getQuestionLibrarySubjectVOS() == null) {
            return false;
        }

        try {
            TrExamQuestion trExamQuestion = new TrExamQuestion();
            for (QuestionLibrarySubjectVO item : examQuestionVO.getQuestionLibrarySubjectVOS()) {
                trExamQuestion.setId(item.getId());
                trExamQuestion.setScore(item.getScore());
                this.updateById(trExamQuestion);
            }
        } catch (Exception e) {
            return false;
        }

        return true;
    }

    @Override
    public boolean move(List<SortVO> sortVOs) {
        try {
            SortVO sortVO1 = sortVOs.get(0);
            SortVO sortVO2 = sortVOs.get(1);
            TrExamQuestion trExamQuestion1 = this.selectById(sortVO1.getId());
            TrExamQuestion trExamQuestion2 = this.selectById(sortVO2.getId());
            Integer sort1 = trExamQuestion1.getSort();
            Integer sort2 = trExamQuestion2.getSort();
            trExamQuestion1.setSort(sort2);
            trExamQuestion2.setSort(sort1);
            boolean result1 = this.updateById(trExamQuestion1);
            boolean result2 = this.updateById(trExamQuestion2);
            if (result1 && result2) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            return false;
        }
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public boolean insertQuestion(ExamQuestionListVO examQuestionListVO) {
        boolean result = false;
        Date date = new Date();
        List<TrExamQuestion> list = new ArrayList<TrExamQuestion>();
        TrExamQuestion teq;
        if (examQuestionListVO.getExamQuestionVOS().size() > 0) {
            for (ExamQuestionVO vo : examQuestionListVO.getExamQuestionVOS()) {
                teq = new TrExamQuestion();
                teq.setId(idGenerator.generate());
                teq.setExamId(vo.getExamId());
                teq.setSubjectId(vo.getSubjectId());
                teq.setSort(vo.getSort());
                teq.setLibraryId(vo.getLibraryId());
                teq.setState(ExamConstant.FIRST);
                teq.setCreateById(examQuestionListVO.getAccountId());
                teq.setCreateByName(examQuestionListVO.getAccountName());
                teq.setCreateTime(date);
                teq.setUpdateById(examQuestionListVO.getAccountId());
                teq.setUpdateByName(examQuestionListVO.getAccountName());
                teq.setUpdateTime(date);
                list.add(teq);
            }
        }
        if (list.size() > 0) {
            result = this.insertBatch(list);
        }
        return result;
    }

    @Override
    public Integer deleteById(List<Long> id) {
        return trExamQuestionMapper.updateAllById(id);
    }

    @Override
    public Integer selectQuestionCountByExamId(Long examId) {
        Integer examQuestionCount = trExamQuestionMapper.selectQuestionCountByExamId(examId);
        Integer examSystemQuestionCount = trExamSystemQuestionMapper.getSystemQestionCount(examId);

        return examQuestionCount + examSystemQuestionCount;
    }

    @Override
    public boolean insertAll(List<TrExamQuestion> trExamQuestions) {
        return this.insertBatch(trExamQuestions);
    }

    @Override
    public Long insertOne(TrExamQuestion trExamQuestion) {
        Long id = idGenerator.generate();
        trExamQuestion.setId(id);
        boolean result = this.insert(trExamQuestion);
        if (result) {
            return id;
        } else {
            return null;
        }
    }

    @Override
    public Integer deleteByExamId(Long examId) {
        return trExamQuestionMapper.deleteByExamId(examId);
    }

    @Override
    public Integer updateExamQuestion(ExamQuestionVO vo) {
        try {

            //根据考试id查出libraryId
            TrExamQuestion trExamQuestion = new TrExamQuestion();
            trExamQuestion.setExamId(vo.getExamId());
            EntityWrapper wrapper = new EntityWrapper(trExamQuestion);
            List<TrExamQuestion> list = trExamQuestionMapper.selectList(wrapper);
            if (!CollectionUtils.isEmpty(list)) {
                trExamQuestion = list.get(0);
            }
            Long libraryId = trExamQuestion.getLibraryId();
            if (!libraryId.equals(vo.getLibraryId())) {
                //清除
                trExamQuestionMapper.deleteByExamId(vo.getExamId());
                TrExamSystemQuestion sysQus = new TrExamSystemQuestion();
                sysQus.setExamId(vo.getExamId());
                EntityWrapper<TrExamSystemQuestion> wrapper1 = new EntityWrapper<TrExamSystemQuestion>(sysQus);
                trExamSystemQuestionService.delete(wrapper1);
            }
            return 1;
        } catch (Exception e) {
            return -1;
        }
    }

    @Override
    public Integer updateByExamId(Long examId) {
        try {
            return trExamQuestionMapper.updateByExamId(examId);
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}
