package com.yizhi.application.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.application.constant.ExamConstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.TrExamRemind;
import com.yizhi.exam.application.vo.TrExamRemindTimeVO;
import com.yizhi.exam.application.vo.TrExamRemindVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.mapper.TrExamRemindMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrExamRemindService;
import com.yizhi.application.service.ITrExamRemindTimeService;

/**
 * <p>
 * 提醒设置 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamRemindServiceImpl extends ServiceImpl<TrExamRemindMapper, TrExamRemind>
		implements ITrExamRemindService {

	@Autowired
	private IdGenerator idGenerator;
	@Autowired
	private ITrExamRemindTimeService trExamRemindTimeService;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public TrExamRemindVO listTrExamRemind(Long examId) {
		TrExamRemindVO vo = new TrExamRemindVO();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("exam_id", examId);
		map.put("state", ExamConstant.FIRST);
		List<TrExamRemind> selectByMap = this.selectByMap(map);
		if (selectByMap.size() > 0) {
			TrExamRemind tr = selectByMap.get(0);
			BeanUtils.copyProperties(tr, vo);
			/*vo.setId(tr.getId());
			vo.setExamId(examId);
			vo.setContent(tr.getContent());
			vo.setState(tr.getState());
			vo.setTemplateId(tr.getTemplateId());*/
			/**
			 * 提醒类型可多选，当前设计时只能单选，现在暂不保存，可以从提醒服务那边得到，
			 *  如果要保存，建议把数据类型改成字符用逗号分割
			 */
			//vo.setType(tr.getType()); 
			List<TrExamRemindTimeVO> ttVoList = trExamRemindTimeService.listTrExamRemindTime(tr.getId());
			vo.setTrExamRemindTimeVoList(ttVoList);
		}
		return vo;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean updateTrExamRemind(TrExamRemindVO vo, Long examId, String accountName, Long accountId) {
		TrExamRemind tr = new TrExamRemind();
		if (vo.getId() == null) {
			tr.setId(idGenerator.generate());
			tr.setExamId(examId);
			/**
			 * 提醒类型可多选，当前设计时只能单选，现在暂不保存，可以从提醒服务那边得到，
			 *  如果要保存，建议把数据类型改成字符用逗号分割
			 */
			tr.setType(vo.getType());
			tr.setContent(vo.getContent());
			tr.setTemplateId(vo.getTemplateId());
			tr.setState(ExamConstant.FIRST);
			setInsertCloumn(tr, true, accountName, accountId);
			this.insert(tr);
		} else {
			tr = this.selectById(vo.getId());
			/**
			 * 提醒类型可多选，当前设计时只能单选，现在暂不保存，可以从提醒服务那边得到，
			 *  如果要保存，建议把数据类型改成字符用逗号分割
			 */
			if(null != tr){
				tr.setType(vo.getType());
				tr.setContent(vo.getContent());
				tr.setTemplateId(vo.getTemplateId());
				tr.setState(vo.getState());
				setInsertCloumn(tr, false, accountName, accountId);
				this.updateById(tr);
			}
		}
		if (vo.getTrExamRemindTimeVoList() != null) {
			trExamRemindTimeService.updateTrExamRemindTimeVoList(vo.getTrExamRemindTimeVoList(), tr.getId(), accountName, accountId);
		}
		return true;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean copyTrExamRemind(Long oldId, Long examId, String accountName, Long accountId) {
		TrExamRemind tq = new TrExamRemind();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("state", ExamConstant.FIRST);
		map.put("exam_id", oldId);
		List<TrExamRemind> selectByMap = this.selectByMap(map);
		if (selectByMap.size() > 0) {
			TrExamRemind ter = selectByMap.get(0);
			BeanUtils.copyProperties(ter, tq);
			tq.setId(idGenerator.generate());
			tq.setExamId(examId);
			setInsertCloumn(tq, true, accountName, accountId);
			this.insert(tq);

			// 复制 提醒时间设置
			trExamRemindTimeService.copyTrExamRemindTime(ter.getId(), tq.getId(), accountName, accountId);
		}
		return true;
	}

	public void setInsertCloumn(TrExamRemind tq, boolean boo, String accountName, Long accountId) { 
		if (boo) {
			tq.setCreateById(accountId);
			tq.setCreateByName(accountName);
			tq.setCreateTime(new Date());
			tq.setUpdateById(accountId);
			tq.setUpdateByName(accountName);
			tq.setUpdateTime(new Date());
		} else {
			tq.setUpdateById(accountId);
			tq.setUpdateByName(accountName);
			tq.setUpdateTime(new Date());
		}
	}
}