package com.yizhi.application.util;

public class RandomUtil {
	/**
	 * 获取不重复的随机数
	 * @param randomSeed 随机种子
	 * @param size 返回数组大小
	 * @return
	 */
	public static int[] getRandom(int randomSeed, int size) {
		return getRandom(randomSeed, size, true);
	}
	
	/**
	 * 获取随机数
	 * @param randomSeed随机种子
	 * @param size返回数组大小
	 * @param isrepeat是否校验重复
	 * @return
	 */
	public static int[] getRandom(int randomSeed, int size, boolean isRepeat) {
		int[] intRet = new int[size];
		int index = 0; // 数组下标
		int num = 0; // 存放产生的随机数
		boolean flag = false; // 是否已经生成过标志
		while(index < size) {
			num = (int) (Math.random() * randomSeed);
			if(isRepeat) {
				for(int x = 0; x < index; x++) {
					if(intRet[x] == num) {
						flag = true;
						break;
					}else {
						flag = false;
					}
				}
			}

			if(!flag) {
				intRet[index++] = num;
			}
		}
		
		return intRet;
	}

	public static void main(String[] args) {
		int x[] = RandomUtil.getRandom(10, 10, true);
		 for(int i = 0; i < x.length; i++){
             System.out.println(i + "->" + x[i]);
         }
	}
}
