/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamManageClient
 * Author:   phone
 * Date:     2018/3/21 14:23
 * Description: 考试管理端
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.exam.ExamQuestionListVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * 〈考试管理端〉
 *
 * @author fanchunhui
 * @create 2018/3/21
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "ExamManageClient")
public interface ExamManageClient {


    @PostMapping(value = "/manage/exam/info/insert")
    Long insertOrUpdateBaseInfo(@RequestBody BaseInfoVO vo);

    @PostMapping(value = "/info/update")
    Long insertOrUpdateBaseInfoUpdate(@RequestBody BaseInfoVO vo);

    @PostMapping("/manage/exam/question/select/insert")
    Long updateExamQuestion(@RequestBody AddQuestionVO vo);

    @PostMapping("/manage/exam/system/list")
    List<TrExamSystemQuestionVO> listTrExamSystemQuestion(@RequestParam("examId") Long examId);

    @PostMapping("/manage/exam/question/sort/list")
    List<TrExamQuestionSortVO> listTrExamQuestionSort(@RequestParam("examId") Long examId);

    @PostMapping("/manage/exam/strategy/list")
    ExamStrategyVO listExamStrategy(@RequestParam("examId") Long examId);

    @PostMapping(value = "/manage/exam/strategy/insert")
    Long updateExamStrategy(@RequestBody ExamStrategyVO vo);

    @PostMapping(value = "/preview")
    Long updateExamStrategyPreview(@RequestBody ExamStrategyVO vo);

    @PostMapping("/manage/exam/copy")
    boolean copyExamRelated(@RequestBody Exam exam);

    @PostMapping(value = {"/manage/exam/release"})
    Long releaseExamRelated(@RequestBody ExamStrategyVO vo);

    @GetMapping("/manage/exam/question/select/list")
    Map<String, Object> listExamQuestion(@RequestBody ContextAndPageSizeVO contextAndPageSizeVO);

    @PostMapping("/manage/exam/question/insertall")
    boolean insertExamQuestion(@RequestBody ExamQuestionListVO examQuestionListVO);

    @GetMapping("/manage/exam/authorize/list")
    List<TrExamAuthorizeVO> selectAuthorizeVO(@RequestParam("examId") Long examId);

    @PostMapping("/manage/exam/insert/authorize/list")
    boolean insertAllAuthorize(@RequestBody List<TrExamAuthorizeVO> trExamAuthorizeVOS, @RequestParam("accountId") Long accountId, @RequestParam("accountName") String accountName, @RequestParam("siteId") Long siteId);

    /**
     * 胡涛需要,获得所有考试最小积分和最大积分之和
     * @param examIds
     * @return
     */
    @PostMapping("/manage/exam/getMinAndMaxPointSum")
    Map<String, Integer> getMinAndMaxPointSum(@RequestBody List<Long> examIds);

    @GetMapping("/manage/exam/getPageByDrools")
    Page<DroolsVo> getPageByDrools(@RequestParam("field") String field,
                                   @RequestParam(value = "value", required = false) String value,
                                   @RequestParam("pageNo") Integer pageNo,
                                   @RequestParam("pageSize") Integer pageSize);
}
