package com.yizhi.exam.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "BaseInfoVO", description = "基本信息vo")
@Data
public class BaseInfoVO {

	@ApiModelProperty(value = "主键ID, 新建不传")
	private Long id;

	@ApiModelProperty(value = "考试编码，系统自动生成考试编码。编码规则，按创建顺序累加，例如KS000001，KS000002")
	private String examNo;

	@ApiModelProperty(value = "考试名称")
	private String name;

	@ApiModelProperty(value = "考试说明")
	private String description;

	@ApiModelProperty(value = "开始时间，字符串， 2018-3-14 14:08")
	private String startTime;

	@ApiModelProperty(value = "结束时间，字符串， 2018-3-14 14:08")
	private String endTime;

	@ApiModelProperty(value = "答卷时长，0无限制 >0有限制(分钟)")
	private Integer duration;

	@ApiModelProperty(value = "答题次数，0无限制 >0有限次(次)")
	private Integer answerNum;

	@ApiModelProperty(value = "考试次数，允许考试参加的次数")
	private Integer examNum;

	@ApiModelProperty(value = "合格分，本次考试的合格分")
	private Integer qualifiedScore;

	@ApiModelProperty(value = "出题策略，1手动出题 2系统出题")
	private Integer makeStrategy;

	@ApiModelProperty(value = "原考试编码，复制考试时记录来源,复制传")
	private String oldExamNo;

	@ApiModelProperty(value = "原考试ID，复制考试时记录来源, 复制传")
	private Long oldExamId;

	@ApiModelProperty(value = "培训项目_ID")
	private Long trainingProjectId;

	@ApiModelProperty("用户ID")
	private Long accountId;

	@ApiModelProperty("用户名")
	private String accountName;
	
	@ApiModelProperty("企业ID")
	private Long companyId;
	
	@ApiModelProperty("组织ID")
	private Long orgId;
	
	@ApiModelProperty("站点ID")
	private Long siteId;

    @ApiModelProperty("考试logo")
    private String image;

	@ApiModelProperty("关键词")
	private String keywords;
}
