package com.yizhi.exam.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈数据隔离VO〉
 *
 * @author phone
 * @create 2018/5/30
 * @since 1.0.0
 */
@ApiModel("数据隔离VO")
@Data
public class ContextAndPageSizeVO {

    @ApiModelProperty("站点ID")
    private Long siteId;

    @ApiModelProperty("企业ID")
    private Long companyId;

    @ApiModelProperty("不是管理员情况下此人所有ID")
    private List<Long> orgIds;

    @ApiModelProperty("当前页")
    private Integer pageNo;

    @ApiModelProperty("一页显示的条数")
    private Integer pageSize;

    @ApiModelProperty("(题库列表)：状态 0删除 1使用 2未使用 3全部  （默认）：0删除 1有效 (考试列表):1草稿箱 2上架 3下架")
    private Integer state;

    @ApiModelProperty("名字")
    private String name;

    @ApiModelProperty("考试试题列表题型，1单选题、2多选题、3判断题、4问答题")
    private Integer type;

    @ApiModelProperty("题干关键字")
    private String stemKey;

    @ApiModelProperty("年度")
    private String year;

    @ApiModelProperty("题库关键字")
    private String libraryKey;

    @ApiModelProperty("考试id")
    private Long examId;

    @ApiModelProperty("题库id")
    private Long libraryId;

    @ApiModelProperty(value = "题库no")
    private String libraryNo;

    @ApiModelProperty("题库类型")
    private Integer libraryType;

    @ApiModelProperty("出题策略")
    private Integer makeStrategy;


}