/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: MarkStudentVO
 * Author:   phone
 * Date:     2018/4/25 17:13
 * Description: 批阅答卷VO
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈批阅答卷VO〉
 *
 * @author phone
 * @create 2018/4/25
 * @since 1.0.0
 */
@Data
public class MarkStudentVO {

    @ApiModelProperty(value = "阅卷ID")
    private Long readOverId;

    @ApiModelProperty("考试ID")
    private Long examId;
    
    @ApiModelProperty("考试名")
    private String examName;

    @ApiModelProperty("答题人")
    private String name;

    @ApiModelProperty("用户名")
    private String userName;

    @ApiModelProperty("客观题分数")
    private BigDecimal objectiveScore;

    @ApiModelProperty("客观题分数")
    private BigDecimal subjectiveScore;

    @ApiModelProperty("总分")
    private BigDecimal sumScore;

    @ApiModelProperty("是否合格 0不合格 1合格")
    private Integer isQualified;

    @ApiModelProperty("学员ID")
    private Long accountId;

    @ApiModelProperty("用户姓名")
    private String accountName;

    @ApiModelProperty("阅卷人")
    private Long readAccountId;

    @ApiModelProperty("阅卷人姓名")
    private String readAccountName;

    @ApiModelProperty("答卷ID")
    private Long examAnswerId;

    @ApiModelProperty("阅卷次数")
    private Integer sumNum;

    @ApiModelProperty("阅卷类型 0保存阅卷 1完成阅卷")
    private Integer type;
    
    @ApiModelProperty("主观题列表")
    private List<MarkStudentQuestionVO> markStudentQuestionVOS;

}