package com.yizhi.exam.application.vo;

import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "MyExamVO", description = "我的考试")
@Data
public class MyExamVO {

	@ApiModelProperty(value = "考试名称")
	private String name;

	@ApiModelProperty(value = "考试id")
	private Long id;

	@ApiModelProperty(value = "答卷id,继续考试用")
	private Long answerId;

	@ApiModelProperty(value = "答卷分数")
	private BigDecimal score;

	@ApiModelProperty(value = "及格分数")
	private BigDecimal qualifiedScore;

	@ApiModelProperty(value = "可考次数,0:不限次数, >0:显示的次数")
	private Integer maxNum;

	@ApiModelProperty(value = "已考次数")
	private Integer examNum;

	@ApiModelProperty(value = "学员id")
	private Long accountId;

	@ApiModelProperty(value = "考试开始时间")
	private Date startTime;

	@ApiModelProperty(value = "考试结束时间")
	private Date endTime;

	@ApiModelProperty(value = "状态：0未通过 1已通过 2待阅卷/(pc端后端用): 0未交卷 1已交卷 2已阅卷")
	private Integer state;

	//后端内部使用
	private Integer maxState;

	@ApiModelProperty(value = "操作: 0开始考试 1继续考试(无查看记录) 2继续考试(查看记录) 3重新考试(查看记录) 4(只有查看记录) 5待补考 6已完成 7已结束")
	private Integer handle;

	@ApiModelProperty(value = "考试说明")
	private String description;

	@ApiModelProperty(value = "是否通过：0未通过 1已通过 2待阅卷 3已逾期 4未答卷")
	private String isQualified;

	@ApiModelProperty(value = "培训项目关联ID")
	private Long trainingProjectId;

	@ApiModelProperty(value = "培训项目名称")
	private String trainingProjectName;
	
	@ApiModelProperty(value = "考试logo图片")
	private String logoImg;
}
