package com.yizhi.exam.application.vo.exam;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 考试题目，用于生成试卷用
 * 
 * @author mei
 * @create 2018/3/14
 */

@ApiModel(value = "QuestionListVO", description = "考试题目，用于生成试卷用")
public class QuestionListVO implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4371420748754872960L;

	@ApiModelProperty(value = "入库后答案题目ID")
	private Long answerQuestionId;

	@ApiModelProperty(value = "题库ID主键，出题策略为系统出题时有值")
	private Long libraryId;

	@ApiModelProperty(value = "题目ID主键")
	private Long subjectId;

	@ApiModelProperty(value = "考试题目ID主键，出题策略为手工出题时有值")
	private Long examQuestionId;

	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "题干，题目内容")
	private String stem;

	@ApiModelProperty(value = "题干附件路径，支持上传附件（图片、音频、视频），存放路径")
	private String stemAppendixUrl;

	@ApiModelProperty(value = "分数")
	private BigDecimal score;

	@ApiModelProperty(value = "排序")
	private Integer sort;

	@ApiModelProperty(value = "题目标记（0未标记 1已标记）")
	private int flag = 0;

	@ApiModelProperty(value = "答题标识（0未答题 1已答题）")
	private int answerFlag = 0;
	
	@ApiModelProperty(value = "添加、修改标识（i添加 u更新）")
	private String updateFlag;
	
	@ApiModelProperty(value = "必答题标记（0非必答 必答）")
	private int requiredFlag = 0;
	

	@ApiModelProperty(value = "考试题目选项")
	List<QuestionOptionListVO> questionOptions;

	@ApiModelProperty(value = "答题卡")
	private Long index;

	@ApiModelProperty(value = "问答题答案")
	private String sub;

	public String getSub() {
		return sub;
	}

	public void setSub(String sub) {
		this.sub = sub;
	}

	public Long getAnswerQuestionId() {
		return answerQuestionId;
	}

	public void setAnswerQuestionId(Long answerQuestionId) {
		this.answerQuestionId = answerQuestionId;
	}

	public Long getLibraryId() {
		return libraryId;
	}

	public void setLibraryId(Long libraryId) {
		this.libraryId = libraryId;
	}

	public Long getSubjectId() {
		return subjectId;
	}

	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}

	public Long getExamQuestionId() {
		return examQuestionId;
	}

	public void setExamQuestionId(Long examQuestionId) {
		this.examQuestionId = examQuestionId;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getStem() {
		return stem;
	}

	public void setStem(String stem) {
		this.stem = stem;
	}

	public String getStemAppendixUrl() {
		return stemAppendixUrl;
	}

	public void setStemAppendixUrl(String stemAppendixUrl) {
		this.stemAppendixUrl = stemAppendixUrl;
	}

	public BigDecimal getScore() {
		return score;
	}

	public void setScore(BigDecimal score) {
		this.score = score;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public int getFlag() {
		return flag;
	}

	public void setFlag(int flag) {
		this.flag = flag;
	}

	public int getAnswerFlag() {
		return answerFlag;
	}

	public void setAnswerFlag(int answerFlag) {
		this.answerFlag = answerFlag;
	}

	public String getUpdateFlag() {
		return updateFlag;
	}

	public void setUpdateFlag(String updateFlag) {
		this.updateFlag = updateFlag;
	}

	public List<QuestionOptionListVO> getQuestionOptions() {
		return questionOptions;
	}

	public void setQuestionOptions(List<QuestionOptionListVO> questionOptions) {
		this.questionOptions = questionOptions;
	}

	public Long getIndex() {
		return index;
	}

	public void setIndex(Long index) {
		this.index = index;
	}

	public int getRequiredFlag() {
		return requiredFlag;
	}

	public void setRequiredFlag(int requiredFlag) {
		this.requiredFlag = requiredFlag;
	}
	
}
