package com.yizhi.exam.application.vo.exam;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 考试题目选项，用于生成试卷用
 * 
 * @author mei
 * @create 2018/3/14
 */

@ApiModel(value = "QuestionOptionListVO", description = "考试题目选项，用于生成试卷用")
public class QuestionOptionListVO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8549949064949058846L;

	@ApiModelProperty(value = "选项_ID主键")
	private Long optionId;

	@ApiModelProperty(value = "选项内容，存放文字、图片、音频、视频")
	private String content;

	@ApiModelProperty(value = "选项附件路径，图片、音频、视频存放路径")
	private String optionAppendixUrl;

	@ApiModelProperty(value = "排序")
	private Integer sort;

	@ApiModelProperty(value = "用户答案标识 0未选择 1选择")
	private Integer answer = 0;

	@ApiModelProperty(value = "题目答案标识 0未选择 1选择")
	private Integer rightAnswer = 0;

	public Long getOptionId() {
		return optionId;
	}

	public void setOptionId(Long optionId) {
		this.optionId = optionId;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getOptionAppendixUrl() {
		return optionAppendixUrl;
	}

	public void setOptionAppendixUrl(String optionAppendixUrl) {
		this.optionAppendixUrl = optionAppendixUrl;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public Integer getAnswer() {
		return answer;
	}

	public void setAnswer(Integer answer) {
		this.answer = answer;
	}

	public Integer getRightAnswer() {
		return rightAnswer;
	}

	public void setRightAnswer(Integer rightAnswer) {
		this.rightAnswer = rightAnswer;
	}
}
