package com.yizhi.exam.application.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 〈一句话功能简述〉<br> 
 * 〈考试统计VO〉
 *
 * @author phone
 * @create 2018/5/11
 * @since 1.0.0
 */
@ApiModel("考试统计VO")
@Data
public class ReportExamVO {

    @ApiModelProperty("考试ID")
    Long id;

    @ApiModelProperty("考试名称")
    String name;

    @ApiModelProperty("考试开始时间")
    Date startTime;

    @ApiModelProperty("考试结束时间")
    Date endTime;

    @ApiModelProperty("可参加人数")
    Integer totalAsk = 0;

    @ApiModelProperty("实际参加人数")
    Integer totalIn = 0;
 
    @ApiModelProperty("考试通过人数")
    Integer totalPass = 0;

    @ApiModelProperty("平均分")
    BigDecimal avgScore;

    @ApiModelProperty("完成率")
    BigDecimal complete;

    @ApiModelProperty("通过率")
    BigDecimal passRate;
    
    @ApiModelProperty(value="可见范围")
    Integer visibleRange = 0;
    
    @ApiModelProperty(value="站点ID")
    Long siteId;
    
    @ApiModelProperty(value="企业ID")
    Long companyId;
    
    @ApiModelProperty(value="是否有分数段评价")
    Integer isPaperid;

    @ApiModelProperty(value = "用户状态")
    Integer accountState;

    @ApiModelProperty(value = "超级管理员下业务的可见范围类型")
    Integer rangeType;

}