package com.yizhi.application.cache;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cache.Cache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

/**  
 * 完善基类RedisCacheManager</br>
 * 		1、基类中没有单独只获取缓存的方法</br>子类中的getRedisCache方法，只获取缓存不新增</br>
 * 		2、基类中setDefaultExpiration方法在多线程中不安全
 * 
 * @author mei
 *
 */
public class RedisCacheManagerEx extends RedisCacheManager {
	
	/**
	 * 加锁的对象，对象越小越好，便于在synchronized时更快的获取和释放该对象的资源，
	 */
	private byte[] lock = new byte[1];
	
	@SuppressWarnings("rawtypes")
	public RedisCacheManagerEx(RedisCacheWriter cacheWriter) {
		this(cacheWriter, RedisCacheConfiguration.defaultCacheConfig());
	}

	@SuppressWarnings("rawtypes")
	public RedisCacheManagerEx(RedisCacheWriter cacheWriter, RedisCacheConfiguration redisCacheConfiguration) {
		super(cacheWriter, redisCacheConfiguration, false);
	}
	
	/**
	 * 只获取缓存，和基类getCache区别是，如果缓存不存在返回null，不会新增加
	 * 
	 * @param name 缓存名称
	 * @return 不存在返回null
	 */
	public Cache getRedisCache(String name) {
		return super.lookupCache(name);
	}
	
	/**
	 * 创建缓存</br>
	 * setDefaultExpiration方法在多线程中不安全，需要同步
	 * @param cacheName 缓存名称
	 * @param expireTime 缓存失效时间
	 * @return
	 */
	public Cache createRedisCache(String cacheName, Long expireTime){
		return super.createRedisCache(cacheName, RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(Long.valueOf(expireTime))));
	}
}
