package com.yizhi.application.controller.api;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.constant.ExamConstant;
import com.yizhi.application.constant.MQqueuesEnum;
import com.yizhi.application.constant.PointEventEnum;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.service.*;
import com.yizhi.application.service.impl.StudentExamPaperServiceImpl;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.core.application.publish.CloudEventPublisher;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.exam.application.vo.exam.*;
import com.yizhi.point.application.feign.PointApiFeignClients;
import com.yizhi.point.application.feign.PointListenerClients;
import com.yizhi.point.application.feign.PointRedisFeignClients;
import com.yizhi.point.application.vo.PointParamVO;
import com.yizhi.util.application.constant.QueueConstant;
import com.yizhi.util.application.event.TrainingProjectEvent;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 试卷生成控制器
 *
 * @author mei
 * @Date 2018-03-15
 */
@Slf4j
@RestController
@RequestMapping("/api/exam")
public class ExamQuestionController {

    private static final Logger LOG = LoggerFactory.getLogger(ExamQuestionController.class);

    @Autowired
    private IExamService iExamService;

    @Autowired
    IStudentExamPaperService iStudentExamPaperService;

    @Autowired
    private ITrExamAnswerQuestionService trExamAnswerQuestionService;

    @Autowired
    private ITrExamAnswerQuestionResMaService trExamAnswerQuestionResMaService;

    @Autowired
    private ITrExamAnswerQuestionResService trExamAnswerQuestionResService;

    @Autowired
    private ITrExamAnswerService iTrExamAnswerService;

    @Autowired
    private StudentExamPaperServiceImpl studentExamPaperService;

    @Autowired
    private PointRedisFeignClients pointRedisFeignClients;
/*
    @Autowired
    private AmqpTemplate amqpTemplate;*/

    @Autowired
    private TaskExecutor taskExecutor;

    @Autowired
    private CloudEventPublisher cloudEventPublisher;

    @Autowired
    private RedisCache redisCache;

    @Autowired
    private PointListenerClients pointListenerClients;
    @Autowired
    private PointApiFeignClients pointApiFeignClients;

    /**
     * 根据考试的设置，生成空白答卷（题目、答案选项）
     *
     * @return 返回考生考试试卷
     */
    @PostMapping("/make")
    public StudentExamPaperVO makeExamQuestion(@RequestBody StudentExamPaperVO studentExamPaperVO) {
        try {
            StudentExamPaperVO studentVO = null;

            Long examId = studentExamPaperVO.getExamId();
            Long answerId = studentExamPaperVO.getAnswerId();

            Date createTime = new Date();
            Date curDate = createTime;
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            curDate = formatDate.parse(formatDate.format(curDate));

            //获取考试结束时长
            com.yizhi.exam.application.vo.domain.Exam examInfo = iExamService.getExam(examId);
            if (examInfo == null) {
                studentVO = new StudentExamPaperVO();
                studentVO.setAccountId(studentExamPaperVO.getAccountId());
                studentVO.setQuestions(new ArrayList<QuestionListVO>());
                studentVO.setDuration(0);
                studentVO.setAnswerId(answerId);
                return studentVO;
            }
            Date startTime = examInfo.getStartTime();
            Date endTime = examInfo.getEndTime();
            if (null != startTime) {
                if (System.currentTimeMillis() < startTime.getTime()) {
                    studentVO = new PcStudentExamPaperVo();
                    studentVO.setIsExamAnswerGoOn(ExamConstant.EXAM_NOT_BEGIN);
                    return studentVO;
                }
            }


            //先查找有没有未完成的考试,有继续考试
            TrExamAnswer trExamAnswer = new TrExamAnswer();
            trExamAnswer.setExamId(studentExamPaperVO.getExamId());
            trExamAnswer.setAccountId(studentExamPaperVO.getAccountId());
            trExamAnswer.setState(0);
            EntityWrapper<TrExamAnswer> entityWrapper = new EntityWrapper<>(trExamAnswer);
            List<TrExamAnswer> trExamAnswerList = iTrExamAnswerService.selectList(entityWrapper);
            LOG.info("************************trExamAnswerList" + trExamAnswerList.size());
            if (!CollectionUtils.isEmpty(trExamAnswerList)) {
                ExamPaperVO examPaperVO = new ExamPaperVO();
                examPaperVO.setAnswerId(trExamAnswerList.get(0).getId());
                LOG.info("**********************answerId:" + examPaperVO.getAnswerId());
                examPaperVO.setExamId(examId);
                examPaperVO.setTrainingProjectId(studentExamPaperVO.getTrainingProjectId());
                examPaperVO.setPageNo(studentExamPaperVO.getPageNo());
                examPaperVO.setPageSize(studentExamPaperVO.getPageSize());
                examPaperVO.setAccountId(studentExamPaperVO.getAccountId());
                examPaperVO.setAccountName(studentExamPaperVO.getAccountName());
                examPaperVO.setCompanyId(studentExamPaperVO.getCompanyId());
                examPaperVO.setOrgId(studentExamPaperVO.getOrgId());
                examPaperVO.setSiteId(studentExamPaperVO.getSiteId());
                studentVO = examContinue(examPaperVO);
                studentVO.setIsFinished(0);
                return studentVO;
            }

            //没有未未完成的考试,开始考试,验证是否有考试次数
            if (examInfo.getAnswerNum() != null && examInfo.getAnswerNum() > 0) {
                TrExamAnswer trExamAnswer1 = new TrExamAnswer();
                trExamAnswer1.setExamId(studentExamPaperVO.getExamId());
                trExamAnswer1.setAccountId(studentExamPaperVO.getAccountId());
                EntityWrapper<TrExamAnswer> entityWrapper1 = new EntityWrapper<>(trExamAnswer1);
                List<TrExamAnswer> trExamAnswerList1 = iTrExamAnswerService.selectList(entityWrapper1);
                if (trExamAnswerList1.size() >= examInfo.getAnswerNum()) {
                    studentVO = new PcStudentExamPaperVo();
                    studentVO.setIsExamAnswerGoOn(ExamConstant.EXAM_HAS_NO_TIMES);
                    return studentVO;
                }
            }


            Date endDate = examInfo.getEndTime();
            if (endDate == null) {
                endDate = curDate;
            }
            endDate = formatDate.parse(formatDate.format(endDate));

            //考试剩余时间
            long examCachRestTime = (endDate.getTime() - curDate.getTime()) / 1000;
            //考试时间已结束
            if (examCachRestTime <= 0) {
                LOG.info("考生:" + studentExamPaperVO.getAccountId() + " 名字:" + studentExamPaperVO.getAccountName() + "考试时间结束");
                studentVO = new StudentExamPaperVO();
                studentVO.setAccountId(studentExamPaperVO.getAccountId());
                studentVO.setQuestions(new ArrayList<QuestionListVO>());
                studentVO.setDuration(0);
                studentVO.setAnswerId(answerId);
                return studentVO;
            }

            //查询考试信息
            ExamPaperVO examPaperVO = iStudentExamPaperService.makeExamQuestion(examId, studentExamPaperVO.getCompanyId(),
                    studentExamPaperVO.getOrgId(), studentExamPaperVO.getSiteId(), examCachRestTime);
            if (null == examPaperVO) {
                examPaperVO = new ExamPaperVO();
            }
            LOG.info("*************************************************questions" + examPaperVO.getQuestions().size());
            //考生开始答卷时间
            Date startAnswerDate = null;
            if (answerId == null || answerId == 0) {
                startAnswerDate = curDate;
            } else {
                //获取考试结束时长
                AnswerTimeVO timeVo = iTrExamAnswerService.selectTime(examId, answerId);
                if (timeVo == null) {
                    LOG.info("考生:" + examPaperVO.getAccountId() + " 名字:" + examPaperVO.getAccountName() + "答题时间结束");
                    studentVO = new StudentExamPaperVO();
                    studentVO.setAccountId(studentExamPaperVO.getAccountId());
                    studentVO.setQuestions(new ArrayList<QuestionListVO>());
                    studentVO.setDuration(0);
                    studentVO.setAnswerId(answerId);
                    return studentVO;
                }
                startAnswerDate = timeVo.getStartTime();//答卷的时间
            }

            //考生单次答卷时长，单位分钟（ -1无限制）
            Long durationTime = Long.valueOf(String.valueOf(examInfo.getDuration()));
            Long durationCachTime = null;
            if (durationTime == 0) {
                //单次考试时间无限制，设置单次答题时长标识为-1，缓存时长60分钟
                durationTime = -1L;
                durationCachTime = 3600L;//秒
            } else {
                if ((examCachRestTime / 60) <= durationTime) {
                    durationCachTime = examCachRestTime;
                } else {
                    durationCachTime = (durationTime * 60) - ((curDate.getTime() - startAnswerDate.getTime()) / 1000);
                }
                durationTime = durationCachTime;//秒
                if (durationTime <= 0) {
                    durationTime = 0L;
                }
            }
            if (durationTime == 0) {
                LOG.info("考生:" + studentExamPaperVO.getAccountId() + " 名字:" + studentExamPaperVO.getAccountName() + "答题时间结束");
                studentVO = new StudentExamPaperVO();
                studentVO.setAccountId(studentExamPaperVO.getAccountId());
                studentVO.setQuestions(new ArrayList<QuestionListVO>());
                studentVO.setDuration(0);
                studentVO.setAnswerId(answerId);
                return studentVO;
            }

            Long accountId = studentExamPaperVO.getAccountId();
            if (null != accountId) {
                examPaperVO.setAccountId(studentExamPaperVO.getAccountId());
            }
            if (null != studentExamPaperVO.getAccountName()) {
                examPaperVO.setAccountName(studentExamPaperVO.getAccountName());
            }
            examPaperVO.setOrgId(studentExamPaperVO.getOrgId());
            examPaperVO.setSiteId(studentExamPaperVO.getSiteId());
            examPaperVO.setCompanyId(studentExamPaperVO.getCompanyId());
            examPaperVO.setTrainingProjectId(studentExamPaperVO.getTrainingProjectId());

            //生成试卷
            studentVO = iStudentExamPaperService.makeStudentExam(examPaperVO,
                    studentExamPaperVO.getAccountId(), studentExamPaperVO.getExamId(), durationCachTime, createTime);
            List<QuestionListVO> questions = studentVO.getQuestions();
            LOG.info("********************最终questions" + questions.size());
            List<QuestionListVO> newQuestions = new ArrayList<QuestionListVO>();

            //分页
            Integer pageNo = studentExamPaperVO.getPageNo();
            if (pageNo == null) {
                pageNo = 1;
            }
            Integer pageSize = studentExamPaperVO.getPageSize();
            if (pageSize == null) {
                pageSize = 10;
            }
            int startIndex = (pageNo - 1) * pageSize;
            int endIndex = pageSize + startIndex;
            int total = questions.size();
            endIndex = endIndex > total ? total : endIndex;
            for (; startIndex < endIndex; startIndex++) {
                QuestionListVO questionListVO = questions.get(startIndex);
                //不是问答题,将题目答案去掉
                if (questionListVO.getType() != 4) {
                    if (!CollectionUtils.isEmpty(questionListVO.getQuestionOptions())) {
                        for (QuestionOptionListVO questionOptionListVO : questionListVO.getQuestionOptions()) {
                            questionOptionListVO.setRightAnswer(null);
                        }
                    }
                }
                newQuestions.add(questionListVO);
            }
            studentVO.setQuestions(newQuestions);
            studentVO.setPageNo(pageNo);
            studentVO.setPageSize(pageSize);
            studentVO.setPageTotal(questions.size());

            //设置考生答卷时时间信息
            AnswerTimeVO answerTimeVO = new AnswerTimeVO();
            answerTimeVO.setDuration(durationTime.intValue());
            answerTimeVO.setStartTime(curDate);
            studentVO.setAnswerTimeVO(answerTimeVO);
            studentVO.setDuration(durationTime.intValue());
            //返回答卷ID出去给前端
            studentVO.setAnswerId(studentVO.getAnswerId());

            return studentVO;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * pc端考卷生成,开始考试/继续考试
     *
     * @param studentExamPaperVO
     * @return
     */
    @PostMapping("/pcMake")
    PcStudentExamPaperVo makePcExamQuestion(@RequestBody StudentExamPaperVO studentExamPaperVO) {
        LOG.info("pc端开始考试：入参: {}", JSONObject.toJSONString(studentExamPaperVO));
        Long examId = studentExamPaperVO.getExamId();
        Long answerId = studentExamPaperVO.getAnswerId();
        Long accountId = studentExamPaperVO.getAccountId();
        String accountName = studentExamPaperVO.getAccountName();
        try {
            PcStudentExamPaperVo studentVO = null;
            Date curTime = new Date();
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            curTime = formatDate.parse(formatDate.format(curTime));
            //获取考试结束时长
            com.yizhi.exam.application.vo.domain.Exam examInfo = iExamService.getExam(examId);
            //pointListenerClients.addPoint("CreditCourseDone1", examId);
            //pointApiFeignClients.addPoint(accountId, "point_exam", "" + examId);

            if (examInfo == null) {
                LOG.error("pc端用户accountId = {} ,开始考试: 未查询到考试信息! examId = {}", accountId, examId);
                studentVO = new PcStudentExamPaperVo();
                studentVO.setAccountId(studentExamPaperVO.getAccountId());
                studentVO.setQuestions(new ArrayList<QuestionListVO>());
                studentVO.setDuration(0);
                studentVO.setAnswerId(answerId);
                studentVO.setType("paper");
                return studentVO;
            }

            Date startTime = examInfo.getStartTime();
            Date endTime = examInfo.getEndTime();
            if (null != startTime) {
                if (System.currentTimeMillis() < startTime.getTime()) {
                    studentVO = new PcStudentExamPaperVo();
                    studentVO.setIsExamAnswerGoOn(ExamConstant.EXAM_NOT_BEGIN);
                    return studentVO;
                }
            }

            //考生开始答卷时间
            Date startAnswerTime = null;
            //考试剩余时间
            Long examRestTime = 0L;
            Long examCachTime = 0L;
            ExamDetailsVO examDetails = null;
            //先获得考试须知内容
            examDetails = iExamService.examDetail(examId, accountId);
            if (null == examDetails) {
                LOG.error("pc端开始考试失败: 获取考试详情失败！examId = {} ,accountId = {}", examId, accountId);
                //return
                return null;
            }
            LOG.info("获取到examId = {},accountId= {},考试详情信息如下: {}", examId, accountId, JSONObject.toJSONString(examDetails));

            //没有考试次数了
            if (examDetails.getIsEndExam() == 0) {
                studentVO = new PcStudentExamPaperVo();
                studentVO.setIsExamAnswerGoOn(ExamConstant.EXAM_HAS_NO_TIMES);
                return studentVO;
            }

            Integer pageModel = examInfo.getPageMode();


            //################################继续考试,查出剩余考试时间和缓存时间,考卷信息,答题卡信息


            if (null != answerId && answerId != 0) {


                //验证广场考试是否提交了,没有提交继续考试,提交了提示已经提交了
                TrExamAnswer trExamAnswer = iTrExamAnswerService.selectById(answerId);
                if (trExamAnswer.getState() != 0) {
                    LOG.info("考试答卷已经提交，不能重复提交!examId = {} ,accountId = {}", examId, accountId);
                    studentVO = new PcStudentExamPaperVo();
                    studentVO.setIsExamAnswerGoOn(ExamConstant.EXAM_COMITED);
                    return studentVO;
                }

                //获取考试剩余时间
                AnswerTimeVO timeVo = iTrExamAnswerService.selectTime(examId, answerId);

                if (null != timeVo) {
                    startAnswerTime = timeVo.getStartTime();
                }

                // 考生单次答卷时长，单位分钟（ -1无限制）
                Long durationTime = Long.valueOf(timeVo.getDuration());

                if (durationTime == 0) {
                    // 单次考试时间无限制，设置单次答题时长标识为-1，缓存时长60分钟
                    examRestTime = -1L;
                    examCachTime = 3600L;// 秒
                } else {
                    if (((curTime.getTime() - startAnswerTime.getTime()) / 1000) >= (durationTime * 60)) {
                        LOG.info("考生:" + accountId + " 名字:" + accountName + "答题时间结束");
                        try {
                            studentExamPaperService.clearStudentExam(accountId, examId);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        studentVO = new PcStudentExamPaperVo();
                        studentVO.setAccountId(studentExamPaperVO.getAccountId());
                        studentVO.setQuestions(new ArrayList<QuestionListVO>());
                        studentVO.setDuration(0);
                        studentVO.setAnswerId(answerId);
                        studentVO.setType("paper");
                        return studentVO;
                    } else {
                        examRestTime = (durationTime * 60) - ((curTime.getTime() - startAnswerTime.getTime()) / 1000);
                        if (((examInfo.getEndTime().getTime() - startAnswerTime.getTime()) / 1000 - durationTime * 60) > 0) {
                            examCachTime = examRestTime;
                        } else {
                            examRestTime = (examInfo.getEndTime().getTime() - curTime.getTime()) / 1000;
                            examCachTime = examRestTime;
                        }

                    }
                }


                //获取考生试卷
                StudentExamPaperVO studentExamPaperVo = iStudentExamPaperService.getMakeStudentExam(accountId,
                        examId, answerId, examCachTime);
                if (null == studentExamPaperVo) {
                    LOG.info("考生:" + accountId + " 名字:" + accountName + " 查询不到答卷信息:" + answerId);
                    studentVO = new PcStudentExamPaperVo();
                    studentVO.setAccountId(accountId);
                    studentVO.setAccountName(accountName);
                    studentVO.setQuestions(new ArrayList<QuestionListVO>());
                    studentVO.setDuration(0);
                    studentVO.setAnswerId(answerId);
                    studentVO.setType("paper");
                    return studentVO;
                }

                List<QuestionListVO> questionListVOS = new ArrayList<QuestionListVO>();

                List<CardVO> cardVOS = new ArrayList<CardVO>();
                Integer mark = null;
                if (pageModel == 2) {
                    //只取当前题目
                    QuestionListVO questionListVO = studentExamPaperVo.getQuestions().get(studentExamPaperVO.getPageNo() - 1);
                    Long id = questionListVO.getAnswerQuestionId();

                    //题目标记
                    Map<Long, Map<String, String>> markMap = trExamAnswerQuestionService.selectMark(answerId);

                    //逐题答卷答题卡拆分开来
//                    CardVO cardVO = studentExamPaperVo.getCardVOS().get(questionListVO.getIndex().intValue());
                    mark = Integer.valueOf(String.valueOf(markMap.get(id).get("mark")));
//                    cardVO.setAnswerFlag(questionListVO.getAnswerFlag());
//                    cardVO.setFlag(mark);
//                    cardVO.setRequiredFlag(questionListVO.getRequiredFlag());
                    questionListVO.setFlag(mark);
//                    cardVOS.add(cardVO);

                    // 判断是否是问答题
                    if (questionListVO.getType() == 4) {
                        String answer = trExamAnswerQuestionResMaService.selectAnswer(id, answerId);
                        if (!StringUtils.isBlank(answer)) {
                            questionListVO.setSub(answer);
                            questionListVO.setAnswerFlag(1);
                        } else {
                            questionListVO.setAnswerFlag(0);
                        }
                    } else {
                        List<QuestionOptionListVO> questionOptionListVOS = new ArrayList<QuestionOptionListVO>();
                        // 根据选项来查看数据库中是否有选择过答案的选项
                        for (QuestionOptionListVO questionOptionListVO : questionListVO.getQuestionOptions()) {
                            Integer answer = trExamAnswerQuestionResService.selectAnswer(id, answerId,
                                    questionOptionListVO.getOptionId());
                            if (answer != null && answer == 1) {
                                questionOptionListVO.setAnswer(answer);

                                //标识该题目考生是否已作答了
                                questionListVO.setAnswerFlag(1);
                            }
                            questionOptionListVO.setRightAnswer(null);
                            questionOptionListVOS.add(questionOptionListVO);
                        }
                        questionListVO.setQuestionOptions(questionOptionListVOS);
                    }
                    questionListVOS.add(questionListVO);
                } else {
                    // 遍历所有问题
                    for (QuestionListVO questionListVO : studentExamPaperVo.getQuestions()) {
                        Long id = questionListVO.getAnswerQuestionId();

                        //题目标记
                        Map<Long, Map<String, String>> markMap = trExamAnswerQuestionService.selectMark(answerId);
                        CardVO cardVO = studentExamPaperVo.getCardVOS().get(questionListVO.getIndex().intValue());
                        mark = Integer.valueOf(String.valueOf(markMap.get(id).get("mark")));
                        cardVO.setAnswerFlag(questionListVO.getAnswerFlag());
                        cardVO.setFlag(mark);
                        cardVO.setRequiredFlag(questionListVO.getRequiredFlag());
                        questionListVO.setFlag(mark);
                        cardVOS.add(cardVO);

                        // 判断是否是问答题
                        if (questionListVO.getType() == 4) {
                            String answer = trExamAnswerQuestionResMaService.selectAnswer(id, answerId);
                            if (!StringUtils.isBlank(answer)) {
                                questionListVO.setSub(answer);
                                cardVO.setAnswerFlag(1);
                                questionListVO.setAnswerFlag(1);
                            } else {
                                cardVO.setAnswerFlag(0);
                                questionListVO.setAnswerFlag(0);
                            }
                        } else {
                            List<QuestionOptionListVO> questionOptionListVOS = new ArrayList<QuestionOptionListVO>();
                            // 根据选项来查看数据库中是否有选择过答案的选项
                            for (QuestionOptionListVO questionOptionListVO : questionListVO.getQuestionOptions()) {
                                Integer answer = trExamAnswerQuestionResService.selectAnswer(id, answerId,
                                        questionOptionListVO.getOptionId());
                                if (answer != null && answer == 1) {
                                    questionOptionListVO.setAnswer(answer);

                                    //标识该题目考生是否已作答了
                                    cardVO.setAnswerFlag(1);
                                    questionListVO.setAnswerFlag(1);
                                }
                                questionOptionListVO.setRightAnswer(null);
                                questionOptionListVOS.add(questionOptionListVO);
                            }
                            questionListVO.setQuestionOptions(questionOptionListVOS);
                        }
                        questionListVOS.add(questionListVO);
                    }
                }

//			studentExamPaperVo.setQuestions(questionListVOS);

                // 分页
                List<QuestionListVO> newQuestions = new ArrayList<QuestionListVO>();
                int total = studentExamPaperVo.getQuestions().size();
                Integer pageNo = studentExamPaperVO.getPageNo();
                Integer pageSize = studentExamPaperVO.getPageSize();
                studentVO = new PcStudentExamPaperVo();
                if (examInfo.getPageMode() == 1) {
                    studentVO.setPageMode(1);
                    newQuestions.addAll(questionListVOS);
                } else {
                    studentVO.setPageMode(2);
                    newQuestions.addAll(questionListVOS);
                }


                studentVO.setMakeStrategy(examInfo.getMakeStrategy());
                studentVO.setType("paper");
                studentVO.setPageTotal(total);
                studentVO.setPageNo(pageNo);
                studentVO.setPageSize(pageSize);

                studentVO.setQuestions(newQuestions);
                studentVO.setCardVOS(cardVOS);
                studentVO.setExamDetails(examDetails);
                //获取答卷时时间信息
                studentVO.setAnswerTimeVO(timeVo);
                studentVO.setDuration(examRestTime.intValue());
                studentVO.setAnswerId(answerId);
                studentVO.setQualifiedScore(examInfo.getQualifiedScore());
                studentVO.setQuestionNumber(studentExamPaperVo.getQuestionNumber());
                studentVO.setExamId(examId);
                studentVO.setAccountId(accountId);

                return studentVO;

            } else {

                //############################开始考试,查出剩余考试时间和缓存时间,生成考卷信息
                //先查找有没有未完成的考试,有继续考试
                TrExamAnswer trExamAnswer = new TrExamAnswer();
                trExamAnswer.setExamId(studentExamPaperVO.getExamId());
                trExamAnswer.setAccountId(studentExamPaperVO.getAccountId());
                trExamAnswer.setState(0);
                EntityWrapper<TrExamAnswer> entityWrapper = new EntityWrapper<>(trExamAnswer);
                entityWrapper.orderBy("create_time", false);
                List<TrExamAnswer> trExamAnswerList = iTrExamAnswerService.selectList(entityWrapper);
                if (!CollectionUtils.isEmpty(trExamAnswerList)) {
                    studentExamPaperVO.setAnswerId(trExamAnswerList.get(0).getId());
                    studentVO = makePcExamQuestion(studentExamPaperVO);
                    studentVO.setIsFinished(0);
                    return studentVO;
                }

                if (examInfo.getEndTime().getTime() <= System.currentTimeMillis()) {
                    studentVO = new PcStudentExamPaperVo();
                    return studentVO;
                }


                //没有未未完成的考试,开始考试,验证是否有考试次数
                if (examInfo.getAnswerNum() != null && examInfo.getAnswerNum() > 0) {
                    TrExamAnswer trExamAnswer1 = new TrExamAnswer();
                    trExamAnswer1.setExamId(studentExamPaperVO.getExamId());
                    trExamAnswer1.setAccountId(studentExamPaperVO.getAccountId());
                    EntityWrapper<TrExamAnswer> entityWrapper1 = new EntityWrapper<>(trExamAnswer1);
                    List<TrExamAnswer> trExamAnswerList1 = iTrExamAnswerService.selectList(entityWrapper1);
                    if (trExamAnswerList1.size() >= examInfo.getAnswerNum()) {
                        studentVO = new PcStudentExamPaperVo();
                        studentVO.setIsExamAnswerGoOn(ExamConstant.EXAM_HAS_NO_TIMES);
                        return studentVO;
                    }
                }

                if (examInfo.getDuration() == 0) {
                    //不限时,默认缓存60分钟
                    examRestTime = -1L;
                    examCachTime = 3600L;
                } else {
                    examRestTime = Long.valueOf(examInfo.getDuration() * 60);
                    examCachTime = examRestTime;
                }
                //查询考试信息
                ExamPaperVO examPaperVO = iStudentExamPaperService.makeExamQuestion(examId, studentExamPaperVO.getCompanyId(),
                        studentExamPaperVO.getOrgId(), studentExamPaperVO.getSiteId(), examCachTime);

                if (null == examPaperVO) {
                    examPaperVO = new ExamPaperVO();
                }

                if (null != examPaperVO) {
                    if (null != accountId) {
                        examPaperVO.setAccountId(studentExamPaperVO.getAccountId());
                    }
                    if (null != studentExamPaperVO.getAccountName()) {
                        examPaperVO.setAccountName(studentExamPaperVO.getAccountName());
                    }
                    examPaperVO.setOrgId(studentExamPaperVO.getOrgId());
                    examPaperVO.setSiteId(studentExamPaperVO.getSiteId());
                    examPaperVO.setCompanyId(studentExamPaperVO.getCompanyId());
                    examPaperVO.setTrainingProjectId(studentExamPaperVO.getTrainingProjectId());

                    //生成试卷
                    StudentExamPaperVO studentExamPaperVO1 = iStudentExamPaperService.makeStudentExam(examPaperVO,
                            studentExamPaperVO.getAccountId(), studentExamPaperVO.getExamId(), examCachTime, curTime);
                    studentVO = new PcStudentExamPaperVo();
                    BeanUtils.copyProperties(studentExamPaperVO1, studentVO);
                    List<QuestionListVO> questions = studentVO.getQuestions();
                    List<QuestionListVO> newQuestions = new ArrayList<QuestionListVO>();

                    //答题卡
                    List<CardVO> cardVOS = new ArrayList<>();
                    for (QuestionListVO questionListVO : questions) {
                        CardVO cardVO = new CardVO();
                        cardVO.setRequiredFlag(questionListVO.getRequiredFlag());
                        cardVO.setIndex(Long.valueOf(questions.indexOf(questionListVO)));
                        cardVOS.add(cardVO);
                    }
                    studentVO.setCardVOS(cardVOS);
                    //分页
                    Integer pageNo = studentExamPaperVO.getPageNo();

                    Integer pageSize = studentExamPaperVO.getPageSize();
                    if (examInfo.getPageMode() == 1) {
                        studentVO.setPageMode(1);

                        if (!CollectionUtils.isEmpty(questions)) {
                            for (QuestionListVO questionListVO : questions) {
                                if (questionListVO.getType() != 4) {
                                    for (QuestionOptionListVO questionOptionListVO : questionListVO.getQuestionOptions()) {
                                        questionOptionListVO.setRightAnswer(null);
                                    }
                                }
                            }
                        }

                        newQuestions.addAll(questions);

                    } else {
                        if (null == pageNo) {
                            pageNo = 1;
                        }
                        if (null == pageSize) {
                            pageSize = 1;
                        }
                        int startIndex = (pageNo - 1) * pageSize;
                        int endIndex = pageSize + startIndex;
                        int total = questions.size();
                        endIndex = endIndex > total ? total : endIndex;
                        for (; startIndex < endIndex; startIndex++) {

                            QuestionListVO questionListVO = questions.get(startIndex);

                            if (questionListVO.getType() != 4) {
                                if (!CollectionUtils.isEmpty(questionListVO.getQuestionOptions())) {
                                    for (QuestionOptionListVO questionOptionListVO : questionListVO.getQuestionOptions()) {
                                        questionOptionListVO.setRightAnswer(null);
                                    }
                                }
                            }

                            newQuestions.add(questionListVO);
                        }
                        studentVO.setPageMode(2);
                    }

                    studentVO.setQuestions(newQuestions);
                    studentVO.setPageNo(pageNo);
                    studentVO.setPageSize(pageSize);
                    studentVO.setPageTotal(questions.size());

                    //设置考生答卷时间信息
                    AnswerTimeVO answerTimeVO = new AnswerTimeVO();
                    answerTimeVO.setDuration(examRestTime.intValue());
                    answerTimeVO.setStartTime(curTime);
                    studentVO.setAnswerTimeVO(answerTimeVO);
                    studentVO.setDuration(examRestTime.intValue());
                    studentVO.setExamDetails(examDetails);
                    //返回答卷ID出去给前端
                    studentVO.setType("paper");
                    studentVO.setAnswerId(studentVO.getAnswerId());
                    studentVO.setExamId(examId);
                    studentVO.setAccountId(accountId);

                    studentVO.setMakeStrategy(examInfo.getMakeStrategy());
                }

                return studentVO;
            }


        } catch (Exception e) {
            LOG.error("开始考试异常accountId= {}, examId = {} ,exception = ", accountId, examId, e);
            return null;
        }
    }

    /**
     * pc/微信端学员答卷答题卡
     *
     * @param answerId
     * @return
     */
    @GetMapping("/getMyExamAnswerCards")
    List<CardVO> getMyExamAnswerCards(@RequestParam("answerId") Long answerId) {
        return trExamAnswerQuestionService.getMyExamAnswerCards(answerId);
    }

    /**
     * 获取一场考试剩余考试时间
     *
     * @param vo
     * @return
     */
    @PostMapping("/getRemainderTime")
    Integer getRemainderTime(@RequestBody ExamAnswerVO vo) {
        if (null == vo.getExamId() || null == vo.getAnswerId()) {
            return 0;
        }
        //获取考试结束时长
        AnswerTimeVO timeVo = iTrExamAnswerService.selectTime(vo.getExamId(), vo.getAnswerId());
        Date startTime = timeVo.getStartTime();
        Date endTime = timeVo.getEndTime();
        Integer duration = timeVo.getDuration();
        //不限时
        if (duration == 0) {
            return -1;
        } else {
            //考试还有时间且,该考试没有过期
            Long usedTime = System.currentTimeMillis() - startTime.getTime();
            Long durationTime = Long.valueOf((duration * 60 * 1000));
            if (durationTime > usedTime) {
                //考试没有过期
                if (endTime.getTime() > System.currentTimeMillis()) {
                    Long examRestTime = duration * 60 * 1000 - usedTime;
                    Long endRestTime = endTime.getTime() - System.currentTimeMillis();
                    Long restTime = null;
                    if (examRestTime < endRestTime) {
                        restTime = examRestTime;
                    } else {
                        restTime = endRestTime;
                    }
                    return Math.toIntExact((restTime / 1000));
                } else {
                    //考试已经超时
                    return 0;
                }
            } else {
                //没有时间,考试超时
                return 0;
            }

        }
    }

    /**
     * 根据考试ID，学号查询已有的试卷
     *
     * @return 返回考生考试试卷
     */
    @SuppressWarnings("unused")
    @PostMapping("/continue")
    public StudentExamPaperVO examContinue(@RequestBody ExamPaperVO examPaperVO) {
        Date createDate = new Date();
        try {
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date curDate = formatDate.parse(formatDate.format(createDate));
            Long answerId = examPaperVO.getAnswerId();
            if (null == examPaperVO.getAccountId() || null == examPaperVO.getExamId() || null == examPaperVO.getAnswerId()) {
                LOG.info("继续考生失败:accountId:" + examPaperVO.getAccountId() + " examId:" + examPaperVO.getExamId() + " answerId:" + examPaperVO.getAnswerId());
                StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
                studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
                studentExamPaperVO.setDuration(0);
                studentExamPaperVO.setAnswerId(answerId);
                return studentExamPaperVO;
            }
            if (examPaperVO == null) {
                LOG.info("考生考试信息错误");
                StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
                studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
                studentExamPaperVO.setDuration(0);
                studentExamPaperVO.setAnswerId(answerId);
                return studentExamPaperVO;
            }

            //验证广场考试是否提交了,没有提交继续考试,提交了提示已经提交了
            TrExamAnswer trExamAnswer = iTrExamAnswerService.selectById(answerId);
            if (trExamAnswer.getState() != 0) {
                StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
                studentExamPaperVO.setIsExamAnswerGoOn(ExamConstant.EXAM_COMITED);
                return studentExamPaperVO;
            }

            //获取考试结束时长
            com.yizhi.exam.application.vo.domain.Exam examInfo = iExamService.getExam(examPaperVO.getExamId());
            if (examInfo == null) {
                StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
                studentExamPaperVO.setAccountId(studentExamPaperVO.getAccountId());
                studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
                studentExamPaperVO.setDuration(0);
                studentExamPaperVO.setAnswerId(answerId);
                return studentExamPaperVO;
            }

            Date endDate = examInfo.getEndTime();
            if (endDate == null) {
                endDate = curDate;
            }
            endDate = formatDate.parse(formatDate.format(endDate));

            //考试剩余时间
            long examCachRestTime = (endDate.getTime() - curDate.getTime()) / 1000;
            //考试时间已结束
            if (examCachRestTime <= 0) {
                LOG.info("考生:" + examPaperVO.getAccountId() + " 名字:" + examPaperVO.getAccountName() + "考试时间结束");
                StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
                studentExamPaperVO.setAccountId(studentExamPaperVO.getAccountId());
                studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
                studentExamPaperVO.setDuration(0);
                studentExamPaperVO.setAnswerId(answerId);
                return studentExamPaperVO;
            }

            //获取考试结束时长
            AnswerTimeVO timeVo = iTrExamAnswerService.selectTime(examPaperVO.getExamId(), examPaperVO.getAnswerId());
            if (timeVo == null) {
                LOG.info("考生:" + examPaperVO.getAccountId() + " 名字:" + examPaperVO.getAccountName() + "答题时间结束");
                StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
                studentExamPaperVO.setAccountId(examPaperVO.getAccountId());
                studentExamPaperVO.setAccountName(examPaperVO.getAccountName());
                studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
                studentExamPaperVO.setAnswerId(answerId);
                studentExamPaperVO.setDuration(0);
                return studentExamPaperVO;
            }

            //考生开始答卷时间
            Date startAnswerDate = null;
            if (answerId == null) {
                startAnswerDate = curDate;
            } else {
                startAnswerDate = timeVo.getStartTime();//答卷的时间
            }

            // 考生单次答卷时长，单位分钟（ -1无限制）
            Long durationTime = Long.valueOf(String.valueOf(timeVo.getDuration()));
            Long durationCachTime = null;

            if (durationTime == 0) {
                // 单次考试时间无限制，设置单次答题时长标识为-1，缓存时长60分钟
                durationTime = -1L;
                durationCachTime = 3600L;// 秒
            } else {
				/*Date startDate = formatDate.parse(formatDate.format(timeVo.getStartTime()));
				durationCachTime = (durationTime * 60) - ((curDate.getTime() - startDate.getTime()) / 1000);
				if (durationCachTime <= 0) {
					durationTime = 0L;
					LOG.info("考生:" + examPaperVO.getAccountId() + " 名字:" + examPaperVO.getAccountName() + "答题时间结束");

					//清空考试缓存信息
					try{
						studentExamPaperService.clearStudentExam(examPaperVO.getAccountId(), examPaperVO.getExamId());
					}catch (Exception e){
						e.printStackTrace();
					}
					StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
					studentExamPaperVO.setAccountId(examPaperVO.getAccountId());
					studentExamPaperVO.setAccountName(examPaperVO.getAccountName());
					studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
					studentExamPaperVO.setDuration(0);
					studentExamPaperVO.setAnswerId(examPaperVO.getAnswerId());
					return studentExamPaperVO;
				} else {
					durationTime = durationCachTime / 60;
				}*/
                if ((examCachRestTime / 60) <= durationTime) {
                    durationCachTime = examCachRestTime;
                } else {
                    durationCachTime = (durationTime * 60) - ((curDate.getTime() - startAnswerDate.getTime()) / 1000);
                }

                durationTime = durationCachTime;//秒
                if (durationTime <= 0) {
                    durationTime = 0L;
                }
            }

            if (durationTime == 0) {
                LOG.info("考生:" + examPaperVO.getAccountId() + " 名字:" + examPaperVO.getAccountName() + "答题时间结束");

                //清空考试缓存信息
                try {
                    studentExamPaperService.clearStudentExam(examPaperVO.getAccountId(), examPaperVO.getExamId());
                } catch (Exception e) {
                    e.printStackTrace();
                }
                StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
                studentExamPaperVO.setAccountId(examPaperVO.getAccountId());
                studentExamPaperVO.setAccountName(examPaperVO.getAccountName());
                studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
                studentExamPaperVO.setDuration(0);
                studentExamPaperVO.setAnswerId(answerId);
                return studentExamPaperVO;
            }

            timeVo.setDuration(durationTime.intValue());
            LOG.info("考试答卷ID:{} 当前时间:{} 时间戳:{}", answerId, formatDate.format(curDate), curDate.getTime());
            LOG.info("考生开始考试时间:{} 时间戳:{}", formatDate.format(startAnswerDate), startAnswerDate.getTime());
            LOG.info("考生:{}考试失效时间秒:{}", examPaperVO.getAccountName() + "(" + examPaperVO.getAccountId() + ")", durationCachTime);

            //如果考生试卷
            LOG.info("*********************获取考生试卷answerid:+++++++++++++++++" + examPaperVO.getAnswerId());
            StudentExamPaperVO studentExamPaperVo = iStudentExamPaperService.getMakeStudentExam(examPaperVO.getAccountId(),
                    examPaperVO.getExamId(), examPaperVO.getAnswerId(), durationCachTime);
            if (null == studentExamPaperVo) {
                LOG.info("考生:" + examPaperVO.getAccountId() + " 名字:" + examPaperVO.getAccountName() + " 查询不到答卷信息:" + examPaperVO.getAnswerId());
                StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
                studentExamPaperVO.setAccountId(examPaperVO.getAccountId());
                studentExamPaperVO.setAccountName(examPaperVO.getAccountName());
                studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
                studentExamPaperVO.setDuration(0);
                studentExamPaperVO.setAnswerId(answerId);
                return studentExamPaperVO;
            }

            List<QuestionListVO> questionListVOS = new ArrayList<QuestionListVO>();

            //获取答卷
//            answerId = studentExamPaperVo.getAnswerId();
            LOG.info("(******************获取试卷后anwerid:" + studentExamPaperVo.getAnswerId());
//
            List<CardVO> cardVOS = new ArrayList<CardVO>();
            Integer mark = null;

            Integer pageModel = examInfo.getPageMode();

            if (pageModel == 2) {
                //逐题显示,只获取当前试题

                QuestionListVO questionListVO = studentExamPaperVo.getQuestions().get(examPaperVO.getPageNo() - 1);
                Long id = questionListVO.getAnswerQuestionId();

                //题目标记
                Map<Long, Map<String, String>> markMap = trExamAnswerQuestionService.selectMark(answerId);
                mark = Integer.valueOf(String.valueOf(markMap.get(id).get("mark")));
                questionListVO.setFlag(mark);

                // 判断是否是问答题
                if (questionListVO.getType() == 4) {
                    String answer = trExamAnswerQuestionResMaService.selectAnswer(id, answerId);
                    if (!StringUtils.isBlank(answer)) {
                        questionListVO.setSub(answer);
                        questionListVO.setAnswerFlag(1);
                    } else {
                        questionListVO.setAnswerFlag(0);
                    }
                } else {
                    List<QuestionOptionListVO> questionOptionListVOS = new ArrayList<QuestionOptionListVO>();
                    // 根据选项来查看数据库中是否有选择过答案的选项
                    for (QuestionOptionListVO questionOptionListVO : questionListVO.getQuestionOptions()) {
                        Integer answer = trExamAnswerQuestionResService.selectAnswer(id, answerId,
                                questionOptionListVO.getOptionId());
                        if (answer != null && answer == 1) {
                            questionOptionListVO.setAnswer(answer);

                            //标识该题目考生是否已作答了
                            questionListVO.setAnswerFlag(1);
                        }
                        questionOptionListVO.setRightAnswer(null);
                        questionOptionListVOS.add(questionOptionListVO);
                    }
                    questionListVO.setQuestionOptions(questionOptionListVOS);
                }
                questionListVOS.add(questionListVO);
            } else {
                // 遍历所有问题
                for (QuestionListVO questionListVO : studentExamPaperVo.getQuestions()) {
                    Long id = questionListVO.getAnswerQuestionId();

                    //题目标记
                    Map<Long, Map<String, String>> markMap = trExamAnswerQuestionService.selectMark(answerId);
                    CardVO cardVO = studentExamPaperVo.getCardVOS().get(questionListVO.getIndex().intValue());
                    mark = Integer.valueOf(String.valueOf(markMap.get(id).get("mark")));
                    cardVO.setFlag(mark);
                    questionListVO.setFlag(mark);
                    cardVOS.add(cardVO);

                    // 判断是否是问答题
                    if (questionListVO.getType() == 4) {
                        String answer = trExamAnswerQuestionResMaService.selectAnswer(id, answerId);
                        if (!StringUtils.isBlank(answer)) {
                            questionListVO.setSub(answer);
                            cardVO.setAnswerFlag(1);
                            questionListVO.setAnswerFlag(1);
                        } else {
                            cardVO.setAnswerFlag(0);
                            questionListVO.setAnswerFlag(0);
                        }
                    } else {
                        List<QuestionOptionListVO> questionOptionListVOS = new ArrayList<QuestionOptionListVO>();
                        // 根据选项来查看数据库中是否有选择过答案的选项
                        for (QuestionOptionListVO questionOptionListVO : questionListVO.getQuestionOptions()) {
                            Integer answer = trExamAnswerQuestionResService.selectAnswer(id, answerId,
                                    questionOptionListVO.getOptionId());
                            if (answer != null && answer == 1) {
                                questionOptionListVO.setAnswer(answer);

                                //标识该题目考生是否已作答了
                                cardVO.setAnswerFlag(1);
                                questionListVO.setAnswerFlag(1);
                            }
                            questionOptionListVO.setRightAnswer(null);
                            questionOptionListVOS.add(questionOptionListVO);
                        }
                        questionListVO.setQuestionOptions(questionOptionListVOS);
                    }
                    questionListVOS.add(questionListVO);
                }
            }

            // 分页
            List<QuestionListVO> newQuestions = new ArrayList<QuestionListVO>();

            newQuestions.addAll(questionListVOS);
            studentExamPaperVo.setPageTotal(studentExamPaperVo.getQuestions().size());
            studentExamPaperVo.setPageNo(examPaperVO.getPageNo());
            studentExamPaperVo.setPageSize(examPaperVO.getPageSize());

            studentExamPaperVo.setQuestions(newQuestions);
            studentExamPaperVo.setCardVOS(cardVOS);
            //获取答卷时时间信息
            studentExamPaperVo.setAnswerTimeVO(timeVo);
            studentExamPaperVo.setDuration(timeVo.getDuration());
            studentExamPaperVo.setAnswerId(answerId);

            return studentExamPaperVo;
        } catch (Exception e) {
            e.printStackTrace();

            StudentExamPaperVO studentExamPaperVO = new StudentExamPaperVO();
            studentExamPaperVO.setAccountId(examPaperVO.getAccountId());
            studentExamPaperVO.setQuestions(new ArrayList<QuestionListVO>());
            studentExamPaperVO.setDuration(0);
            studentExamPaperVO.setAnswerId(examPaperVO.getAnswerId());
            return studentExamPaperVO;
        }
    }

    /**
     * 保存考试进展
     */
    @PostMapping("/save")
    public boolean saveExamAnswer(@RequestBody ExamAnswerVO vo) {
        boolean boo = false;
        try {
            if (null == vo.getAccountId() || null == vo.getExamId() || null == vo.getAnswerId()) {
                LOG.info("保存考试进展失败: accountId:" + vo.getAccountId() + " examId:" + vo.getExamId() + " answerId:" + vo.getAnswerId());
                return boo;
            }
            boo = trExamAnswerQuestionService.saveExamAnswer(vo);
            return boo;
        } catch (Exception e) {
            LOG.error("保存考试进展:", e);
            return boo;
        }
    }

    @PostMapping("/submit")
    public ExamResultVO submitExamPage(@RequestBody ExamAnswerVO vo) {
        ExamResultVO result = null;
        try {
            if (null == vo.getAccountId() || null == vo.getExamId() || null == vo.getAnswerId()) {
                LOG.info("交卷失败:accountId:" + vo.getAccountId() + " examId:" + vo.getExamId() + " answerId:" + vo.getAnswerId());
                return result;
            }
            result = trExamAnswerQuestionService.submitExamPage(vo);
            log.info("提交考试结果submit返回:{}", JSONUtil.toJsonStr(result));
            //考试交卷后根据分数增加积分
            if(result.getScore().intValue() >= result.getScoreSuccess().intValue()) {
                log.info("考试合格发放积分:{}", JSONUtil.toJsonStr(result));
                pointApiFeignClients.addPoint(vo.getAccountId(), "point_exam", "" + result.getExamId() + "|" + result.getScore());
            }
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            LOG.error("交卷异常:accountId{} examId{} answerId{} exception{}",
                    vo.getAccountId(), vo.getExamId(), vo.getAnswerId(), e);
            return null;
        }
    }

    @PostMapping("/mark")
    public boolean mark(@RequestBody ExamAnswerVO examAnswerVO) {
        return trExamAnswerQuestionService.mark(examAnswerVO);
    }

    @PostMapping("/history")
    public List<ExamHistoryVO> selectHistory(@RequestParam("examId") Long examId, @RequestParam("accountId") Long accountId) {
        return iTrExamAnswerService.selectHistorys(examId, accountId);
    }

    @PostMapping("/lose/submit")
    public ExamResultVO submitExamLose(@RequestBody ExamAnswerVO vo) {
        ExamResultVO result = null;
        try {
            if (null == vo.getAccountId() || null == vo.getAnswerId()) {
                LOG.info("考试时间失效交卷失败:accountId:" + vo.getAccountId() + " examId:" + vo.getExamId() + " answerId:" + vo.getAnswerId());
                return result;
            }
            result = trExamAnswerQuestionService.submitExamLose(vo);
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            LOG.error("考试时间失效交卷", e);
            return result;
        }
    }

    /**
     * 任务调度提交考试失效的考试信息
     */
    @PostMapping("/job/lose/submit")
    public void jobSubmitExamLose(@RequestBody ExamAnswerVO answerVo) {
        LOG.info("开始执行答卷自动提交定时任务");

        Long companyId = answerVo.getCompanyId();
        List<TrExamAnswer> examAnswers = iTrExamAnswerService.getUnSubmitExam(companyId);
        if (examAnswers == null || examAnswers.isEmpty()) {
            LOG.info("未查询到未交卷信息");
            return;
        }

        Date curDate = new Date();
        try {
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            curDate = formatDate.parse(formatDate.format(curDate));
        } catch (ParseException e1) {
            LOG.info("考试自动提交任务-转换时间错误");
            return;
        }

        Long durationTime = null;
        Long durationCachTime = null;
        ExamAnswerVO vo = new ExamAnswerVO();
        boolean isExamEnd = false;
        Long answerId = null;
        String redisKey = "jobSubmitExamLose";
        try {
            //添加分布式锁：考试服务分布式部署时防止多个服务去处理相同是业务，需要等这个跑批任务处理完了，才允许下个定时任务处理
            Boolean redisResult = redisCache.setIfAbsent(redisKey, "1");
            if (redisResult) {
                for (TrExamAnswer examInfo : examAnswers) {
                    isExamEnd = false;
                    //有效时间为空不处理
                    if (examInfo.getDuration() == null) {
                        continue;
                    }
                    durationTime = Long.valueOf(String.valueOf(examInfo.getDuration()));

                    answerId = examInfo.getId();

                    //判断考试是否超时
                    Date endDate = examInfo.getSubmitTime();
                    if (endDate == null) {
                        endDate = curDate;
                    }
                    try {
                        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        endDate = formatDate.parse(formatDate.format(endDate));
                    } catch (ParseException e) {
                        LOG.info("考试:{},自动提交任务-转换时间错误", answerId);
                        continue;
                    }
                    if (curDate.after(endDate)) {
                        //考试过期,已结束
                        isExamEnd = true;
                    } else {
                        //考试没结束,不限时
                        if (durationTime == 0) {
                            continue;
                        }
                        //考试剩余时间
                        long examCachRestTime = (endDate.getTime() - curDate.getTime()) / 1000;
                        //考试时间已结束
                        if (examCachRestTime <= 0) {
                            isExamEnd = true;
                        } else {
                            durationCachTime = (durationTime * 60) - ((curDate.getTime() - examInfo.getStartTime().getTime()) / 1000);
                            if (durationCachTime <= 0) {
                                isExamEnd = true;
                            }
                        }
                    }

                    if (isExamEnd) {
                        LOG.info("答卷:{}超时，自动提交开始", answerId);
                        vo.setAccountId(examInfo.getAccountId());
                        vo.setAccountName(examInfo.getCreateByName());
                        vo.setCompanyId(examInfo.getCompanyId());
                        vo.setOrgId(examInfo.getOrgId());
                        vo.setSiteId(examInfo.getSiteId());
                        vo.setAnswerId(examInfo.getId());
                        ExamResultVO result = null;
                        try {
                            result = trExamAnswerQuestionService.submitExamLose(vo);
                            if (null != result) {
                                vo.setExamId(result.getExamId());
                            }
                        } catch (Exception e) {
                            //e.printStackTrace();
                            LOG.error("答卷:{}超时，自动提交出现异常.", answerId, e);
                        }

                        if (null != result) {
                            LOG.info("答卷:{}超时，自动提交完成", answerId);

                            Date time = new Date();
                            //考试交卷后积分发放
                            try {
                                Integer point = result.getPoint();
                                if (result.getIsres() == 0) {
                                    PointParamVO pointParamVO = new PointParamVO();
                                    pointParamVO.setEventName(PointEventEnum.POINTEXAM.getKey());    //事件名称
                                    pointParamVO.setActivityType("考试通过积分发放");                //事件类型
                                    pointParamVO.setActivitySource("考试");                            //学习活动来源
                                    pointParamVO.setActivityName(result.getExamName());                //学习活动名称
                                    pointParamVO.setReleaseCondition("范围发放");                    //发放条件
                                    pointParamVO.setReleaseRules("按照范围取积分");                    //发放规则
                                    pointParamVO.setCreatePointTime(time);                            //积分创建时间
                                    pointParamVO.setSourceId(vo.getExamId());                        //积分来源ID，（业务ID主键）
                                    pointParamVO.setOperatingPoint(result.getPoint());                //积分数量，  正数 加积分，  负数减积分
                                    pointParamVO.setAccountId(result.getAccountId());        //学员ID
                                    pointParamVO.setCompanyId(result.getCompanyId());        //企业ID
                                    pointParamVO.setSiteId(result.getSiteId());                //站点ID
                                    pointParamVO.setOrgId(result.getOrgId());                //组织ID
//	                    pointParamVO.setScore(Integer.valueOf(String.valueOf(result.getScore())));
                                    pointParamVO.setScore(result.getScore().intValue());
                                    String sitePointId = null;
                                    if (null != point && point > 0) {
                                        sitePointId = pointRedisFeignClients.addPointRedis(pointParamVO);//调用积分接口添加积分
                                    }
                                    String sitePointId1 = pointRedisFeignClients.addPointRedis(pointParamVO);    //调用积分接口添加积分
                                    if (null != sitePointId) {
                                        //amqpTemplate.convertAndSend(MQqueuesEnum.EXAM.getKey(), sitePointId);    //发送积分获取消息
                                    }
                                    if (null != sitePointId1) {
                                       // amqpTemplate.convertAndSend(MQqueuesEnum.EXPERIENCEEXAM.getKey(), sitePointId1);    //发送经验获取消息
                                    }
                                }
                            } catch (Exception e) {
                                LOG.error("student交卷exam积分发放失败：", e);
                            }

                            // 考试提交，向培训项目发送消息，告知业务已经完成
                            try {
                                boolean isFinished = false;
                                //如果没有主观题,判断是否合格
                                if (result.getIsres() == 0 && result.getScore() != null
                                        && result.getScoreSuccess() != null) {
                                    if (result.getScore().compareTo(new BigDecimal(result.getScoreSuccess())) != -1) {
                                        isFinished = true;
                                    }
                                }

                                LOG.info("发送考试:(" + vo.getExamId() + ") 合格信息到trainingProject");
                                Float value = null;
                                if (result.getIsres() == 0) {
                                    value = result.getScore().floatValue();
                                }

                                Long accountId = result.getAccountId();
                                Long siteId = result.getSiteId();
                                boolean finalIsFinished = isFinished;
                                Float finalValue = value;
                                taskExecutor.asynExecute(new AbstractTaskHandler() {
                                    @Override
                                    public void handle() {
                                        try {
                                            cloudEventPublisher.publish(QueueConstant.TRAINING_PROJECT_EVENT_QUEUE,
                                                    new EventWrapper<TrainingProjectEvent>(vo.getExamId(),
                                                            TrainingProjectEvent.getInstance(vo.getExamId(), ExamConstant.EXAM_TRANINNING_TYPE,
                                                                    accountId, time,
                                                                    siteId, finalValue, finalIsFinished)));
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            LOG.error("发送考试:(" + vo.getExamId() + ") 合格信息到trainingProject异常：", e);
                                        }
                                    }
                                });
                            } catch (Exception e) {
                                LOG.error("student交卷，给trainingProject发送消息失败：", e);
                            }
                        } else {
                            LOG.error("答卷:{}超时，自动提交失败", answerId);
                        }
                    }
                }

                //删除分布式锁
                redisCache.delete(redisKey);

            } else {
                LOG.info("答卷自动提交上个定时任务还未处理完，暂停执行本次定时任务");
            }

        } catch (Exception e) {
            e.printStackTrace();
            LOG.info("答卷:{}超时，自动提交错误", answerId);
            //删除分布式锁
            redisCache.delete(redisKey);
        }
    }
}
