package com.yizhi.application.controller.api;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.exam.application.vo.MyExamParameterVO;
import com.yizhi.exam.application.vo.exam.MyExamPageVO;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.yizhi.exam.application.vo.MyExamVO;
import com.yizhi.application.service.IExamService;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;

@RestController
@RequestMapping("/api/exam")
public class MyExamController {
    private static final Logger LOG = LoggerFactory.getLogger(MyExamController.class);
    @Autowired
    private IExamService iExamService;

    /**
     * 我的考试
     *
     * @param myExamParameterVO
     * @return
     */
    @PostMapping("/list")
    public MyExamPageVO getMyExamList(@RequestBody MyExamParameterVO myExamParameterVO) {
        try {
            MyExamPageVO myExamPageVO = new MyExamPageVO();
            /*Map<String,Integer> page=new HashMap<String,Integer>();
            page.put("pageSize",myExamParameterVO.getPageSize());
            page.put("pageNo",myExamParameterVO.getPageNo());*/
            List<MyExamVO> myExamVOS = iExamService.MyExam(myExamParameterVO);
       /*     page.put("pageTotal",iExamService.selectTotal(myExamParameterVO));
            map.put("list",myExamVOS);
            map.put("page",page);*/
            myExamPageVO.setExamVOS(myExamVOS);
            myExamPageVO.setPageTotal(iExamService.selectTotal(myExamParameterVO));
            return myExamPageVO;
        } catch (Exception e) {
            LOG.error("", e);
            e.printStackTrace();
            return null;
        }

    }

    /**
     * pc端我的考试列表
     *
     * @param myExamParameterVO
     * @return
     */
    @PostMapping("/pcList")
    public MyExamPageVO getMyPcExamList(@RequestBody MyExamParameterVO myExamParameterVO) {

        return iExamService.MyPcExam(myExamParameterVO);
    }

    /**
     * 我的考试搜索
     *
     * @param keyWord
     * @param pageNo
     * @param pageSize
     * @param accountId
     * @return
     */
    @GetMapping("/search")
    public MyExamPageVO searchMyExamInfo(@RequestParam(value = "keyWord", required = false) String keyWord, @RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize,
                                         @RequestParam("accountId") Long accountId, @RequestParam("siteId") Long siteId, @RequestParam("ids") List<Long> ids) {
        try {
            if (!StringUtils.isBlank(keyWord)) {
                keyWord = URLDecoder.decode(keyWord, "UTF-8");
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        MyExamPageVO myExamPageVO = new MyExamPageVO();
        Page<MyExamVO> page = iExamService.searchMyExamInfo(pageNo, pageSize, ids, accountId, siteId, keyWord);
        myExamPageVO.setExamVOS(page.getRecords());
        myExamPageVO.setPageTotal(page.getTotal());
        return myExamPageVO;
    }

    @GetMapping("/finishedIds")
    List<Long> getMyFinishedIds(@RequestParam("accountId") Long accountId,
                                @RequestParam("siteId") Long siteId,
                                @RequestParam("examIds") List<Long> examIds) {
        return iExamService.getMyFinishedIds(accountId, siteId, examIds);
    }
}
