package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 题库
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("question_library")
public class QuestionLibrary extends Model<QuestionLibrary> {

	private static final long serialVersionUID = 1L;

	
	private Long id;

	
	@TableField("library_no")
	private String libraryNo;

	
	private String name;

	
	@TableField("library_label")
	private String libraryLabel;


	@TableField("library_type")
	@ApiModelProperty("题库类型：1-测试，2-问卷，3-投票")
	private Integer libraryType;

	
	private Integer state;

	
	private String comments;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	
	@TableField("company_id")
	private Long companyId;

	
	@TableField("org_id")
	private Long orgId;

	
	@TableField("site_id")
	private Long siteId;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
