package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.TrExamQuestion;
import com.yizhi.application.domain.TrQuestionLibrarySubject;
import com.yizhi.exam.application.vo.LibrarySubjectVO;
import com.yizhi.exam.application.vo.SelectQuestionVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 题目 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface TrQuestionLibrarySubjectMapper extends BaseMapper<TrQuestionLibrarySubject> {

	List<SelectQuestionVO> listExamQuestion(Page<SelectQuestionVO> page, Map<String, Object> map);
	List<TrQuestionLibrarySubject> selectQuestionByLibrarySubjectId(List<TrExamQuestion> trExamQuestions);

	List<LibrarySubjectVO> selectLibrarySubjectList(@Param("libraryKey") String libraryKey,@Param("stemKey") String stemKey,@Param("type") Integer type,@Param("pageNo") Integer pageNo,@Param("pageSize") Integer pageSize,@Param("companyId") Long companyId,@Param("siteId") Long siteId,@Param("orgIds") List<Long> orgIds,@Param("examId") Long examId,@Param("libraryId") Long libraryId);

	Integer selectLibrarySubjectCount(@Param("libraryId")Long libraryId,@Param("libraryKey") String libraryKey,@Param("stemKey") String stemKey,@Param("type") Integer type,@Param("companyId") Long companyId,@Param("siteId") Long siteId,@Param("orgIds") List<Long> orgIds,@Param("examId") Long examId);

	List<TrQuestionLibrarySubject> selectLibrarySubjects(@Param("libraryId") Long libraryId,@Param("stem") String stem,@Param("type") Integer type,@Param("start") Integer start,@Param("end") Integer end);
	Integer selectLibrarySubjectsCount(@Param("libraryId") Long libraryId,@Param("type") Integer type,@Param("stem") String stem);

	Integer selectIsUser(@Param("id")Long id);

}