package com.yizhi.application.service;


import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.Exam;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.domain.TrExamPoint;
import com.yizhi.exam.application.vo.exam.ExamDetailsVO;
import com.yizhi.exam.application.vo.exam.*;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface IExamService extends IService<Exam> {
	/**
	 * 显示考试列表
	 * @param name
	 * @param state
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	Page<com.yizhi.exam.application.vo.domain.Exam> examList(String currentTime , String name, Integer state, Integer pageSize, Integer pageNo, Long companyId, Long siteId, List<Long> orgIds);


	/**
	 * 考试列表的条数
	 * @param name
	 * @param state
	 * @return
	 */
	Integer sumNum(String currentTime ,String name,Integer state,Long companyId,Long siteId,List<Long> orgIds);


	/**
	 * 显示阅卷列表
	 * @param name
	 * @param state
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	List<com.yizhi.exam.application.vo.domain.Exam> examMarkingList(ContextAndPageSizeVO contextAndPageSizeVO);

	/**
	 * 阅卷列表的总记录数目
	 */
	Integer getMarkingListNum(String name);

	/**
	 * 考试批量删除
	 * @param idList
	 * @return
	 */
	boolean deleteExam(Long[] id);

	/**
	 * 考试上架
	 * @param id
	 * @return
	 */
	boolean examPutUp(Long id);

	/**
	 * 考试下架
	 * @param id
	 * @return
	 */
	boolean examPutDown(Long examId);

	/**
	 * 导出答卷
	 * @param examId
	 * @return
	 */
	List exportAnswer(Long examId);

	/**
	 * 根据考试id，获得考试对象
	 * @param examId
	 * @return
	 */
	com.yizhi.exam.application.vo.domain.Exam getExam(Long examId);

	/**
	 * 添加 /修改考试 基本信息
	 */
	Long insertOrUpdateBaseInfo(BaseInfoVO vo);

	/**
	 * 复制考试
	 */
	boolean copyExamAndView(com.yizhi.exam.application.vo.domain.Exam examVo);

	/**
	 * 添加试题  修改
	 * @param vo
	 * @return
	 */
	Long updateExamQuestion(AddQuestionVO vo);

	/**
	 * 创建考试-考试策略  修改
	 * @param examId
	 * @return
	 */
	ExamStrategyVO listExamStrategy(Long examId);

	/**
	 * 添加策略  修改
	 * @param vo
	 * @return
	 */
	Long updateOrPreviewExamStrategy(ExamStrategyVO vo);

	/**
	 * 发布考试
	 * @param examVo
	 * @return
	 */
	Long releaseExamRelated(ExamStrategyVO vo);

	/**
	 * 获得考试试题类型
	 * @param examId
	 * @return
	 */
	List<ExamQuestionTypeVO> selectType(Long examId);

	/**
	 * 获得我的考试
	 * @param accountId
	 * @param
	 * @return
	 */
	List<MyExamVO> MyExam(MyExamParameterVO myExamParameterVO);

	/**
	 * 得到exam
	 * @param examId
	 * @return
	 */
	com.yizhi.exam.application.vo.domain.Exam getExamByExamId(Long examId);

	/**
	 * 导入考试试题
	 * @param fileDir
	 * @param fileName
	 * @param id
	 * @return
	 */
	Boolean importExamFile(String fileDir, String fileName, Long id);

	/**
	 * 考试详情页，学员端
	 * @param examId
	 * @return
	 */
	ExamDetailsVO examDetail(Long examId,Long accountId);

    Integer selectTotal(MyExamParameterVO myExamParameterVO);

    List<MyExamVO> selectMyExamnation(Integer pageNo, Integer pageSize,Long accountId);

    Integer selectAll(Long accountId);

    /**
	 * 考试统计列表
	 * @param name
	 * @return
	 */
	List<com.yizhi.exam.application.vo.domain.Exam> selectExamList(String name, Long companyId);

	Integer selectCountByAccountId(Long accountId);

	/**
	 * 修改试题排序
	 * */
	boolean updateQuestionSort(QuestionSortVO questionSortVO);

	/**
	 * 获取考试所有信息
	 * */
	ExamView selectExam(Long id);

	/**
     * 首页搜索考试信息
     * @param keyWord 查询关键字
     * @param pageNo 页码
     * @param pageSize 每页页数
     * @param accountId 员工号
     * @param companyId 企业号
     * @param siteId 站点ID
     * @param orgId 组织
     * @return
     */
	Page<com.yizhi.exam.application.vo.domain.Exam> selectExamLikeName(String keyWord, Integer pageNo, Integer pageSize, Long accountId, Long companyId, Long siteId, Long orgId);

	/**
     * 获取考试信积分信息
     * @param examId 考试号
     * @param companyId 企业号
     * @param siteId 站点ID
     * @param orgId 组织
     * @return
     */
	List<TrExamPoint> selectExamPointInfo(Long examId, Long companyId, Long siteId, Long orgId);

	/**
	 * 根据考试名称查询考试列表
	 * */
	List<com.yizhi.exam.application.vo.domain.Exam> selectExamListByName(ContextAndPageSizeVO contextAndPageSizeVO);

	ExamDetailsMarkingVO selectExamListBySta(ContextAndPageSizeVO contextAndPageSizeVO);

	/**
	 * 根据考试名称关键字查询总数
	 * */
	int selectExamListByNameCount(ContextAndPageSizeVO contextAndPageSizeVO);

	/**
	 * 效验考试名称是否存在
	 * */
	boolean nameIsExist(String name);

	/**
	 * 根据企业ID 部门ID  站点ID获取考试列表
	 * */
	List<com.yizhi.exam.application.vo.domain.Exam> selectExamByContext(Long companyId, Long orgId, Long siteId, String name);

	/**
	 * 按考试统计考试信息列表查询
	 * */
	List<com.yizhi.exam.application.vo.domain.Exam> selectExamListByNameExport(String name, Long companyId);

	/**
	 * 按用户统计
	 */
	Page<StatisticalByUserVO> examByUser(ExamCountByUserVO vo);


	List<com.yizhi.exam.application.vo.domain.Exam> selectExamByName(ExamCountExportParamVO vo);


	List<StatisticalByUserVO> examAnswerByExamId(ExamCountByUserVO ecvo);

	/**
	 * 查询我的考试没提交的
	 * @param companyId
	 * @param siteId
	 * @param accountId
	 * @return
	 */
	Integer selectMyExamNoSubmit(Long accountId);

	/**
	 * 根据项目ID得到exam
	 * @param examId
	 * @return
	 */
	com.yizhi.exam.application.vo.domain.Exam getExamByProjectId(Long projectId);

	/**
	 * 获取自己可见范围的考试
	 * @param ids
	 * @param siteId
	 * @return
	 */
	List<Long> getMyVisableExam(List<Long> ids, Long siteId);

	/**
	 * 我的考试搜索
	 * @param pageNo
	 * @param PageSize
	 * @param ids
	 * @param accountId
	 * @param keyWord
	 * @return
	 */
	Page<MyExamVO> searchMyExamInfo(int pageNo, int pageSize, List<Long> ids, Long accountId,
			Long siteId, String keyWord);


	String checkScore(Long examId);



	/**
	 * 范围人员导出             管理端-------2018/09/19
	 * @param assignmentId
	 * @return
	 */
	public VisibleRangeExport vsibleRangeExport(Long examId);

	Page<Map<String,Object>> getPoolExamList(String name, List<Long> ids, Integer pageNo, Integer pageSize);



	List<Map<String, Object>> getServerByCompanyIdAndIds(Long companyId,List<Long> ids);

	MyExamPageVO MyPcExam(MyExamParameterVO myExamParameterVO);

    List<Long> getMyFinishedIds(Long accountId, Long siteId, List<Long> examIds);

	/**
	 * 胡涛需要,获得所有考试最小积分和最大积分之和
	 * @param examIds
	 * @return
	 */
	Map<String, Integer> getMinAndMaxPointSum(List<Long> examIds);

	/**
	 * 胡涛需要,查找七内结束的考试
	 * @return
	 */
    List<com.yizhi.exam.application.vo.domain.Exam> getExpireList();

    Page<ExamCalendarVO> getPageToCalendar(Date date, Page<com.yizhi.exam.application.vo.domain.Exam> page);

	/**
	 * 查找多门考试,该考生
	 * @param examIds
	 * @return
	 */
	Map<Long, Map<String, Object>> getMaxScores(List<Long> examIds);

    Page<DroolsVo> getPageByDrools(String field, String value, Page<DroolsVo> page);
}
