package com.yizhi.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamAuthorize;
import com.yizhi.exam.application.vo.TrExamAuthorizeVO;

import java.util.List;

/**
 * <p>
 * 考试人员范围 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrExamAuthorizeService extends IService<TrExamAuthorize> {

	/**
	 * 考试人员id
	 * @return
	 */
	Integer getShouldExamNum(Long examId);


	
	/*
	 * 根据考试查看考试人员id列表
	 */
	Page<TrExamAuthorize> listId(Long examId,Integer pageSize,Integer pageNo);
	
	/*
	 * 应该提交的考试  考试人员范围
	 * @param examId
	 * @return
	 */
	List<Long> examIdList(Long examId);
	
	/*
	 * 新建
	 * @param trExamAuthorizeVoList
	 * @param examId
	 * @return
	 */
	boolean updateTrExamAuthorizeList(List<TrExamAuthorizeVO> trExamAuthorizeVoList, Long examId);

	/**
	 * 复制
	 * @param oldExamId
	 * @param examId
	 * @return
	 */
	boolean copyTrExamAuthorize(Long oldExamId, Long examId);

	/**
	 * 考试人员范围 list
	 * @param examId
	 * @return
	 */
	List<TrExamAuthorizeVO> listTrExamAuthorize(Long examId);

	/**
	 * 创建考试人员范围
	 * */
	Boolean insertAllAuthorize(List<TrExamAuthorizeVO> trExamAuthorizeVOS,Long accountId,String accountName,Long siteId);

	/**
	 * 根据考试ID查询考试人员范围列表
	 * */
	List<TrExamAuthorize> examCount(Long examId);

	/**
	 * 添加所有考试人员范围
	 * */
	boolean insertAll(List<TrExamAuthorize> trExamAuthorizes);
}
