package com.yizhi.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamQuestion;
import com.yizhi.exam.application.vo.ExamQuestionLibraryVO;
import com.yizhi.exam.application.vo.ExamQuestionVO;
import com.yizhi.exam.application.vo.QuestionPreview;
import com.yizhi.exam.application.vo.exam.ExamQuestionListVO;
import com.yizhi.exam.application.vo.exam.SortVO;

import java.util.List;

/**
 * <p>
 * 考试题目 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrExamQuestionService extends IService<TrExamQuestion> {
    /**
     * 根据考试Id，找到题目对象集合。
     * @param ExamId
     * @return
     */
    Page<TrExamQuestion> selectExamQuestionById(Long ExamId, Integer pageNo, Integer pageSize);

    public boolean insertExamQuestionService(ExamQuestionVO examQuestionVO) throws Exception;

    /**
	 * copy 考试题目, 返回
	 * @param examId
	 * @return
	 */
	boolean copyExamQuestion(Long oldId, Long examId,String accountName,Long accountId);
	
	/**
	 * 修改考试题目
	 * @param examQuestionVoList
	 * @param examId
	 * @return
	 */
	boolean updateTrExamQuestionList(List<ExamQuestionVO> examQuestionVoList, Long examId,String accountName,Long accountId);
	
	/**
     * 试题预览
     * @param examTitleId
     * @return
     */
	QuestionPreview examPreview(Long examTitleId);
	
	/**
     * 根据考试Id，找到题目对象集合。
     * @param ExamId
     * @return
     */
	List<ExamQuestionLibraryVO> selectExamQuestionListById(Long ExamId, Integer pageNo, Integer pageSize);
    
    public Integer sumNum(Long examId);


    /**
    * 根据考试题目ID修改分数
    * */
	boolean updateScoreById(ExamQuestionVO examQuestionVO);


	/**
	 * 对试题进行上移下移排序
	 * */
	boolean move(List<SortVO> sortVOS);

	boolean insertQuestion(ExamQuestionListVO examQuestionListVO);

	/**
	 * 批量删除考试题目
	 * */
	Integer deleteById(List<Long> id);

	/**
	 * 查询该考试是否拥有试题
	 * */
	Integer selectQuestionCountByExamId(Long examId);

	/**
	 * 批量新增考试试题
	 * */
	boolean insertAll(List<TrExamQuestion> trExamQuestions);

	/**
	 * 增加考试题目
	 * */
	Long insertOne(TrExamQuestion trExamQuestion);

	Integer deleteByExamId(Long examId);

	Integer updateExamQuestion(ExamQuestionVO vo);

	Integer updateByExamId(Long examId);
}
