package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.mapper.StatisticsExamMetadataMapper;
import com.yizhi.application.service.IStatisticsExamMetadataService;
import com.yizhi.application.domain.StatisticsExamMetadata;
import com.yizhi.exam.application.vo.domain.StatisticsExamLearnMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试报表统计实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class StatisticsExamMetadataServiceImpl extends ServiceImpl<StatisticsExamMetadataMapper, StatisticsExamMetadata>
		implements IStatisticsExamMetadataService {
	
	@Autowired
	private StatisticsExamMetadataMapper statisticsExamMetadataMapper;

	@Override
	public List<StatisticsExamLearnMetadata> insertAccountLearn(Long examId, String curDate) {
		int count = statisticsExamMetadataMapper.insertAccountLearn(examId, curDate);
		if(count == 0){
			return null;
		}
		
		return statisticsExamMetadataMapper.selectAccountLearn(examId, curDate);
	}

	@Override
	public Page<Long> selectAccountLearnList(Map<String, Object> paramMap, int pageNo, int pageSize) {
		Page<Long> page = new Page<Long>(pageNo, pageSize);
		List<Long> ids = statisticsExamMetadataMapper.selectAccountLearnList(paramMap, page);
		page.setRecords(ids);
		return page;
	}

}
