package com.yizhi.application.service.impl;

import com.yizhi.application.domain.TrExamAnswerQuestionRes;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.mapper.TrExamAnswerQuestionResMapper;
import com.yizhi.application.service.ITrExamAnswerQuestionResService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 客观题答案选项（单选题，多选题，判断题） 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamAnswerQuestionResServiceImpl extends
		ServiceImpl<TrExamAnswerQuestionResMapper, TrExamAnswerQuestionRes> implements ITrExamAnswerQuestionResService {

	@Autowired
	TrExamAnswerQuestionResMapper trExamAnswerQuestionResMapper;

	@Override
	public void setInsertCloumn(TrExamAnswerQuestionRes res) {
		Long accountId = 9999L;
		String accountName = "bob";
		RequestContext requestContext = ContextHolder.get();
		if (null != requestContext) {
			if (null != requestContext.getAccountId()) {
				accountId = requestContext.getAccountId();
			}
			if (null != requestContext.getAccountName()) {
				accountName = requestContext.getAccountName();
			}
		}
		
		res.setCreateById(accountId);
		res.setCreateByName(accountName);
		res.setCreateTime(new Date());
		res.setUpdateById(accountId);
		res.setUpdateByName(accountName);
		res.setUpdateTime(new Date());
	}

	@Override
	public Integer selectAnswer(Long id, Long answerId,Long optionId) {
		return trExamAnswerQuestionResMapper.selectAnswer(id,answerId,optionId);
	}

	@Override
	public List<TrExamAnswerQuestionRes> selectAnswerQuestionOptionByAnswerIdAndQuestionId(Long answerId,
			Long questionId) {
		return trExamAnswerQuestionResMapper.selectAnswerQuestionOptionByAnswerIdAndQuestionId(answerId, questionId);
	}
}
