package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.TrExamQuestion;
import com.yizhi.application.domain.TrQuestionLibrarySubject;
import com.yizhi.application.domain.TrQuestionSubjectOption;
import com.yizhi.application.mapper.ExamMapper;
import com.yizhi.application.mapper.TrQuestionLibrarySubjectMapper;
import com.yizhi.application.mapper.TrQuestionSubjectOptionMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrQuestionLibrarySubjectService;
import com.yizhi.application.service.ITrQuestionSubjectOptionService;
import com.yizhi.exam.application.vo.*;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>
 * 题目 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Transactional(propagation = Propagation.REQUIRED)
@Service
public class TrQuestionLibrarySubjectServiceImpl
        extends ServiceImpl<TrQuestionLibrarySubjectMapper, TrQuestionLibrarySubject>
        implements ITrQuestionLibrarySubjectService {

    @Autowired
    private TrQuestionLibrarySubjectMapper trQuestionLibrarySubjectMapper;

    @Autowired
    private TrQuestionSubjectOptionMapper trQuestionSubjectOptionMapper;

    @Autowired
    private ExamMapper examMapper;
    @Autowired
    ITrQuestionSubjectOptionService trQuestionSubjectOptionService;

    @Autowired
    IdGenerator idGenerator;

    public TrQuestionLibrarySubject selectQuestionById(Long QuestionId) {
        TrQuestionLibrarySubject trQuestionLibrarySubject = new TrQuestionLibrarySubject();
        trQuestionLibrarySubject.setId(QuestionId);
        EntityWrapper<TrQuestionLibrarySubject> entityWrapper = new EntityWrapper(trQuestionLibrarySubject);
        return this.selectOne(entityWrapper);
    }

    @Override
    public QuestionLibrarySubjectVO selectQuestionLibrarySubject(Long id) {
        //获取试题信息
        TrQuestionLibrarySubject questionLibrarySubject = this.selectById(id);
        if (questionLibrarySubject == null) {
            return null;
        }
        QuestionLibrarySubjectVO questionLibrarySubjectVO = new QuestionLibrarySubjectVO();

        BeanUtils.copyProperties(questionLibrarySubject, questionLibrarySubjectVO);

        //获取试题下所有选项
        TrQuestionSubjectOption trQuestionSubjectOption = new TrQuestionSubjectOption();
        trQuestionSubjectOption.setSubjectId(questionLibrarySubjectVO.getId());
        trQuestionSubjectOption.setState(1);
        EntityWrapper<TrQuestionSubjectOption> wrapper = new EntityWrapper(trQuestionSubjectOption);
        List<TrQuestionSubjectOption> trQuestionSubjectOptions = trQuestionSubjectOptionMapper.selectList(wrapper);

        List<QuestionSubjectOptionVO> questionSubjectOptionVOS = new ArrayList<QuestionSubjectOptionVO>();
        QuestionSubjectOptionVO questionSubjectOptionVO;
        for (TrQuestionSubjectOption obj : trQuestionSubjectOptions) {
            questionSubjectOptionVO = new QuestionSubjectOptionVO();
            BeanUtils.copyProperties(obj, questionSubjectOptionVO);
            questionSubjectOptionVOS.add(questionSubjectOptionVO);
        }
        questionLibrarySubjectVO.setQuestionSubjectOptionVOList(questionSubjectOptionVOS);
        return questionLibrarySubjectVO;
    }

    public List<TrQuestionLibrarySubject> selectQuestion() {
        TrQuestionLibrarySubject trQuestionLibrarySubject = new TrQuestionLibrarySubject();
        EntityWrapper<TrQuestionLibrarySubject> wrapper = new EntityWrapper(trQuestionLibrarySubject);
        return this.selectList(wrapper);
    }

    /**
     * 找到不同的题库各自有多少题目
     */
    public Integer subjectSumNum(Long id) {
        // TODO Auto-generated method stub
        TrQuestionLibrarySubject trQuestionLibrarySubject = new TrQuestionLibrarySubject();
        trQuestionLibrarySubject.setLibraryId(id); // 根据题库id找到有多少题
        EntityWrapper<TrQuestionLibrarySubject> wrapper = new EntityWrapper<TrQuestionLibrarySubject>(
                trQuestionLibrarySubject);
        return this.selectCount(wrapper);
    }

    public List<TrQuestionLibrarySubject> selectQuestionByLibraryId(Long libraryId, Integer pageNo, Integer pageSize, String key, Integer type) {
        Integer start = (pageNo - 1) * pageSize;
        List<TrQuestionLibrarySubject> trQuestionLibrarySubjects = trQuestionLibrarySubjectMapper.selectLibrarySubjects(libraryId, key, type, start, pageSize);
        return trQuestionLibrarySubjects;
    }

    /**
     * 考试试题列表
     */
    public Page<SelectQuestionVO> listExamQuestion(Map<String, Object> map, Page<SelectQuestionVO> page) {
        List<SelectQuestionVO> list = trQuestionLibrarySubjectMapper.listExamQuestion(page, map);
        return page.setRecords(list);
    }

    @Override
    public Boolean questionDeleteBatch(List<Long> ids) {
        TrQuestionLibrarySubject trQuestionLibrarySubject = null;
        List<TrQuestionLibrarySubject> list = new ArrayList<TrQuestionLibrarySubject>();
        for (Long id : ids) {
            trQuestionLibrarySubject = new TrQuestionLibrarySubject();
            trQuestionLibrarySubject.setId(id);
            trQuestionLibrarySubject.setState(0);
            list.add(trQuestionLibrarySubject);
        }
        return this.updateBatchById(list);
    }

    @Override
    public List<TrQuestionLibrarySubject> selectQuestionByLibrarySubjectId(List<TrExamQuestion> trExamQuestions) {
        return trQuestionLibrarySubjectMapper.selectQuestionByLibrarySubjectId(trExamQuestions);

    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public Long insert(TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO) {
        int insertOptionCount;
        Long id = null;
        Date createTime = new Date();
        try {
            TrQuestionLibrarySubject trQuestionLibrarySubject = new TrQuestionLibrarySubject();
            BeanUtils.copyProperties(trQuestionLibrarySubjectVO, trQuestionLibrarySubject);
            id = idGenerator.generate();
            trQuestionLibrarySubject.setId(id);
            trQuestionLibrarySubject.setCompanyId(trQuestionLibrarySubjectVO.getCompanyId());
            trQuestionLibrarySubject.setSiteId(trQuestionLibrarySubjectVO.getSiteId());
            trQuestionLibrarySubject.setCreateById(trQuestionLibrarySubjectVO.getAccountId());
            trQuestionLibrarySubject.setCreateByName(trQuestionLibrarySubjectVO.getAccountName());
            trQuestionLibrarySubject.setOrgId(trQuestionLibrarySubjectVO.getOrgId());
            trQuestionLibrarySubject.setUpdateById(trQuestionLibrarySubjectVO.getAccountId());
            trQuestionLibrarySubject.setUpdateByName(trQuestionLibrarySubjectVO.getAccountName());
            trQuestionLibrarySubject.setCreateTime(createTime);
            trQuestionLibrarySubject.setUpdateTime(createTime);
            List<TrQuestionSubjectOptionVO> trQuestionSubjectOptionVOS = trQuestionLibrarySubjectVO.getTrQuestionSubjectOptionVOList();
            if (trQuestionLibrarySubjectVO.getType() == 2) {
                int rightAnserNum = 0;
                for (TrQuestionSubjectOptionVO trQuestionSubjectOptionVO1 : trQuestionSubjectOptionVOS) {
                    if (trQuestionSubjectOptionVO1.getIsAnswer() == 1) {
                        rightAnserNum++;
                    }
                }
                if (rightAnserNum<=1){
                    return null;
                }
            }
            //新增试题
            int count = trQuestionLibrarySubjectMapper.insert(trQuestionLibrarySubject);

            if (count > 0 && null != trQuestionSubjectOptionVOS) {
                TrQuestionSubjectOption trQuestionSubjectOption = new TrQuestionSubjectOption();
                //新增选项

                for (TrQuestionSubjectOptionVO trQuestionSubjectOptionVO : trQuestionSubjectOptionVOS) {
                    BeanUtils.copyProperties(trQuestionSubjectOptionVO, trQuestionSubjectOption);
                    trQuestionSubjectOption.setId(idGenerator.generate());
                    trQuestionSubjectOption.setSubjectId(trQuestionLibrarySubject.getId());
                    trQuestionSubjectOption.setCreateById(trQuestionLibrarySubjectVO.getAccountId());
                    trQuestionSubjectOption.setCreateByName(trQuestionLibrarySubjectVO.getAccountName());
                    trQuestionSubjectOption.setUpdateById(trQuestionLibrarySubjectVO.getAccountId());
                    trQuestionSubjectOption.setUpdateByName(trQuestionLibrarySubjectVO.getAccountName());
                    trQuestionSubjectOption.setCreateTime(createTime);
                    trQuestionSubjectOption.setUpdateTime(createTime);
                    insertOptionCount = trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption);
                    if (insertOptionCount <= 0) {
                        return null;
                    }
                }
                return id;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return id;
    }

	/*@Override
	public int update(TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO) {
		Date date = new Date();
		TrQuestionLibrarySubject trQuestionLibrarySubject = new TrQuestionLibrarySubject();
		BeanUtils.copyProperties(trQuestionLibrarySubjectVO,trQuestionLibrarySubject);
		trQuestionLibrarySubject.setUpdateTime(date);
		trQuestionLibrarySubject.setUpdateById(trQuestionLibrarySubjectVO.getAccountId());
		trQuestionLibrarySubject.setUpdateByName(trQuestionLibrarySubjectVO.getAccountName());

		return trQuestionLibrarySubjectMapper.updateById(trQuestionLibrarySubject);
	}*/

    @Override
    public int update(TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO) {
        Date date = new Date();
        TrQuestionLibrarySubject trQuestionLibrarySubject = new TrQuestionLibrarySubject();
        BeanUtils.copyProperties(trQuestionLibrarySubjectVO, trQuestionLibrarySubject);
        trQuestionLibrarySubject.setUpdateTime(date);
        trQuestionLibrarySubject.setUpdateById(trQuestionLibrarySubjectVO.getAccountId());
        trQuestionLibrarySubject.setUpdateByName(trQuestionLibrarySubjectVO.getAccountName());

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("subject_id", trQuestionLibrarySubjectVO.getId());
        map.put("state", 1);
        trQuestionSubjectOptionService.deleteByMap(map);

        List<TrQuestionSubjectOptionVO> subjectList = trQuestionLibrarySubjectVO.getTrQuestionSubjectOptionVOList();
        List<TrQuestionSubjectOption> list = new ArrayList<TrQuestionSubjectOption>();
        TrQuestionSubjectOption subject = null;
        if (!CollectionUtils.isEmpty(subjectList)) {
            for (TrQuestionSubjectOptionVO vo : subjectList) {
                subject = new TrQuestionSubjectOption();
                BeanUtils.copyProperties(vo, subject);
                Long subjectId = subject.getSubjectId();
                if (null == subjectId){
                    subject.setSubjectId(trQuestionLibrarySubjectVO.getId());
                }
                subject.setId(idGenerator.generate());
                subject.setState(1);
                subject.setCreateById(trQuestionLibrarySubjectVO.getAccountId());
                subject.setCreateByName(trQuestionLibrarySubjectVO.getAccountName());
                subject.setCreateTime(date);

                subject.setUpdateById(trQuestionLibrarySubjectVO.getAccountId());
                subject.setUpdateByName(trQuestionLibrarySubjectVO.getAccountName());
                subject.setUpdateTime(date);
                list.add(subject);
            }
        }

        if (!CollectionUtils.isEmpty(list)) {
            trQuestionSubjectOptionService.insertBatch(list);
        }
        return trQuestionLibrarySubjectMapper.updateById(trQuestionLibrarySubject);
    }

    @Override
    public List<LibrarySubjectVO> selectLibrarySubjectList(ContextAndPageSizeVO contextAndPageSizeVO) {
        Integer start = (contextAndPageSizeVO.getPageNo() - 1) * contextAndPageSizeVO.getPageSize();
        return trQuestionLibrarySubjectMapper.selectLibrarySubjectList(contextAndPageSizeVO.getLibraryKey(), contextAndPageSizeVO.getStemKey(), contextAndPageSizeVO.getType(), start, contextAndPageSizeVO.getPageSize(), contextAndPageSizeVO.getCompanyId(), contextAndPageSizeVO.getSiteId(), contextAndPageSizeVO.getOrgIds(), contextAndPageSizeVO.getExamId(), contextAndPageSizeVO.getLibraryId());
    }

    @Override
    public Integer selectLibrarySubjectCount(ContextAndPageSizeVO contextAndPageSizeVO) {
        return trQuestionLibrarySubjectMapper.selectLibrarySubjectCount(contextAndPageSizeVO.getLibraryId(), contextAndPageSizeVO.getLibraryKey(), contextAndPageSizeVO.getStemKey(), contextAndPageSizeVO.getType(), contextAndPageSizeVO.getCompanyId(), contextAndPageSizeVO.getSiteId(), contextAndPageSizeVO.getOrgIds(), contextAndPageSizeVO.getExamId());
    }

    @Override
    public Integer selectLibrarySubjectsCount(Long libraryId, String key, Integer type) {
        return trQuestionLibrarySubjectMapper.selectLibrarySubjectsCount(libraryId, type, key);
    }

    @Override
    public Integer selectIsUser(Long id) {
        return trQuestionLibrarySubjectMapper.selectIsUser(id);
    }

    @Override
    public boolean insertList(List<TrQuestionLibrarySubjectVO> trQuestionLibrarySubjectVOList) {
        boolean isOk = true;
        if (!CollectionUtils.isEmpty(trQuestionLibrarySubjectVOList)) {
            for (TrQuestionLibrarySubjectVO trQuestionLibrarySubjectVO : trQuestionLibrarySubjectVOList) {
                Long result = this.insert(trQuestionLibrarySubjectVO);
                if (null == result) {
                    isOk = false;
                }
            }
        }
        return isOk;
    }

}
