/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamQuestionClient
 * Author:   phone
 * Date:     2018/3/21 15:12
 * Description: 考试题目
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.domain.TrExamQuestion;
import com.yizhi.exam.application.vo.ExamQuestionVO;
import com.yizhi.exam.application.vo.QuestionPreview;
import com.yizhi.exam.application.vo.exam.SortVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br> 
 * 〈考试题目〉
 *
 * @author fanchunhui
 * @create 2018/3/21
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "ExamQuestionClient")
public interface ExamQuestionClient {

    /**
     * 获得考试试题
     *
     * @return
     */
    @GetMapping("/manage/exam/question/list")
    Map<String,Object> getQuestionList(@RequestParam("pageNo") Integer pageNo,@RequestParam("pageSize") Integer pageSize,@RequestParam("examId") Long examId);

    @PostMapping("/manage/exam/question/insert")
    boolean insert(@RequestBody ExamQuestionVO examQuestionVO);

    @GetMapping ("/manage/exam/question/exam/preview")
    QuestionPreview examPreview(@RequestParam("examTitleId")Long examTitleId);

    /**
     * 修改试题分数
     */
    @PostMapping("/manage/exam/question/update/score")
    boolean updateScoreById(@RequestBody ExamQuestionVO examQuestionVO);

    /**
     * 问题上下调换顺序
     * */
    @PostMapping("/manage/exam/question/move")
    boolean move(@RequestBody List<SortVO> sortVOS);

    @PostMapping("/manage/exam/question/delete/all")
    Integer deleteAllById(@RequestBody List<Long> id);

    @GetMapping("/manage/exam/question/count")
    Integer selectQuestionCountByExamId(@RequestParam("examId") Long examId);

    /**
     * 保存一条考试题目
     * */
    @PostMapping("/manage/exam/question/save/one")
    Long insertOne(@RequestBody TrExamQuestion trExamQuestion);

    @PostMapping("/manage/exam/question/update/question")
    Integer updateQuestion(@RequestBody ExamQuestionVO examQuestionVO);
}