package com.yizhi.exam.application.vo;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 系统出题规则
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrExamSystemQuestionVO", description = "系统出题规则")
@Data
public class TrExamSystemQuestionVO {

	@ApiModelProperty(value = "系统出题规则ID")
	private Long id;

	@ApiModelProperty(value = "考试主键_ID，外键")
	private Long examId;

	@ApiModelProperty(value = "题库ID主键，外键")
	private Long libraryId;

	@ApiModelProperty(value = "题库名称")
	private Long libraryName;

	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "抽题数量")
	private Integer num;

	@ApiModelProperty(value = "总分数")
	private BigDecimal score;

	@ApiModelProperty(value = "状态，0删除 1有效，默认1")
	private Integer state;

	@ApiModelProperty(value = "用户ID")
	private Long accountId;

	@ApiModelProperty(value = "用户名")
	private String accountName;
}
