package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 考试
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "Exam", description = "考试")
@Data

public class Exam {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "考试主键ID")
	private Long id;

	@ApiModelProperty(value = "考试编码，系统自动生成考试编码。编码规则，按创建顺序累加，例如KS000001，KS000002")
	
	private String examNo;

	@ApiModelProperty(value = "考试名称")
	private String name;

	@ApiModelProperty(value = "考试说明")
	private String description;

	@ApiModelProperty(value = "开始时间")
	
	private Date startTime;

	@ApiModelProperty(value = "结束时间")
	
	private Date endTime;

	@ApiModelProperty(value = "答卷时长，0无限制 >0有限制(分钟)")
	private Integer duration;

	@ApiModelProperty(value = "答题次数，0无限制 >0有限次(次)")
	
	private Integer answerNum;

	@ApiModelProperty(value = "考试次数，允许考试参加的次数")
	
	private Integer examNum;

	@ApiModelProperty(value = "合格分，本次考试的合格分")
	
	private Integer qualifiedScore;

	@ApiModelProperty(value = "出题策略，1手动出题 2系统出题")
	
	private Integer makeStrategy;

	@ApiModelProperty(value = "系统出题_出题策略，1手动出题（每个学员使用同一份试卷） 2系统出题（每个学员使用不同试卷）")
	
	private Integer sysMakeStrategy;

	@ApiModelProperty(value = "题干排序，1默认排序 2题型排序 3随机排序")
	
	private Integer stemSort;

	@ApiModelProperty(value = "题型排序，1默认排序 2随机排序")
	
	private Integer typeSort;

	@ApiModelProperty(value = "选项排序，1默认排序 2随机排序")
	
	private Integer optionSort;

	@ApiModelProperty(value = "考试范围，1平台用户可见 2指定用户可见")
	
	private Integer visibleRange;

	@ApiModelProperty(value = "呈现样式，1整页呈现 2逐题呈现")
	
	private Integer pageMode;

	@ApiModelProperty(value = "显示答卷，0不显示 1交卷后显示 2考试结束后显示")
	
	private Integer isAnswerPaper;

	@ApiModelProperty(value = "显示成绩，0不显示 1交卷后显示 2考试结束后显示")
	
	private Integer isScore;

	@ApiModelProperty(value = "显示答案，0不显示 1交卷后显示 2考试结束后显示")
	
	private Integer isAnswer;

	@ApiModelProperty(value = "显示解析，0不显示 1交卷后显示 2考试结束后显示")
	
	private Integer isAnalysis;

	@ApiModelProperty(value = "显示通用分评价，0不显示 1交卷后显示 2考试结束后显示")
	
	private Integer isPaperid;

	@ApiModelProperty(value = "是否使用积分，0不使用 1使用，默认0")
	
	private Integer isPoint;

	@ApiModelProperty(value = "提醒设置，0否 1是，默认0")
	private Integer remind;

	@ApiModelProperty(value = "状态，0删除 1未上架 2上架 3下架")
	private Integer state;

	@ApiModelProperty(value = "原考试编码，复制考试时记录来源")
	
	private String oldExamNo;

	@ApiModelProperty(value = "创建时间")
	
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;

	@ApiModelProperty(value = "企业_ID")
	
	private Long companyId;

	@ApiModelProperty(value = "部门_ID")
	
	private Long orgId;

	@ApiModelProperty(value = "站点_ID")
	
	private Long siteId;
	
	@ApiModelProperty(value = "培训项目_ID")
	
	private Long trainingProjectId;

	@ApiModelProperty(value = "上架时间")
	
	private Date upTime;

	@ApiModelProperty(value = "下架时间")
	
	private Date downTime;

	@ApiModelProperty(value = "题库id")
	
	private Long libraryId;

	@ApiModelProperty(value = "题库名称")
	
	private String libraryName;

	@ApiModelProperty(value = "关键字,逗号分隔")
	
	private String keywords;

    @ApiModelProperty(value = "考试图片logo")
    private String image;

	@ApiModelProperty(value = "是否启用在日历任务中显示")
	
	private Integer enableTask;

}
