package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 题库
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "QuestionLibrary", description = "题库")
@Data

public class QuestionLibrary {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "题库ID主键")
	private Long id;

	@ApiModelProperty(value = "题库编码，系统自动生成题库的编码，按创建顺序累加，例如QS000001，QS000002")
	
	private String libraryNo;

	@ApiModelProperty(value = "题库名称，最多可输入20个汉字")
	private String name;

	@ApiModelProperty(value = "题库标签，多个用逗号分割")
	
	private String libraryLabel;

	@ApiModelProperty(value = "状态，0删除 1未使用 1已使用，默认1")
	private Integer state;

	@ApiModelProperty(value = "备注")
	private String comments;

	@ApiModelProperty(value = "创建时间")
	
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;

	@ApiModelProperty(value = "企业_ID")
	
	private Long companyId;

	@ApiModelProperty(value = "部门_ID")
	
	private Long orgId;

	@ApiModelProperty(value = "站点_ID")
	
	private Long siteId;

}
