package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 答卷
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrExamAnswer", description = "答卷")
@Data

public class TrExamAnswer  {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "答卷ID，主键")
    private Long id;

    @ApiModelProperty(value = "考试主键_ID，外键")
    
    private Long examId;

    @ApiModelProperty(value = "学员_ID")
    
    private Long accountId;

    @ApiModelProperty(value = "开始时间，用户进入考试的时间")
    
    private Date startTime;

    @ApiModelProperty(value = "交卷时间")
    
    private Date submitTime;

    @ApiModelProperty(value = "考试用时（分钟）")
    private Integer duration;

    @ApiModelProperty(value = "考试终端类型，1微信 2PC 3APP")
    
    private Integer terminalType;

    @ApiModelProperty(value = "考试总分数")
    private BigDecimal score;

    @ApiModelProperty(value = "交卷状态：0未交卷 1已交卷 2已阅卷，默认0")
    
    private Integer state;

    @ApiModelProperty(value = "创建时间")
    
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    
    private String updateByName;

    @ApiModelProperty(value = "企业_ID")
    
    private Long companyId;

    @ApiModelProperty(value = "部门_ID")
    
    private Long orgId;

    @ApiModelProperty(value = "站点_ID")
    
    private Long siteId;

    @ApiModelProperty("培训项目关联ID,在培训项目中发起投票,保存对应关系")
    
    private Long trainingProjectId;


}
