package com.yizhi.exam.application.vo.exam;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotations.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "ExamDetailsVO", description = "考试详情")
@Data
public class ExamDetailsVO {
	@ApiModelProperty(value = "考试主键ID")
	private Long id;

	@ApiModelProperty(value = "考试名称")
	private String name;

	@ApiModelProperty(value = "考试说明")
	private String description;

	@ApiModelProperty(value = "开始时间")
	private Date startTime;

	@ApiModelProperty(value = "考试总分数")
	private BigDecimal score;
 
	@ApiModelProperty(value = "考试策略")
	private Integer makeStrategy;

	@ApiModelProperty(value = "答题数量")
	private Integer sumQuestion;

	@ApiModelProperty(value = "结束时间")
	private Date endTime;
	
	@ApiModelProperty(value = "呈现样式，1整页呈现 2逐题呈现")
	private Integer pageMode;

	@ApiModelProperty(value = "答卷时长，0无限制 >0有限制(分钟)")
	private Integer duration;

	@ApiModelProperty(value = "考试次数，0无限制 >0有限次(次)")
	private Integer answerNum;

	@ApiModelProperty(value = "已参加的考试次数")
	private Integer examNum;

	@ApiModelProperty(value = "合格分，本次考试的合格分")
	private Integer qualifiedScore;

	@ApiModelProperty(value = "是否考试完成，0:开始考试 1:继续考试")
	private Integer isExam;

	@ApiModelProperty("最后一次答卷ID")
	private Long answerId;
	
	@ApiModelProperty("扫描考试失败code:1成功 0失败")
	private Integer scanCode = 0;
	
	@ApiModelProperty("扫描考试失败code:1成功 0失败")
	private String scanMsg = "";
	
	@ApiModelProperty("培训项目关联ID,在培训项目中发起投票,保存对应关系")
	@TableField(value = "training_project_id")
	private Long trainingProjectId;
	
	@ApiModelProperty(value = "是否有考试次数，0:没有 1:有")
	private Integer isEndExam;
	
}
