package com.yizhi.exam.application.vo.exam;

import com.yizhi.exam.application.vo.report.PcAnswerQuestionDetailVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
@Api(tags = "PcStudentExamAnswerVo", description = "查看考生答卷")
public class PcStudentExamAnswerVo {
	@ApiModelProperty(value = "类型 answerPaper")
	String type;

	@ApiModelProperty(value = "显示答案，0不显示 1显示")
	Integer isAnswer;
	
	@ApiModelProperty(value = "显示解析，0不显示 1显示")
	Integer isAnalysis;
	
	@ApiModelProperty(value = "显示分数，0不显示 1显示/pc端, 1显示 2批阅中 3考试结束后显示 4管理员已关闭显示")
	Integer isScore;

	@ApiModelProperty(value = "是否显示答卷, 0不显示 1显示/pc端, 1显示 2考试结束后显示 3管理员已关闭显示")
	Integer isAnswerPaper;

	@ApiModelProperty(value = "显示评价")
	String evaluate;
	
	@ApiModelProperty(value = "页码")
	Integer pageNo;

	@ApiModelProperty(value = "每页显示数量")
	Integer pageSize;
	
	@ApiModelProperty(value = "总题量")
	Integer pageTotal;
	
	@ApiModelProperty(value = "考试用时")
	Integer duration;
	
	@ApiModelProperty(value = "分数")
	BigDecimal score;	
	
	@ApiModelProperty(value = "试题")
	List<PcAnswerQuestionDetailVO> questions;

	ExamDetailsVO examDetailsVO;

	@ApiModelProperty(value = "是否存在主观题 1 存在 0不存在")
	private Integer isres;

	@ApiModelProperty(value = "考试合格分")
	private Integer scoreSuccess;


}
