package com.yizhi.exam.application.vo.exam;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Ding
 * @className ReadOnLineExamExportVO
 * @description TODO
 * @date 2019/6/4
 **/

@ApiModel("按考试统计（按用户统计）")
@Data
public class ReadOnLineExamExportVO {

    @ApiModelProperty("用户ID")
    private Long accountId;

    @ApiModelProperty("用户")
    private String accountName;

    @ApiModelProperty("姓名")
    private String accountFullName;

    @ApiModelProperty("所在部门")
    private String orgName;

    @ApiModelProperty("所属部门上级部门")
    private String orgParentNames;

    @ApiModelProperty("考试开始时间")
    private Date startTime;

    @ApiModelProperty("交卷时间")
    private Date finishTime;

    @ApiModelProperty("答卷时长")
    private Integer duration;

    @ApiModelProperty("考试分数/最高分")
    private BigDecimal score;

    @ApiModelProperty("客观题得分")
    private BigDecimal objectiveScore;

    @ApiModelProperty("主观题得分")
    private BigDecimal subjectiveScore;

    @ApiModelProperty("考试结果")
    private Integer examState;

    @ApiModelProperty("参加状态")
    private Integer joinState;

    @ApiModelProperty("交卷状态")
    private Integer submitState;

    @ApiModelProperty("阅卷情况 1:未阅卷 2:已阅卷")
    private Integer state;

    @ApiModelProperty("用户状态")
    private Integer accountState;


}
