package com.yizhi.exam.application.vo.exam;

import com.baomidou.mybatisplus.annotations.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 学生试卷
 * 
 * @author mei
 * @create 2018/3/14
 */

@ApiModel(value = "StudentExamPaperVO", description = "学生试卷")
public class StudentExamPaperVO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -28941195500514350L;

	/*@ApiModelProperty(value = "全局唯一(Key值，用于从缓存中获取数据)")
	private String examPaperId;*/

	@ApiModelProperty(value = "考生ID")
	private Long accountId;

	@ApiModelProperty(value = "考试ID")
	private Long examId;
	
	@ApiModelProperty(value = "答卷ID，为null首次参加考试新增，非null继续考试")
	private Long answerId;

	@ApiModelProperty(value = "总题数")
	private Integer questionNumber;

	@ApiModelProperty(value = "已答题数")
	private Integer answersNumber;
	
	@ApiModelProperty(value = "呈现样式，1整页呈现 2逐题呈现")
	private Integer pageMode;
	
	@ApiModelProperty(value = "答卷时长，0无限制 >0有限制(分钟)？0表示没有时间超时；-1表示时间无限制；大于0表示限制时间")
	private Integer duration;
	
	@ApiModelProperty(value = "答题次数，0无限制 >0有限次(次)")
	private Integer answerNum;
		
	@ApiModelProperty(value = "合格分，本次考试的合格分")
	private Integer qualifiedScore;

	@ApiModelProperty(value = "每页显示记录数，默认10")
	private Integer pageSize;
	
	@ApiModelProperty(value = "页数")
	private Integer pageNo;
	
	@ApiModelProperty(value = "必答试题")
	List<QuestionListVO> questions;

	@ApiModelProperty(value = "答题卡列表")
	List<CardVO> cardVOS;

	@ApiModelProperty(value = "企业ID")
	Long companyId;

	@ApiModelProperty(value = "站点ID")
	Long siteId;

	@ApiModelProperty(value = "操作人姓名")
	String accountName;

	@ApiModelProperty(value = "部门ID")
	Long orgId;

	@ApiModelProperty(value = "总数")
	Integer pageTotal;

	@ApiModelProperty("答卷时间VO")
	AnswerTimeVO answerTimeVO;
	
	@ApiModelProperty("培训项目关联ID,在培训项目中发起投票,保存对应关系")
	@TableField(value = "training_project_id")
	private Long trainingProjectId;

	@ApiModelProperty(value = "是否有未完成的考试,0有未完成(弹框提示继续考试)")
	private Integer isFinished;

	@ApiModelProperty(value = "考试是否有次数")
	private Integer isExamAnswerGoOn;

	public Integer getIsFinished() {
		return isFinished;
	}

	public void setIsFinished(Integer isFinished) {
		this.isFinished = isFinished;
	}

	public Integer getIsExamAnswerGoOn() {
		return isExamAnswerGoOn;
	}

	public void setIsExamAnswerGoOn(Integer isExamAnswerGoOn) {
		this.isExamAnswerGoOn = isExamAnswerGoOn;
	}



	public AnswerTimeVO getAnswerTimeVO() {
		return answerTimeVO;
	}

	public void setAnswerTimeVO(AnswerTimeVO answerTimeVO) {
		this.answerTimeVO = answerTimeVO;
	}

	public Long getAccountId() {
		return accountId;
	}

	public void setAccountId(Long accountId) {
		this.accountId = accountId;
	}

	public Long getExamId() {
		return examId;
	}

	public void setExamId(Long examId) {
		this.examId = examId;
	}

	public Long getAnswerId() {
		return answerId;
	}

	public void setAnswerId(Long answerId) {
		this.answerId = answerId;
	}

	public Integer getQuestionNumber() {
		return questionNumber;
	}

	public void setQuestionNumber(Integer questionNumber) {
		this.questionNumber = questionNumber;
	}

	public Integer getAnswersNumber() {
		return answersNumber;
	}

	public void setAnswersNumber(Integer answersNumber) {
		this.answersNumber = answersNumber;
	}

	public Integer getPageMode() {
		return pageMode;
	}

	public void setPageMode(Integer pageMode) {
		this.pageMode = pageMode;
	}

	public Integer getDuration() {
		return duration;
	}

	public void setDuration(Integer duration) {
		this.duration = duration;
	}

	public Integer getAnswerNum() {
		return answerNum;
	}

	public void setAnswerNum(Integer answerNum) {
		this.answerNum = answerNum;
	}

	public Integer getQualifiedScore() {
		return qualifiedScore;
	}

	public void setQualifiedScore(Integer qualifiedScore) {
		this.qualifiedScore = qualifiedScore;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getPageNo() {
		return pageNo;
	}

	public void setPageNo(Integer pageNo) {
		this.pageNo = pageNo;
	}

	public List<QuestionListVO> getQuestions() {
		return questions;
	}

	public void setQuestions(List<QuestionListVO> questions) {
		this.questions = questions;
	}

	public List<CardVO> getCardVOS() {
		return cardVOS;
	}

	public void setCardVOS(List<CardVO> cardVOS) {
		this.cardVOS = cardVOS;
	}

	public Long getCompanyId() {
		return companyId;
	}

	public void setCompanyId(Long companyId) {
		this.companyId = companyId;
	}

	public Long getSiteId() {
		return siteId;
	}

	public void setSiteId(Long siteId) {
		this.siteId = siteId;
	}

	public String getAccountName() {
		return accountName;
	}

	public void setAccountName(String accountName) {
		this.accountName = accountName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getPageTotal() {
		return pageTotal;
	}

	public void setPageTotal(Integer pageTotal) {
		this.pageTotal = pageTotal;
	}

	public Long getTrainingProjectId() {
		return trainingProjectId;
	}

	public void setTrainingProjectId(Long trainingProjectId) {
		this.trainingProjectId = trainingProjectId;
	}
}
