package com.yizhi.exam.application.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 考试统计按用户分组统计
 * @author mei
 *
 */
@ApiModel("按考试统计（按用户统计）")
@Data
public class ReportExamAccountsViewVo {

    @ApiModelProperty("用户ID")
    private Long accountId;

    @ApiModelProperty("用户")
    private String accountName;

    @ApiModelProperty("姓名")
    private String accountFullName;

    @ApiModelProperty("所在部门id")
    private Long orgId;

    @ApiModelProperty("所在部门")
    private String orgName;

    @ApiModelProperty("所属部门上级部门")
    private String orgParentNames;

    @ApiModelProperty("考试次数")
    private Integer examCount;

    @ApiModelProperty("交卷时间/最早交卷时间")
    private Date finishTime;

    @ApiModelProperty("交卷时间/最晚交卷时间")
    private Date lastFinishTime;

    @ApiModelProperty("考试分数/最高分")
    private BigDecimal score;

    @ApiModelProperty("考试结果")
    private Integer examState;

    @ApiModelProperty("阅卷情况 1:未阅卷 2:已阅卷")
    private Integer state;

    @ApiModelProperty("获得积分")
    private Integer point;

    @ApiModelProperty("用户状态")
    private Integer accountState;

    @ApiModelProperty("考试开始时间")
    private Date startTime;

    @ApiModelProperty("考试时长")
    private Long duration;


}
