package com.yizhi.application.cache.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 考试缓存删除注解信息，在方法上声明
 * 支持SpEL表达式编写
 * @author mei
 *
 */
@Target({ ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface ExamCachDel {
	/**
	 * 缓存名称
	 * 
	 */
	String cacheName();
	
	/**
	 * 缓存 key
	 * 
	 */
	String cacheKey();
}
