package com.yizhi.application.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.domain.TrExamSystemQuestion;
import com.yizhi.exam.application.vo.ExamSystemQuestionVO;
import com.yizhi.exam.application.vo.QuestionPreview;
import com.yizhi.application.service.ITrExamSystemQuestionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈系统出题规则控制器〉
 *
 * @author phone
 * @create 2018/5/25
 * @since 1.0.0
 */
@RestController
@RequestMapping("/manage/exam/system/question")
public class ExamSystemQuestionController {

    private static final Logger Log = LoggerFactory.getLogger(TrExamQuestionController.class);

    @Autowired
    ITrExamSystemQuestionService trExamSystemQuestionService;

    /**
     * 新增系统出题规则
     * */
    @PostMapping("/insert/all")
    public boolean insert(@RequestBody ExamSystemQuestionVO examSystemQuestionVO){
        boolean result = false;
        try{
        	TrExamSystemQuestion sysQus = new TrExamSystemQuestion();
        	sysQus.setExamId(examSystemQuestionVO.getExamId()); 
            EntityWrapper<TrExamSystemQuestion> wrapper = new EntityWrapper<TrExamSystemQuestion>(sysQus);
        	trExamSystemQuestionService.delete(wrapper);
        	
            result = trExamSystemQuestionService.insertAll(examSystemQuestionVO);
        }catch (Exception e){
            Log.error("新增系统出题规则错误服务：",e);
            e.printStackTrace();
        }
        return result;
    }

    @GetMapping("/select")
    public List<QuestionPreview> selectExamSystemQuestion(@RequestParam("examId") Long examId){
        return trExamSystemQuestionService.selectExamSystemQuestion(examId);
    }

}