package com.yizhi.application.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.service.ITrExamAnswerService;
import com.yizhi.core.application.enums.FileType;
import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.file.domain.TemplateColumn;
import com.yizhi.core.application.file.exp.AbstractExporter;
import com.yizhi.exam.application.vo.AnswerDetailVO;
import com.yizhi.exam.application.vo.AnswerQuestionDetailVO;
import com.yizhi.exam.application.vo.ExamAnswerByUserVO;
import com.yizhi.exam.application.vo.ExamAnswerVO;
import com.yizhi.exam.application.vo.exam.StatisticalCountVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;


/**
 * <p>
 * 答卷 前端控制器
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@RestController
@RequestMapping("/manage/exam")
public class TrExamAnswerController {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(ExamController.class);
    @Autowired
    private ITrExamAnswerService iTrExamAnswerService;

    @PostMapping("/count/account/answer")
    public AnswerDetailVO getAnswer(
            @RequestParam(name = "examId") Long examId,
            @RequestParam(name = "examNum", required = false, defaultValue = "1") Integer examNum,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
            @RequestParam(name = "pageSize", required = false, defaultValue = "20") Integer pageSize,
            @RequestParam(name = "accountId", required = false) Long accountId
    ) {
        AnswerDetailVO answerDetailVO = null;
        try {
            answerDetailVO = iTrExamAnswerService.answerDetail(accountId, examNum, pageNo, pageSize, examId);
            return answerDetailVO;
        } catch (Exception e) {
            LOG.error("", e);
            e.printStackTrace();
            return answerDetailVO;
        }
    }

    @PostMapping("/export/result")
    public boolean getExamAnswer(HttpServletResponse response,
                                 @RequestParam(name = "examId", required = true) Long examId
    ) {
        Boolean b = false;
        try {
            List<ExamAnswerVO> list = iTrExamAnswerService.getExamAnswer(examId);
            Template template = new Template();
            List<TemplateColumn> templateColumns = new LinkedList<TemplateColumn>();
            String[] strings = new String[]{"用户名", "姓名", "所在组织", "交卷时间", "考试次数", "最高得分", "考试结果"};
            String[] strings1 = new String[]{"name", "realName", "orgName", "submitName", "count", "maxScore", "state"};
            TemplateColumn templateColumn;
            ExamAnswerVO examAnswerVO;
            for (int i = 0; i < strings.length; i++) {
                templateColumn = new TemplateColumn();
                templateColumn.setColumnName(strings[i]);
                templateColumn.setColumn(strings1[i]);
            }
            template.setColumns(templateColumns);
            FileType fileType = FileType.XLSX;
            AbstractExporter<ExamAnswerVO> exporter = AbstractExporter.build(fileType, response, template, list);
            exporter.handle();
            b = true;
            return b;

        } catch (Exception e) {
            LOG.error("", e);
            e.printStackTrace();
            return b;
        }
    }

    @PostMapping("/result/details")
    public Map<String, Object> answerQuestionDetail(
            @RequestParam(name = "answerId") Long answerId,
            @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo
    ) {
        //答卷详情，分页查询
        Page<AnswerQuestionDetailVO> pageList = iTrExamAnswerService.answerQuestionDetail(answerId, pageNo, pageSize);
        List<AnswerQuestionDetailVO> list = pageList.getRecords();
        Map<String, Integer> page = new HashMap<String, Integer>();
        page.put("pageNo", pageNo);
        page.put("pageSize", pageSize);
        page.put("pageTotal", pageList.getTotal());
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("page", page);
        return map;
    }

    /**
     * 根据考试ID查询交卷人数
     */
    @GetMapping("/submit/count")
    public int submitCount(@RequestParam("examId") Long examId) {
        return iTrExamAnswerService.submitCount(examId);
    }

    /**
     * 获取考试通过人数
     */
    @GetMapping("/select/count")
    public Integer selectByCount(@RequestParam("examId") Long examId) {
        return iTrExamAnswerService.selectByCount(examId);
    }

    /**
     * 获取考试总人数和总分数用来计算平均分和完成率
     */
    @GetMapping("/select/statical")
    public StatisticalCountVO selectStaticalCount(@RequestParam("examId") Long examId) {
        return iTrExamAnswerService.selectStaticalCount(examId);
    }

    @PostMapping("/statistical/exam/userDetail")
    public List<AnswerDetailVO> getAnswerDetailList(@RequestBody ExamAnswerByUserVO vo) {
        return iTrExamAnswerService.getAnswerDetailList(vo);
    }

    @GetMapping("/getEarlyPassExamIdByExamIds")
    public List<TrExamAnswer> getEarlyPassExamIdByExamIds(@RequestParam(name = "listIds", required = true) List<Long> listIds) {
        return iTrExamAnswerService.getEarlyPassExamIdByExamIds(listIds);
    }

    @GetMapping("/getMaxScore")
    public Integer getMaxScore(Long examId, Long accountId, Long companyId, Long siteId) {
        TrExamAnswer trExamAnswer = new TrExamAnswer();
        trExamAnswer.setExamId(examId);
        trExamAnswer.setAccountId(accountId);
        trExamAnswer.setState(2);
        trExamAnswer.setCompanyId(companyId);
        trExamAnswer.setSiteId(siteId);
        EntityWrapper<TrExamAnswer> entityWrapper = new EntityWrapper<>(trExamAnswer);
        entityWrapper.orderBy("score", false);
        List<TrExamAnswer> list = iTrExamAnswerService.selectList(entityWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0).getScore().intValue();
        }
        return null;
    }

}
